/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcSearchResultEntry;
import java.io.IOException;
import java.util.Iterator;

public class LDAPSearchResult
extends LDAPMessage {
    private LDAPEntry entry = null;

    public LDAPSearchResult() {
    }

    LDAPSearchResult(RfcLDAPMessage rfcLDAPMessage) {
        super(rfcLDAPMessage);
    }

    public LDAPSearchResult(LDAPEntry lDAPEntry, LDAPControl[] lDAPControlArray) {
        super(new RfcLDAPMessage(new RfcSearchResultEntry(new ASN1OctetString(lDAPEntry.getDN()), LDAPSearchResult.getEntrySequence(lDAPEntry)), LDAPSearchResult.RfcControlFactory(lDAPControlArray)));
        this.entry = lDAPEntry;
    }

    private static RfcControls RfcControlFactory(LDAPControl[] lDAPControlArray) {
        RfcControls rfcControls = new RfcControls();
        if (lDAPControlArray != null) {
            for (int i = 0; i < lDAPControlArray.length; ++i) {
                rfcControls.add(lDAPControlArray[i].getASN1Object());
            }
            return rfcControls;
        }
        return null;
    }

    private static ASN1Sequence getEntrySequence(LDAPEntry lDAPEntry) {
        if (lDAPEntry == null) {
            throw new IllegalArgumentException("Argument \"entry\" cannot be null");
        }
        Iterator iterator = lDAPEntry.getAttributeSet().iterator();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            LDAPAttribute lDAPAttribute = (LDAPAttribute)iterator.next();
            aSN1Sequence2.add(new ASN1OctetString(lDAPAttribute.getName()));
            ASN1Set aSN1Set = new ASN1Set();
            String[] stringArray = lDAPAttribute.getStringValueArray();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    aSN1Set.add(new ASN1OctetString(stringArray[i]));
                }
            }
            aSN1Sequence2.add(aSN1Set);
            aSN1Sequence.add(aSN1Sequence2);
        }
        return aSN1Sequence;
    }

    public LDAPEntry getEntry() {
        if (this.entry == null) {
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            ASN1Sequence aSN1Sequence = ((RfcSearchResultEntry)this.message.getResponse()).getAttributes();
            ASN1Object[] aSN1ObjectArray = aSN1Sequence.toArray();
            for (int i = 0; i < aSN1ObjectArray.length; ++i) {
                ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1ObjectArray[i];
                LDAPAttribute lDAPAttribute = new LDAPAttribute(((ASN1OctetString)aSN1Sequence2.get(0)).stringValue());
                ASN1Set aSN1Set = (ASN1Set)aSN1Sequence2.get(1);
                ASN1Object[] aSN1ObjectArray2 = aSN1Set.toArray();
                for (int j = 0; j < aSN1ObjectArray2.length; ++j) {
                    lDAPAttribute.addValue(((ASN1OctetString)aSN1ObjectArray2[j]).byteValue());
                }
                lDAPAttributeSet.add(lDAPAttribute);
            }
            this.entry = new LDAPEntry(((RfcSearchResultEntry)this.message.getResponse()).getObjectName().stringValue(), lDAPAttributeSet);
        }
        return this.entry;
    }

    public String toString() {
        String string = this.entry == null ? super.toString() : this.entry.toString();
        return string;
    }

    protected void setDeserializedValues(LDAPMessage lDAPMessage, RfcControls rfcControls) throws IOException, ClassNotFoundException {
        if (!(lDAPMessage instanceof LDAPSearchResult)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPSearchResult object");
        }
        LDAPSearchResult lDAPSearchResult = (LDAPSearchResult)lDAPMessage;
        LDAPEntry lDAPEntry = lDAPSearchResult.getEntry();
        lDAPSearchResult = null;
        this.message = new RfcLDAPMessage(new RfcSearchResultEntry(new ASN1OctetString(lDAPEntry.getDN()), LDAPSearchResult.getEntrySequence(lDAPEntry)), rfcControls);
        lDAPMessage = null;
    }
}

