/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;

@XmlType
@XmlEnum(value=String.class)
public enum SnmpVersion {
    V1("v1"),
    V2c("v2c"),
    V3("v3"),
    V2_INFORM("v2-inform"),
    V3_INFORM("v3-inform");

    private String m_version;

    private SnmpVersion(String version) {
        this.m_version = version;
    }

    public String stringValue() {
        return this.m_version;
    }

    public int intValue() {
        if (this.isV1()) {
            return 1;
        }
        if (this.isV2()) {
            return 2;
        }
        if (this.isV3()) {
            return 3;
        }
        return 0;
    }

    public boolean isV1() {
        return this.m_version.startsWith("v1");
    }

    public boolean isV2() {
        return this.m_version.startsWith("v2");
    }

    public boolean isV3() {
        return this.m_version.startsWith("v3");
    }
}

