/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import javax.annotation.PostConstruct;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.TrapdConfig;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.trapd.EventCreator;
import org.opennms.netmgt.trapd.TrapDTO;
import org.opennms.netmgt.trapd.TrapInformationWrapper;
import org.opennms.netmgt.trapd.TrapLogDTO;
import org.opennms.netmgt.trapd.TrapSinkModule;
import org.opennms.netmgt.trapd.jmx.TrapdInstrumentation;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.LogDestType;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TrapSinkConsumer
implements MessageConsumer<TrapInformationWrapper, TrapLogDTO> {
    public static final TrapdInstrumentation trapdInstrumentation = new TrapdInstrumentation();
    private static final Logger LOG = LoggerFactory.getLogger(TrapSinkConsumer.class);
    private static final String LOCALHOST_ADDRESS = InetAddressUtils.getLocalHostName();
    @Autowired
    private MessageConsumerManager messageConsumerManager;
    @Autowired
    private EventConfDao eventConfDao;
    @Autowired
    @Qualifier(value="eventIpcManager")
    private EventForwarder eventForwarder;
    @Autowired
    private InterfaceToNodeCache interfaceToNodeCache;
    @Autowired
    private TrapdConfig config;
    @Autowired
    private DistPollerDao distPollerDao;
    private EventCreator eventCreator;

    @PostConstruct
    public void init() throws Exception {
        this.messageConsumerManager.registerConsumer((MessageConsumer)this);
        this.eventCreator = new EventCreator(this.interfaceToNodeCache, this.eventConfDao);
    }

    public SinkModule<TrapInformationWrapper, TrapLogDTO> getModule() {
        return new TrapSinkModule(this.config, this.distPollerDao.whoami());
    }

    public void handleMessage(TrapLogDTO messageLog) {
        try (Logging.MDCCloseable mdc = Logging.withPrefixCloseable((String)"trapd");){
            Log eventLog = this.toLog(messageLog);
            this.eventForwarder.sendNowSync(eventLog);
            if (this.config.getNewSuspectOnTrap()) {
                eventLog.getEvents().getEventCollection().stream().filter(e -> !e.hasNodeid()).forEach(e -> {
                    this.sendNewSuspectEvent(e.getInterface(), e.getDistPoller());
                    LOG.debug("Sent newSuspectEvent for interface {}", (Object)e.getInterface());
                });
            }
        }
    }

    private Log toLog(TrapLogDTO messageLog) {
        Log log = new Log();
        Events events = new Events();
        log.setEvents(events);
        for (TrapDTO eachMessage : messageLog.getMessages()) {
            try {
                org.opennms.netmgt.xml.event.Event event = this.eventCreator.createEventFrom(eachMessage, messageLog.getSystemId(), messageLog.getLocation(), messageLog.getTrapAddress());
                if (!this.shouldDiscard(event)) {
                    if (event.getSnmp() != null) {
                        trapdInstrumentation.incTrapsReceivedCount(event.getSnmp().getVersion());
                    }
                    events.addEvent(event);
                    continue;
                }
                LOG.debug("Trap discarded due to matching event having logmsg dest == discardtraps");
                trapdInstrumentation.incDiscardCount();
            }
            catch (Throwable e) {
                LOG.error("Unexpected error processing trap: {}", (Object)eachMessage, (Object)e);
                trapdInstrumentation.incErrorCount();
            }
        }
        return log;
    }

    private void sendNewSuspectEvent(String trapInterface, String distPoller) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "trapd");
        bldr.setInterface(InetAddressUtils.addr((String)trapInterface));
        bldr.setHost(LOCALHOST_ADDRESS);
        bldr.setDistPoller(distPoller);
        this.eventForwarder.sendNow(bldr.getEvent());
    }

    private boolean shouldDiscard(org.opennms.netmgt.xml.event.Event event) {
        Event econf = this.eventConfDao.findByEvent(event);
        if (econf != null) {
            Logmsg logmsg = econf.getLogmsg();
            return logmsg != null && LogDestType.DISCARDTRAPS.equals((Object)logmsg.getDest());
        }
        return false;
    }
}

