/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.LogLevel;
import com.github.fge.jsonschema.core.report.MessageProvider;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.helpers.SchemaArrayValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public final class AnyOfValidator
extends SchemaArrayValidator {
    public AnyOfValidator(JsonNode digest) {
        super("anyOf");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        JsonNode schemas = tree.getNode().get(this.keyword);
        int size = schemas.size();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        for (int index = 0; index < size; ++index) {
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of((Object)this.keyword, (Object[])new Object[]{index}));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process((ProcessingReport)subReport, (MessageProvider)newData);
            fullReport.set(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess == 0) {
            report.error(this.newMsg(data, bundle, "err.common.schema.noMatch").putArgument("nrSchemas", size).put("reports", (JsonNode)fullReport));
        }
    }
}

