/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;

public class NodeAlarmSearchProvider
implements SearchProvider {
    private final NodeDao nodeDao;
    private final AlarmDao alarmDao;
    private final EntityScopeProvider entityScopeProvider;

    public NodeAlarmSearchProvider(NodeDao nodeDao, AlarmDao alarmDao, EntityScopeProvider entityScopeProvider) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.alarmDao = Objects.requireNonNull(alarmDao);
        this.entityScopeProvider = Objects.requireNonNull(entityScopeProvider);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class).alias("node", "node").eq("severity", (Object)OnmsSeverity.get((String)input)).distinct();
        List matchingAlarms = this.alarmDao.findMatching(criteriaBuilder.limit(Integer.valueOf(query.getMaxResults())).toCriteria());
        ArrayList<EqRestriction> restrictions = new ArrayList<EqRestriction>();
        for (OnmsAlarm alarm : matchingAlarms) {
            if (Objects.isNull(alarm.getNodeId())) continue;
            restrictions.add(Restrictions.eq((String)"id", (Object)alarm.getNodeId()));
        }
        if (restrictions.size() > 0) {
            criteriaBuilder = new CriteriaBuilder(OnmsNode.class).or(restrictions.toArray(new Restriction[restrictions.size()])).distinct();
            int totalCount = this.nodeDao.countMatching(criteriaBuilder.toCriteria());
            List matchingNodes = this.nodeDao.findMatching(criteriaBuilder.orderBy("id").limit(Integer.valueOf(query.getMaxResults())).toCriteria());
            List searchResultItems = matchingNodes.stream().map(node -> {
                SearchResultItem searchResultItem = new SearchResultItemBuilder().withOnmsNode((OnmsNode)node, this.entityScopeProvider).build();
                searchResultItem.setLabel("Show nodes with severity '" + input + "'");
                return searchResultItem;
            }).collect(Collectors.toList());
            return new SearchResult(Contexts.Node).withMore(totalCount > searchResultItems.size()).withResults(searchResultItems);
        }
        return new SearchResult(Contexts.Node).withMore(false).withResults(Collections.emptyList());
    }
}

