/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;

public class ServiceSearchProvider
implements SearchProvider {
    private final ServiceTypeDao serviceTypeDao;

    public ServiceSearchProvider(ServiceTypeDao serviceTypeDao) {
        this.serviceTypeDao = Objects.requireNonNull(serviceTypeDao);
    }

    public SearchContext getContext() {
        return Contexts.Action;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsServiceType.class).ilike("name", QueryUtils.ilike((String)input)).orderBy("name").distinct();
        int totalCount = this.serviceTypeDao.countMatching(builder.toCriteria());
        List matchingResult = this.serviceTypeDao.findMatching(builder.limit(Integer.valueOf(query.getMaxResults())).toCriteria());
        List searchResultItems = matchingResult.stream().map(service -> {
            SearchResultItem searchResultItem = new SearchResultItem();
            searchResultItem.setIdentifier(service.getId().toString());
            searchResultItem.setLabel("Show nodes with service '" + service.getName() + "'");
            searchResultItem.setUrl("element/nodeList.htm?service=" + service.getId());
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Action).withMore(totalCount > searchResultItems.size()).withResults(searchResultItems);
        return searchResult;
    }
}

