/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.web.navigate.PageNavEntry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class AdminPageNavEntrySearchProvider
implements SearchProvider {
    private final BundleContext bundleContext;

    public AdminPageNavEntrySearchProvider(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public SearchContext getContext() {
        return Contexts.Action;
    }

    public SearchResult query(SearchQuery query) {
        List<PageNavEntry> totalMatchingEntries = this.getPageNavEntries(query);
        List resultItems = totalMatchingEntries.stream().map(e -> {
            SearchResultItem searchResultItem = new SearchResultItem();
            searchResultItem.setLabel(e.getName());
            searchResultItem.setIdentifier(e.getUrl());
            searchResultItem.setUrl(e.getUrl());
            searchResultItem.setWeight(10);
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Action).withMore(totalMatchingEntries, resultItems).withResults(resultItems);
        return searchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PageNavEntry> getPageNavEntries(SearchQuery query) {
        Objects.requireNonNull(query);
        ArrayList totalMatches = Lists.newArrayList();
        try {
            Collection serviceReferences = this.bundleContext.getServiceReferences(PageNavEntry.class, "(Page=admin)");
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    try {
                        PageNavEntry pageNavEntry = (PageNavEntry)this.bundleContext.getService(serviceReference);
                        if (!QueryUtils.matches((String)pageNavEntry.getName(), (String)query.getInput())) continue;
                        totalMatches.add(pageNavEntry);
                    }
                    finally {
                        this.bundleContext.ungetService(serviceReference);
                    }
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error("An error occurred while performing the search: {}", (Object)e.getMessage(), (Object)e);
        }
        return totalMatches;
    }
}

