/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.graph;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.graph.Graph;
import org.opennms.integration.api.v1.graph.GraphContainer;
import org.opennms.integration.api.v1.graph.GraphContainerInfo;
import org.opennms.integration.api.v1.graph.GraphInfo;
import org.opennms.integration.api.v1.graph.configuration.GraphConfiguration;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericVertex;

public class GraphMapper {
    public GenericGraph map(Graph extensionGraph, GraphConfiguration graphConfiguration) {
        Objects.requireNonNull(extensionGraph, "extensionGraph must not be null");
        Objects.requireNonNull(graphConfiguration, "graphConfiguration must not be null");
        List vertices = extensionGraph.getVertices().stream().map((? super T v) -> ((GenericVertex.GenericVertexBuilder)GenericVertex.builder().properties(v.getProperties())).build()).collect(Collectors.toList());
        List edges = extensionGraph.getEdges().stream().map((? super T e) -> ((GenericEdge.GenericEdgeBuilder)GenericEdge.builder().properties(e.getProperties())).source(e.getSource().getNamespace(), e.getSource().getId()).target(e.getTarget().getNamespace(), e.getTarget().getId()).build()).collect(Collectors.toList());
        GenericGraph.GenericGraphBuilder graphBuilder = GenericGraph.builder().properties(extensionGraph.getProperties()).property("enrichment.resolveNodes", (Object)graphConfiguration.shouldEnrichNodeInfo()).property("enrichment.defaultStatus", (Object)(graphConfiguration.getGraphStatusStrategy() == GraphConfiguration.GraphStatusStrategy.Default ? 1 : 0)).addVertices(vertices).addEdges(edges);
        List defaultFocus = extensionGraph.getDefaultFocus();
        if (defaultFocus != null) {
            List convertedDefaultFocus = defaultFocus.stream().map((? super T vertexRef) -> new VertexRef(vertexRef.getNamespace(), vertexRef.getId())).collect(Collectors.toList());
            graphBuilder.focus(new Focus("SELECTION", convertedDefaultFocus));
        }
        GenericGraph convertedGraph = graphBuilder.build();
        return convertedGraph;
    }

    public GenericGraphContainer map(GraphContainer extensionGraphContainer, GraphConfiguration graphConfiguration) {
        Objects.requireNonNull(extensionGraphContainer, "extensionGraphContainer must not be null");
        Objects.requireNonNull(graphConfiguration, "graphConfiguration must not be null");
        GenericGraphContainer.GenericGraphContainerBuilder containerBuilder = GenericGraphContainer.builder().properties(extensionGraphContainer.getProperties());
        extensionGraphContainer.getGraphs().stream().map((? super T extensionGraph) -> this.map((Graph)extensionGraph, graphConfiguration)).forEach(arg_0 -> ((GenericGraphContainer.GenericGraphContainerBuilder)containerBuilder).addGraph(arg_0));
        GenericGraphContainer convertedGraphContainer = containerBuilder.build();
        return convertedGraphContainer;
    }

    public org.opennms.netmgt.graph.api.info.GraphInfo map(final GraphInfo extensionGraphInfo) {
        Objects.requireNonNull(extensionGraphInfo, "extensionGraphInfo must not be null");
        return new org.opennms.netmgt.graph.api.info.GraphInfo(){

            public String getNamespace() {
                return extensionGraphInfo.getNamespace();
            }

            public String getDescription() {
                return extensionGraphInfo.getDescription();
            }

            public String getLabel() {
                return extensionGraphInfo.getLabel();
            }
        };
    }

    public org.opennms.netmgt.graph.api.info.GraphContainerInfo map(final GraphContainerInfo extensionGraphContainerInfo) {
        Objects.requireNonNull(extensionGraphContainerInfo, "extensionGraphContainerInfo must not be null");
        return new org.opennms.netmgt.graph.api.info.GraphContainerInfo(){

            public String getId() {
                return extensionGraphContainerInfo.getContainerId();
            }

            public List<String> getNamespaces() {
                return extensionGraphContainerInfo.getGraphInfos().stream().map(gi -> gi.getNamespace()).collect(Collectors.toList());
            }

            public String getDescription() {
                return extensionGraphContainerInfo.getDescription();
            }

            public String getLabel() {
                return extensionGraphContainerInfo.getLabel();
            }

            public org.opennms.netmgt.graph.api.info.GraphInfo getGraphInfo(String namespace) {
                GraphInfo extensionGraphInfo = extensionGraphContainerInfo.getGraphInfos().stream().filter(gi -> gi.getNamespace().equals(namespace)).findAny().orElseThrow(() -> new NoSuchElementException("GraphInfo with namespace '" + namespace + "' does not exist"));
                return GraphMapper.this.map(extensionGraphInfo);
            }

            public org.opennms.netmgt.graph.api.info.GraphInfo getPrimaryGraphInfo() {
                GraphInfo defaultGraphInfo = extensionGraphContainerInfo.getDefaultGraphInfo();
                return GraphMapper.this.map(defaultGraphInfo);
            }

            public List<org.opennms.netmgt.graph.api.info.GraphInfo> getGraphInfos() {
                return extensionGraphContainerInfo.getGraphInfos().stream().map(gi -> GraphMapper.this.map((GraphInfo)gi)).collect(Collectors.toList());
            }
        };
    }
}

