/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.config.ConfigExtensionManager;
import org.opennms.integration.api.v1.config.syslog.SyslogMatch;
import org.opennms.integration.api.v1.config.syslog.SyslogMatchExtension;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.syslogd.Match;
import org.opennms.netmgt.config.syslogd.ParameterAssignment;
import org.opennms.netmgt.config.syslogd.SyslogdConfigurationGroup;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogMatchExtensionManager
extends ConfigExtensionManager<SyslogMatchExtension, SyslogdConfigurationGroup> {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogMatchExtensionManager.class);
    private final SyslogdConfig syslogdConfig;

    public SyslogMatchExtensionManager(SyslogdConfig syslogdConfig) {
        super(SyslogdConfigurationGroup.class, new SyslogdConfigurationGroup());
        this.syslogdConfig = Objects.requireNonNull(syslogdConfig);
        LOG.debug("SyslogMatchExtensionManager initialized.");
    }

    @Override
    protected SyslogdConfigurationGroup getConfigForExtensions(Set<SyslogMatchExtension> syslogMatchExtensions) {
        List orderedUeiMatches = syslogMatchExtensions.stream().flatMap(ext -> ext.getSyslogMatches().stream()).sorted(Comparator.comparing(SyslogMatch::getPriority)).map(SyslogMatchExtensionManager::toUeiMatch).collect(Collectors.toList());
        SyslogdConfigurationGroup group = new SyslogdConfigurationGroup();
        group.getUeiMatches().addAll(orderedUeiMatches);
        return group;
    }

    @Override
    protected void triggerReload() {
        LOG.debug("Syslog configuration changed. Triggering a reload.");
        try {
            this.syslogdConfig.reload();
        }
        catch (IOException e) {
            LOG.warn("Reloading the syslog configuration failed. New/updated/removed match definitions may not be immediately reflected.", (Throwable)e);
        }
    }

    public static UeiMatch toUeiMatch(SyslogMatch syslogMatch) {
        UeiMatch ueiMatch = new UeiMatch();
        ueiMatch.setUei(syslogMatch.getUei());
        Match match = new Match();
        match.setType("regex");
        match.setExpression(syslogMatch.getMatchExpression());
        ueiMatch.setMatch(match);
        LinkedList<ParameterAssignment> parameterAssignments = new LinkedList<ParameterAssignment>();
        for (org.opennms.integration.api.v1.config.syslog.ParameterAssignment pa : syslogMatch.getParameterAssignments()) {
            ParameterAssignment mappedPa = new ParameterAssignment();
            mappedPa.setMatchingGroup(Integer.valueOf(pa.getGroupNumber()));
            mappedPa.setParameterName(pa.getParameterName());
            parameterAssignments.add(mappedPa);
        }
        ueiMatch.setParameterAssignments(parameterAssignments);
        return ueiMatch;
    }
}

