/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.commands;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.support.table.ShellTable;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;

@Command(scope="opennms", name="event", description="Show event details for a given id")
@Service
public class EventCommand
implements Action {
    @Reference
    public EventDao eventDao;
    @Argument(name="id", description="Event Id to match (exact). If no argument is given, the most recent event will be displayed.", required=false, multiValued=false)
    Integer id;
    @Reference
    Terminal terminal;

    public Object execute() {
        List onmsEvents;
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsEvent.class).orderBy("eventTime").desc().alias("node", "node", Alias.JoinType.LEFT_JOIN).alias("alarm", "alarm", Alias.JoinType.LEFT_JOIN).alias("eventParameters", "event_parameters", Alias.JoinType.LEFT_JOIN).alias("serviceType", "serviceType", Alias.JoinType.LEFT_JOIN).orderBy("id", false).limit(Integer.valueOf(1));
        if (this.id != null) {
            criteriaBuilder = criteriaBuilder.eq("id", (Object)this.id);
        }
        if ((onmsEvents = this.eventDao.findMatching(criteriaBuilder.toCriteria())).size() == 0) {
            return null;
        }
        OnmsEvent onmsEvent = (OnmsEvent)onmsEvents.get(0);
        ShellTable eventPropertyTable = new ShellTable();
        eventPropertyTable.size(this.terminal.getWidth() - 1);
        eventPropertyTable.column("Property");
        eventPropertyTable.column("Value");
        this.fillTable(eventPropertyTable, "eventUei", onmsEvent.getEventUei());
        this.fillTable(eventPropertyTable, "eventTime", onmsEvent.getEventTime());
        this.fillTable(eventPropertyTable, "eventHost", onmsEvent.getEventHost());
        this.fillTable(eventPropertyTable, "eventSource", onmsEvent.getEventSource());
        this.fillTable(eventPropertyTable, "ipAddr", onmsEvent.getIpAddr());
        this.fillTable(eventPropertyTable, "distPoller", onmsEvent.getDistPoller());
        this.fillTable(eventPropertyTable, "eventSnmpHost", onmsEvent.getEventSnmpHost());
        this.fillTable(eventPropertyTable, "serviceType", onmsEvent.getServiceType());
        this.fillTable(eventPropertyTable, "eventSnmp", onmsEvent.getEventSnmp());
        this.fillTable(eventPropertyTable, "eventCreateTime", onmsEvent.getEventCreateTime());
        this.fillTable(eventPropertyTable, "eventDescr", onmsEvent.getEventDescr());
        this.fillTable(eventPropertyTable, "eventLog", onmsEvent.getEventLog());
        this.fillTable(eventPropertyTable, "eventLogGroup", onmsEvent.getEventLogGroup());
        this.fillTable(eventPropertyTable, "eventLogMsg", onmsEvent.getEventLogMsg());
        this.fillTable(eventPropertyTable, "eventSeverity", onmsEvent.getEventSeverity());
        this.fillTable(eventPropertyTable, "ifIndex", onmsEvent.getIfIndex());
        this.fillTable(eventPropertyTable, "eventPathOutage", onmsEvent.getEventPathOutage());
        this.fillTable(eventPropertyTable, "eventCorrelation", onmsEvent.getEventCorrelation());
        this.fillTable(eventPropertyTable, "eventSurpressedCount", onmsEvent.getEventSuppressedCount());
        this.fillTable(eventPropertyTable, "eventOperInstruct", onmsEvent.getEventOperInstruct());
        this.fillTable(eventPropertyTable, "eventAutoAction", onmsEvent.getEventAutoAction());
        this.fillTable(eventPropertyTable, "eventOperAction", onmsEvent.getEventOperAction());
        this.fillTable(eventPropertyTable, "eventOperActionMenuText", onmsEvent.getEventOperActionMenuText());
        this.fillTable(eventPropertyTable, "eventNotification", onmsEvent.getEventNotification());
        this.fillTable(eventPropertyTable, "eventTTicket", onmsEvent.getEventTTicket());
        this.fillTable(eventPropertyTable, "eventTTicketState", onmsEvent.getEventTTicketState());
        this.fillTable(eventPropertyTable, "eventForward", onmsEvent.getEventForward());
        this.fillTable(eventPropertyTable, "eventMouseOverText", onmsEvent.getEventMouseOverText());
        this.fillTable(eventPropertyTable, "eventDisplay", onmsEvent.getEventDisplay());
        this.fillTable(eventPropertyTable, "eventAckUser", onmsEvent.getEventAckUser());
        this.fillTable(eventPropertyTable, "eventAckTime", onmsEvent.getEventAckTime());
        this.fillTable(eventPropertyTable, "alarm", onmsEvent.getAlarm());
        this.fillTable(eventPropertyTable, "node", onmsEvent.getNode());
        System.out.println("\nEvent Properties for Event #" + onmsEvent.getId() + ":\n");
        eventPropertyTable.print(System.out);
        ShellTable eventParameterTable = new ShellTable();
        eventParameterTable.size(this.terminal.getWidth() - 1);
        eventParameterTable.column("Name");
        eventParameterTable.column("Type");
        eventParameterTable.column("Value");
        for (OnmsEventParameter onmsEventParameter : onmsEvent.getEventParameters()) {
            eventParameterTable.addRow().addContent(new Object[]{onmsEventParameter.getName(), onmsEventParameter.getType(), onmsEventParameter.getValue()});
        }
        System.out.println("\nEvent Parameters for Event #" + onmsEvent.getId() + ":\n");
        eventParameterTable.print(System.out);
        return null;
    }

    private void fillTable(ShellTable table, String name, Object object) {
        Object value;
        if (object == null) {
            value = "<not set>";
        } else {
            switch (name) {
                case "eventSeverity": {
                    value = String.valueOf(object) + " (" + String.valueOf(OnmsSeverity.get((int)((Integer)object))) + ")";
                    break;
                }
                case "distPoller": {
                    value = String.valueOf(((OnmsDistPoller)object).getId());
                    break;
                }
                case "serviceType": {
                    value = String.valueOf(((OnmsServiceType)object).getName());
                    break;
                }
                case "alarm": {
                    value = String.valueOf(((OnmsAlarm)object).getId());
                    break;
                }
                case "node": {
                    value = String.valueOf(((OnmsNode)object).getId());
                    break;
                }
                default: {
                    value = object.toString();
                }
            }
        }
        table.addRow().addContent(new Object[]{name, value});
    }
}

