/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vacuumd;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="automation")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="vacuumd-configuration.xsd")
public class Automation
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Boolean DEFAULT_ACTIVE_FLAG = Boolean.TRUE;
    @XmlAttribute(name="name", required=true)
    private String m_name;
    @XmlAttribute(name="interval", required=true)
    private Integer m_interval;
    @XmlAttribute(name="trigger-name")
    private String m_triggerName;
    @XmlAttribute(name="action-name", required=true)
    private String m_actionName;
    @XmlAttribute(name="auto-event-name")
    private String m_autoEventName;
    @XmlAttribute(name="action-event")
    private String m_actionEvent;
    @XmlAttribute(name="active")
    private Boolean m_active;

    public Automation() {
    }

    public Automation(String name, Integer interval, String triggerName, String actionName, String autoEventName, String actionEvent, Boolean active) {
        this.setName(name);
        this.setInterval(interval);
        this.setTriggerName(triggerName);
        this.setActionName(actionName);
        this.setAutoEventName(autoEventName);
        this.setActionEvent(actionEvent);
        this.setActive(active);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = ConfigUtils.assertNotEmpty(name, "name");
    }

    public Integer getInterval() {
        return this.m_interval;
    }

    public void setInterval(Integer interval) {
        this.m_interval = interval;
    }

    public Optional<String> getTriggerName() {
        return Optional.ofNullable(this.m_triggerName);
    }

    public void setTriggerName(String triggerName) {
        this.m_triggerName = ConfigUtils.normalizeString(triggerName);
    }

    public String getActionName() {
        return this.m_actionName;
    }

    public void setActionName(String actionName) {
        this.m_actionName = ConfigUtils.assertNotEmpty(actionName, "action-name");
    }

    public Optional<String> getAutoEventName() {
        return Optional.ofNullable(this.m_autoEventName);
    }

    public void setAutoEventName(String autoEventName) {
        this.m_autoEventName = ConfigUtils.normalizeString(autoEventName);
    }

    public Optional<String> getActionEvent() {
        return Optional.ofNullable(this.m_actionEvent);
    }

    public void setActionEvent(String actionEvent) {
        this.m_actionEvent = ConfigUtils.normalizeString(actionEvent);
    }

    public Boolean getActive() {
        return this.m_active == null ? DEFAULT_ACTIVE_FLAG : this.m_active;
    }

    public void setActive(Boolean active) {
        this.m_active = active;
    }

    public int hashCode() {
        return Objects.hash(this.m_name, this.m_interval, this.m_triggerName, this.m_actionName, this.m_autoEventName, this.m_actionEvent, this.m_active);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Automation) {
            Automation that = (Automation)obj;
            return Objects.equals(this.m_name, that.m_name) && Objects.equals(this.m_interval, that.m_interval) && Objects.equals(this.m_triggerName, that.m_triggerName) && Objects.equals(this.m_actionName, that.m_actionName) && Objects.equals(this.m_autoEventName, that.m_autoEventName) && Objects.equals(this.m_actionEvent, that.m_actionEvent) && Objects.equals(this.m_active, that.m_active);
        }
        return false;
    }
}

