/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support;

import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.Persister;

public class DelegatingPersister
implements Persister {
    private final List<Persister> delegates;

    public DelegatingPersister(List<Persister> delegates) {
        this.delegates = Objects.requireNonNull(delegates);
    }

    @Override
    public void persistNumericAttribute(CollectionAttribute attribute) {
        this.delegates.forEach(p -> p.persistNumericAttribute(attribute));
    }

    @Override
    public void persistStringAttribute(CollectionAttribute attribute) {
        this.delegates.forEach(p -> p.persistStringAttribute(attribute));
    }

    @Override
    public void visitCollectionSet(CollectionSet set) {
        this.delegates.forEach(p -> p.visitCollectionSet(set));
    }

    @Override
    public void visitResource(CollectionResource resource) {
        this.delegates.forEach(p -> p.visitResource(resource));
    }

    @Override
    public void visitGroup(AttributeGroup group) {
        this.delegates.forEach(p -> p.visitGroup(group));
    }

    @Override
    public void visitAttribute(CollectionAttribute attribute) {
        this.delegates.forEach(p -> p.visitAttribute(attribute));
    }

    @Override
    public void completeAttribute(CollectionAttribute attribute) {
        this.delegates.forEach(p -> p.completeAttribute(attribute));
    }

    @Override
    public void completeGroup(AttributeGroup group) {
        this.delegates.forEach(p -> p.completeGroup(group));
    }

    @Override
    public void completeResource(CollectionResource resource) {
        this.delegates.forEach(p -> p.completeResource(resource));
    }

    @Override
    public void completeCollectionSet(CollectionSet set) {
        this.delegates.forEach(p -> p.completeCollectionSet(set));
    }
}

