/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.adapter.stats;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.opennms.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteInfo {
    private static final Logger LOG = LoggerFactory.getLogger(RouteInfo.class);
    private String prefix;
    private Integer prefixLen;
    private String description;
    private Long originAs;
    private String source;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Integer getPrefixLen() {
        return this.prefixLen;
    }

    public void setPrefixLen(Integer prefixLen) {
        this.prefixLen = prefixLen;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getOriginAs() {
        return this.originAs;
    }

    public void setOriginAs(Long originAs) {
        this.originAs = originAs;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public static RouteInfo parseOneRecord(String rawOutput) {
        String[] lines;
        RouteInfo routeInfo = new RouteInfo();
        for (String line : lines = rawOutput.split("\\r?\\n")) {
            if (line.contains("route")) {
                RouteInfo.getSubStringAfterColon(line).ifPresent(route -> {
                    if (route.contains("/")) {
                        Integer prefixLen;
                        String[] prefixArray = route.split("/", 2);
                        if (RouteInfo.isValidIpAddress(prefixArray[0])) {
                            routeInfo.setPrefix(prefixArray[0]);
                        }
                        if ((prefixLen = StringUtils.parseInt((String)prefixArray[1], null)) != null) {
                            routeInfo.setPrefixLen(prefixLen);
                        }
                    }
                });
            }
            if (line.contains("descr")) {
                RouteInfo.getSubStringAfterColon(line).ifPresent(routeInfo::setDescription);
            }
            if (line.contains("source")) {
                RouteInfo.getSubStringAfterColon(line).ifPresent(routeInfo::setSource);
            }
            if (!line.contains("origin")) continue;
            RouteInfo.getSubStringAfterColon(line).ifPresent(origin -> {
                String originAsnString;
                Long originAsn;
                if (origin.length() > 2 && (originAsn = StringUtils.parseLong((String)(originAsnString = origin.substring(2, origin.length())), null)) != null) {
                    routeInfo.setOriginAs(originAsn);
                }
            });
        }
        return routeInfo;
    }

    public static List<RouteInfo> parseRouteInfo(Stream<String> lines) {
        ArrayList<RouteInfo> routeInfoList = new ArrayList<RouteInfo>();
        ArrayList<String> record = new ArrayList<String>();
        for (String line : lines::iterator) {
            if (line.contains(":")) {
                record.add(line);
            }
            if (line.length() != 0) continue;
            RouteInfo routeInfo = RouteInfo.parseOneRecord(record);
            routeInfoList.add(routeInfo);
            record = new ArrayList();
        }
        if (record.size() > 0) {
            RouteInfo routeInfo = RouteInfo.parseOneRecord(record);
            routeInfoList.add(routeInfo);
        }
        return routeInfoList;
    }

    private static RouteInfo parseOneRecord(List<String> lines) {
        RouteInfo routeInfo = new RouteInfo();
        for (String line : lines) {
            if (line.contains("route") || line.contains("route6")) {
                RouteInfo.getSubStringAfterColon(line).ifPresent(route -> {
                    String[] prefixArray;
                    if (route.contains("/") && RouteInfo.isValidIpAddress((prefixArray = route.split("/", 2))[0])) {
                        routeInfo.setPrefix(prefixArray[0]);
                        Integer prefixLen = StringUtils.parseInt((String)prefixArray[1], null);
                        if (prefixLen != null) {
                            routeInfo.setPrefixLen(prefixLen);
                        }
                    }
                });
            }
            if (line.contains("descr")) {
                RouteInfo.getSubStringAfterColon(line).ifPresent(routeInfo::setDescription);
            }
            if (line.contains("source")) {
                RouteInfo.getSubStringAfterColon(line).ifPresent(routeInfo::setSource);
            }
            if (!line.contains("origin")) continue;
            RouteInfo.getSubStringAfterColon(line).ifPresent(origin -> {
                String originAsnString;
                Long originAsn;
                if (origin.length() > 2 && (originAsn = StringUtils.parseLong((String)(originAsnString = origin.substring(2, origin.length())), null)) != null) {
                    routeInfo.setOriginAs(originAsn);
                }
            });
        }
        return routeInfo;
    }

    private static Optional<String> getSubStringAfterColon(String segment) {
        int index = segment.indexOf(":");
        if (index > 0) {
            String value = segment.substring(index + 1);
            return Optional.of(value.trim());
        }
        return Optional.empty();
    }

    static boolean isValidIpAddress(String prefix) {
        try {
            InetAddress.getByName(prefix);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteInfo routeInfo = (RouteInfo)o;
        return Objects.equals(this.prefix, routeInfo.prefix) && Objects.equals(this.prefixLen, routeInfo.prefixLen) && Objects.equals(this.originAs, routeInfo.originAs);
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.prefixLen, this.originAs);
    }
}

