/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.dao.thresholding.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.codehaus.jackson.map.ObjectMapper;
import org.opennms.core.config.api.ConfigReloadContainer;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JacksonUtils;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.config.dao.common.api.SaveableConfigContainer;
import org.opennms.netmgt.config.dao.common.impl.FileSystemSaveableConfigContainer;
import org.opennms.netmgt.config.dao.thresholding.api.WriteableThreshdDao;
import org.opennms.netmgt.config.dao.thresholding.impl.AbstractThreshdDao;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;

public class OnmsThreshdDao
extends AbstractThreshdDao
implements WriteableThreshdDao {
    private final SaveableConfigContainer<ThreshdConfiguration> saveableConfigContainer;
    private final ConfigReloadContainer<ThreshdConfiguration> extContainer;
    private final ObjectMapper objectMapper = JacksonUtils.createDefaultObjectMapper();
    private volatile ThreshdConfiguration filesystemConfig;

    @VisibleForTesting
    OnmsThreshdDao(JsonStore jsonStore, File configFile) {
        super(jsonStore);
        Objects.requireNonNull(configFile);
        this.extContainer = new ConfigReloadContainer.Builder(ThreshdConfiguration.class).withFolder((accumulator, next) -> accumulator.getPackages().addAll(next.getPackages())).build();
        this.saveableConfigContainer = new FileSystemSaveableConfigContainer(ThreshdConfiguration.class, "threshd-configuration", Collections.singleton(this::fileSystemConfigUpdated), configFile);
        this.reload();
    }

    public OnmsThreshdDao(JsonStore jsonStore) throws IOException {
        this(jsonStore, ConfigFileConstants.getFile((int)ConfigFileConstants.THRESHD_CONFIG_FILE_NAME));
    }

    public ThreshdConfiguration getReadOnlyConfig() {
        return this.getMergedConfig();
    }

    public ThreshdConfiguration getWriteableConfig() {
        return (ThreshdConfiguration)this.saveableConfigContainer.getConfig();
    }

    @Override
    public void reload() {
        this.saveableConfigContainer.reload();
    }

    public void saveConfig() {
        this.saveableConfigContainer.saveConfig();
    }

    private synchronized ThreshdConfiguration getMergedConfig() {
        ThreshdConfiguration externalConfig = (ThreshdConfiguration)this.extContainer.getObject();
        if (this.filesystemConfig == null && externalConfig == null) {
            return null;
        }
        if (externalConfig == null) {
            return this.filesystemConfig;
        }
        if (this.filesystemConfig == null) {
            return externalConfig;
        }
        ThreshdConfiguration mergedConfig = new ThreshdConfiguration();
        ArrayList mergedPackages = new ArrayList();
        mergedPackages.addAll(this.filesystemConfig.getPackages());
        mergedPackages.addAll(externalConfig.getPackages());
        mergedConfig.setPackages(Collections.unmodifiableList(mergedPackages));
        return mergedConfig;
    }

    private synchronized void publishMergedConfig() {
        try {
            this.jsonStore.put("threshd-configuration", (Object)this.objectMapper.writeValueAsString((Object)this.getMergedConfig()), "config");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void onConfigChanged() {
        super.reload();
        this.publishMergedConfig();
    }

    private synchronized void fileSystemConfigUpdated(ThreshdConfiguration updatedConfig) {
        this.filesystemConfig = updatedConfig;
        this.onConfigChanged();
    }
}

