/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.persistence.impl;

import java.util.List;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.persistence.api.CdpElementDao;
import org.slf4j.LoggerFactory;

public class CdpElementDaoHibernate
extends AbstractDaoHibernate<CdpElement, Integer>
implements CdpElementDao {
    public CdpElementDaoHibernate() {
        super(CdpElement.class);
    }

    public CdpElement findByNodeId(Integer id) {
        return (CdpElement)this.findUnique("from CdpElement rec where rec.node.id = ?", new Object[]{id});
    }

    public CdpElement findByGlobalDeviceId(String deviceId) {
        List elements = this.find("from CdpElement rec where rec.cdpGlobalDeviceId = ? order by rec.id", new Object[]{deviceId});
        if (elements.size() > 1) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Expected 1 CdpElement for device with id '{}' but found {}. Using CdpElement {} and ignoring others.", new Object[]{deviceId, elements.size(), elements.get(0)});
        }
        return elements.isEmpty() ? null : (CdpElement)elements.get(0);
    }

    public List<CdpElement> findByCacheDeviceIdOfCdpLinksOfNode(int nodeId) {
        return this.find("from CdpElement rec where rec.cdpGlobalDeviceId in (select l.cdpCacheDeviceId from CdpLink l where l.node.id = ?)", new Object[]{nodeId});
    }

    public void deleteByNodeId(Integer nodeId) {
        this.getHibernateTemplate().bulkUpdate("delete from CdpElement rec where rec.node.id = ? ", new Object[]{nodeId});
    }

    public void deleteAll() {
        this.getHibernateTemplate().bulkUpdate("delete from CdpElement");
    }
}

