/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.timeseries.immutables;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.opennms.integration.api.v1.timeseries.DataPoint;
import org.opennms.integration.api.v1.timeseries.Metric;
import org.opennms.integration.api.v1.timeseries.TimeSeriesData;

public class ImmutableTimeSeriesData
implements TimeSeriesData,
Serializable {
    private final Metric metric;
    private final List<DataPoint> dataPoints;

    public ImmutableTimeSeriesData(Metric metric, List<DataPoint> dataPoints) {
        this.metric = Objects.requireNonNull(metric);
        this.dataPoints = Objects.requireNonNull(dataPoints);
    }

    public Metric getMetric() {
        return this.metric;
    }

    public List<DataPoint> getDataPoints() {
        return this.dataPoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTimeSeriesData that = (ImmutableTimeSeriesData)o;
        return Objects.equals(this.metric, that.metric) && Objects.equals(this.dataPoints, that.dataPoints);
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.dataPoints);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("metric=" + this.metric).add("dataPoints=" + this.dataPoints).toString();
    }

    public static ImmutableTimeSeriesDataBuilder builder() {
        return new ImmutableTimeSeriesDataBuilder();
    }

    public static class ImmutableTimeSeriesDataBuilder {
        private Metric metric;
        List<DataPoint> dataPoints;

        private ImmutableTimeSeriesDataBuilder() {
        }

        public ImmutableTimeSeriesDataBuilder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public ImmutableTimeSeriesDataBuilder dataPoints(List<DataPoint> dataPoints) {
            this.dataPoints = dataPoints;
            return this;
        }

        public ImmutableTimeSeriesDataBuilder dataPoint(DataPoint dataPoint) {
            Objects.requireNonNull(dataPoint);
            if (this.dataPoints == null) {
                this.dataPoints = new ArrayList<DataPoint>();
            }
            this.dataPoints.add(dataPoint);
            return this;
        }

        public ImmutableTimeSeriesData build() {
            return new ImmutableTimeSeriesData(this.metric, this.dataPoints);
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("metric=" + this.metric).add("dataPoints=" + this.dataPoints).toString();
        }
    }
}

