/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImmutableIPAddress
implements Comparable<ImmutableIPAddress> {
    private static final Pattern LEADING_ZEROS = Pattern.compile("^0:[0:]+");
    protected final InetAddress m_inetAddress;

    public ImmutableIPAddress(ImmutableIPAddress addr) {
        this.m_inetAddress = addr.m_inetAddress;
    }

    public ImmutableIPAddress(String dottedNotation) {
        this.m_inetAddress = this.getInetAddress(dottedNotation);
    }

    public ImmutableIPAddress(InetAddress inetAddress) {
        this.m_inetAddress = inetAddress;
    }

    public ImmutableIPAddress(byte[] ipAddrOctets) {
        try {
            this.m_inetAddress = InetAddress.getByAddress(ipAddrOctets);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Cannot convert bytes to an InetAddress.", e);
        }
    }

    public static ImmutableIPAddress min(ImmutableIPAddress a, ImmutableIPAddress b) {
        return a.isLessThan(b) ? a : b;
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByAddress(this.m_inetAddress.getHostName(), this.m_inetAddress.getAddress());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] toOctets() {
        byte[] address = this.m_inetAddress.getAddress();
        return Arrays.copyOf(address, address.length);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImmutableIPAddress) {
            return Arrays.equals(this.m_inetAddress.getAddress(), ((ImmutableIPAddress)obj).m_inetAddress.getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.m_inetAddress.hashCode();
    }

    @Override
    public int compareTo(ImmutableIPAddress o) {
        return this.compare(this.m_inetAddress.getAddress(), o.m_inetAddress.getAddress());
    }

    public String toUserString() {
        if (this.m_inetAddress instanceof Inet4Address) {
            return this.toIpAddrString(this.m_inetAddress);
        }
        if (this.m_inetAddress instanceof Inet6Address) {
            byte[] bytes = this.m_inetAddress.getAddress();
            int[] hextets = new int[8];
            for (int i = 0; i < hextets.length; ++i) {
                hextets[i] = ImmutableIPAddress.fromBytes((byte)0, (byte)0, bytes[2 * i], bytes[2 * i + 1]);
            }
            ImmutableIPAddress.compressLongestRunOfZeroes(hextets);
            return ImmutableIPAddress.hextetsToIPv6String(hextets);
        }
        System.err.println("Not an Inet4Address nor an Inet6Address! " + this.m_inetAddress.getClass());
        return this.m_inetAddress.getHostAddress();
    }

    public String toString() {
        return this.toUserString();
    }

    public String toDbString() {
        return this.toIpAddrString(this.m_inetAddress);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.m_inetAddress.getAddress());
    }

    public ImmutableIPAddress incr() {
        byte[] current = this.m_inetAddress.getAddress();
        byte[] b = new byte[current.length];
        int carry = 1;
        for (int i = current.length - 1; i >= 0; --i) {
            b[i] = (byte)(current[i] + carry);
            carry = b[i] == 0 ? carry : 0;
        }
        if (carry > 0) {
            throw new IllegalStateException("you have tried to increment the max ip address");
        }
        return new ImmutableIPAddress(b);
    }

    public ImmutableIPAddress decr() {
        byte[] current = this.m_inetAddress.getAddress();
        byte[] b = new byte[current.length];
        int borrow = 1;
        for (int i = current.length - 1; i >= 0; --i) {
            b[i] = (byte)(current[i] - borrow);
            borrow = b[i] == -1 ? borrow : 0;
        }
        if (borrow > 0) {
            throw new IllegalStateException("you have tried to decrement the '0' ip address");
        }
        return new ImmutableIPAddress(b);
    }

    public boolean isPredecessorOf(ImmutableIPAddress other) {
        return other.decr().equals(this);
    }

    public boolean isSuccessorOf(ImmutableIPAddress other) {
        return other.incr().equals(this);
    }

    public boolean isLessThan(ImmutableIPAddress other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(ImmutableIPAddress other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(ImmutableIPAddress other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(ImmutableIPAddress other) {
        return this.compareTo(other) >= 0;
    }

    public static ImmutableIPAddress max(ImmutableIPAddress a, ImmutableIPAddress b) {
        return a.isGreaterThan(b) ? a : b;
    }

    protected String toIpAddrString(InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException("Cannot convert null InetAddress to a string");
        }
        byte[] address = addr.getAddress();
        if (address == null) {
            throw new IllegalArgumentException("InetAddress instance violates contract by returning a null address from getAddress()");
        }
        if (addr instanceof Inet4Address) {
            return this.toIpAddrString(address);
        }
        if (addr instanceof Inet6Address) {
            Inet6Address addr6 = (Inet6Address)addr;
            StringBuilder sb = new StringBuilder(this.toIpAddrString(address));
            if (addr6.getScopeId() != 0) {
                sb.append("%").append(addr6.getScopeId());
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Unknown type of InetAddress: " + addr.getClass().getName());
    }

    protected String toIpAddrString(byte[] addr) {
        if (addr.length == 4) {
            return this.getInetAddress(addr).getHostAddress();
        }
        if (addr.length == 16) {
            return String.format("%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x:%02x%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5], addr[6], addr[7], addr[8], addr[9], addr[10], addr[11], addr[12], addr[13], addr[14], addr[15]);
        }
        throw new IllegalArgumentException("IP address has an illegal number of bytes: " + addr.length);
    }

    protected byte[] toIpAddrBytes(String dottedNotation) {
        InetAddress inetAddress = this.getInetAddress(dottedNotation);
        if (inetAddress == null) {
            throw new IllegalArgumentException("Invalid IP Address " + dottedNotation);
        }
        return inetAddress.getAddress();
    }

    private InetAddress getInetAddress(byte[] ipAddrOctets) {
        try {
            return InetAddress.getByAddress(ipAddrOctets);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP Address " + Arrays.toString(ipAddrOctets) + " with length " + ipAddrOctets.length);
        }
    }

    private InetAddress getInetAddress(String dottedNotation) {
        try {
            return dottedNotation == null ? null : InetAddress.getByName(dottedNotation);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IP Address " + dottedNotation);
        }
    }

    private int compare(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.length < b.length) {
            return -1;
        }
        if (a.length > b.length) {
            return 1;
        }
        for (int i = 0; i < a.length; ++i) {
            int bInt;
            int aInt = this.unsignedByteToInt(a[i]);
            if (aInt < (bInt = this.unsignedByteToInt(b[i]))) {
                return -1;
            }
            if (aInt <= bInt) continue;
            return 1;
        }
        return 0;
    }

    public static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static void compressLongestRunOfZeroes(int[] hextets) {
        int bestRunStart = -1;
        int bestRunLength = -1;
        int runStart = -1;
        for (int i = 0; i < hextets.length + 1; ++i) {
            if (i < hextets.length && hextets[i] == 0) {
                if (runStart >= 0) continue;
                runStart = i;
                continue;
            }
            if (runStart < 0) continue;
            int runLength = i - runStart;
            if (runLength > bestRunLength) {
                bestRunStart = runStart;
                bestRunLength = runLength;
            }
            runStart = -1;
        }
        if (bestRunLength >= 2) {
            Arrays.fill(hextets, bestRunStart, bestRunStart + bestRunLength, -1);
        }
    }

    private static String hextetsToIPv6String(int[] hextets) {
        StringBuilder buf = new StringBuilder(39);
        boolean lastWasNumber = false;
        for (int i = 0; i < hextets.length; ++i) {
            boolean thisIsNumber;
            boolean bl = thisIsNumber = hextets[i] >= 0;
            if (thisIsNumber) {
                if (lastWasNumber) {
                    buf.append(':');
                }
                buf.append(Integer.toHexString(hextets[i]));
            } else if (i == 0 || lastWasNumber) {
                buf.append("::");
            }
            lastWasNumber = thisIsNumber;
        }
        Matcher matcher = LEADING_ZEROS.matcher(buf.toString());
        return matcher.replaceAll(":");
    }

    private int unsignedByteToInt(byte b) {
        return b < 0 ? b + 256 : b;
    }
}

