/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.internal.collection;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.api.collection.IGroup;
import org.opennms.netmgt.config.api.collection.IMibObject;
import org.opennms.netmgt.config.internal.collection.ArrayUtils;
import org.opennms.netmgt.config.internal.collection.MibObjectImpl;

@XmlRootElement(name="group")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GroupImpl
implements IGroup {
    @XmlAttribute(name="name")
    private String m_name;
    @XmlElement(name="mibObj")
    private MibObjectImpl[] m_mibObjects = new MibObjectImpl[0];

    public GroupImpl() {
    }

    public GroupImpl(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public IMibObject[] getMibObjects() {
        return this.m_mibObjects;
    }

    public void setMibObjects(IMibObject[] mibObjects) {
        this.m_mibObjects = MibObjectImpl.asMibObjects(mibObjects);
    }

    public void addMibObject(MibObjectImpl mibObject) {
        this.m_mibObjects = ArrayUtils.append(this.m_mibObjects, mibObject);
    }

    public static GroupImpl asGroup(IGroup group) {
        if (group == null) {
            return null;
        }
        if (group instanceof GroupImpl) {
            return (GroupImpl)group;
        }
        GroupImpl newGroup = new GroupImpl();
        newGroup.setName(group.getName());
        newGroup.setMibObjects(group.getMibObjects());
        return newGroup;
    }

    public static GroupImpl[] asGroups(IGroup[] groups) {
        if (groups == null) {
            return null;
        }
        GroupImpl[] newGroups = new GroupImpl[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            newGroups[i] = GroupImpl.asGroup(groups[i]);
        }
        return newGroups;
    }

    public String toString() {
        return "GroupImpl [name=" + this.m_name + ", mibObjects=" + Arrays.toString(this.m_mibObjects) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_mibObjects);
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupImpl)) {
            return false;
        }
        GroupImpl other = (GroupImpl)obj;
        if (!Arrays.equals(this.m_mibObjects, other.m_mibObjects)) {
            return false;
        }
        return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
    }
}

