/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.text.encryptor;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jasypt.util.text.AES256TextEncryptor;
import org.opennms.core.config.api.TextEncryptor;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;

public class TextEncryptorImpl
implements TextEncryptor {
    private final SecureCredentialsVault secureCredentialsVault;
    private Map<String, Credentials> passwordsByAlias = new ConcurrentHashMap<String, Credentials>();

    public TextEncryptorImpl(SecureCredentialsVault secureCredentialsVault) {
        this.secureCredentialsVault = secureCredentialsVault;
    }

    public String encrypt(String alias, String text) {
        AES256TextEncryptor textEncryptor = new AES256TextEncryptor();
        String password = this.getPasswordFromCredentials(alias);
        textEncryptor.setPassword(password);
        return textEncryptor.encrypt(text);
    }

    public String decrypt(String alias, String encrypted) {
        AES256TextEncryptor textEncryptor = new AES256TextEncryptor();
        String password = this.getPasswordFromCredentials(alias);
        textEncryptor.setPassword(password);
        return textEncryptor.decrypt(encrypted);
    }

    private String getPasswordFromCredentials(String alias) {
        Credentials credentials = this.passwordsByAlias.get(alias);
        if (credentials == null) {
            credentials = this.secureCredentialsVault.getCredentials(alias);
            if (credentials == null) {
                return this.generateAndStorePassword(alias);
            }
            this.passwordsByAlias.put(alias, credentials);
        }
        return credentials.getPassword();
    }

    private String generateAndStorePassword(String alias) {
        String password = UUID.randomUUID().toString();
        Credentials credentials = new Credentials(alias, password);
        this.secureCredentialsVault.setCredentials(alias, credentials);
        this.passwordsByAlias.put(alias, credentials);
        return password;
    }
}

