/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.graph.internal;

import com.google.common.base.MoreObjects;
import org.opennms.netmgt.bsm.service.model.Application;
import org.opennms.netmgt.bsm.service.model.BusinessService;
import org.opennms.netmgt.bsm.service.model.IpService;
import org.opennms.netmgt.bsm.service.model.functions.reduce.ReductionFunction;
import org.opennms.netmgt.bsm.service.model.graph.GraphVertex;
import org.opennms.netmgt.bsm.service.model.graph.internal.GraphElement;

public class GraphVertexImpl
extends GraphElement
implements GraphVertex,
Comparable<GraphVertexImpl> {
    private final BusinessService m_businessService;
    private final IpService m_ipService;
    private final String m_reductionKey;
    private final Application m_application;
    private ReductionFunction m_reductionFunction;
    int m_level = -1;

    protected GraphVertexImpl(ReductionFunction reduceFunction, BusinessService businessService) {
        this(reduceFunction, businessService, null, null, null);
    }

    protected GraphVertexImpl(ReductionFunction reduceFunction, IpService ipService) {
        this(reduceFunction, null, ipService, null, null);
    }

    protected GraphVertexImpl(ReductionFunction reduceFunction, Application application) {
        this(reduceFunction, null, null, application, null);
    }

    protected GraphVertexImpl(ReductionFunction reduceFunction, String reductionKey) {
        this(reduceFunction, null, null, null, reductionKey);
    }

    public GraphVertexImpl(ReductionFunction reduceFunction, BusinessService businessService, IpService ipService, Application application, String reductionKey) {
        this.m_businessService = businessService;
        this.m_ipService = ipService;
        this.m_reductionKey = reductionKey;
        this.m_application = application;
        this.m_reductionFunction = reduceFunction;
    }

    public ReductionFunction getReductionFunction() {
        return this.m_reductionFunction;
    }

    public String getReductionKey() {
        return this.m_reductionKey;
    }

    public BusinessService getBusinessService() {
        return this.m_businessService;
    }

    public IpService getIpService() {
        return this.m_ipService;
    }

    public void setLevel(int level) {
        this.m_level = level;
    }

    public int getLevel() {
        return this.m_level;
    }

    public Application getApplication() {
        return this.m_application;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("businessService", (Object)this.m_businessService).add("ipService", (Object)this.m_ipService).add("reductionKey", (Object)this.m_reductionKey).add("application", (Object)this.m_application).add("level", this.m_level).add("reductionFunction", (Object)this.m_reductionFunction).toString();
    }

    @Override
    public int compareTo(GraphVertexImpl other) {
        int i;
        int n = this.getBusinessService() == null ? (other.getBusinessService() == null ? 0 : -1) : (i = other.getBusinessService() == null ? 1 : this.getBusinessService().getId().compareTo(other.getBusinessService().getId()));
        if (i != 0) {
            return i;
        }
        int n2 = this.getIpService() == null ? (other.getIpService() == null ? 0 : -1) : (i = other.getIpService() == null ? 1 : Integer.compare(this.getIpService().getId(), other.getIpService().getId()));
        if (i != 0) {
            return i;
        }
        int n3 = this.getApplication() == null ? (other.getApplication() == null ? 0 : -1) : (i = other.getApplication() == null ? 1 : Integer.compare(this.getApplication().getId(), other.getApplication().getId()));
        if (i != 0) {
            return i;
        }
        i = this.getReductionKey() == null ? (other.getReductionKey() == null ? 0 : -1) : (other.getReductionKey() == null ? 1 : this.getReductionKey().compareTo(other.getReductionKey()));
        return i;
    }
}

