/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.model.graph.internal;

import edu.uci.ics.jung.graph.Hypergraph;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GraphLevelIndexer<V, E> {
    private Map<V, Integer> levelMap = new HashMap<V, Integer>();
    private Set<V> verticesIndexedSet = new HashSet<V>();

    public void indexLevel(Hypergraph<V, E> graph, Set<V> rootSet) {
        Objects.requireNonNull(graph);
        Objects.requireNonNull(rootSet);
        graph.getVertices().forEach(eachVertex -> this.levelMap.put((Integer)eachVertex, -1));
        this.determineLevel(0, graph, rootSet);
    }

    private void determineLevel(int level, Hypergraph<V, E> graph, Collection<V> vertices) {
        for (V eachVertex : vertices) {
            if (!graph.containsVertex(eachVertex)) continue;
            this.levelMap.put((Integer)eachVertex, Math.max(level, this.levelMap.get(eachVertex)));
            this.verticesIndexedSet.add(eachVertex);
            this.determineLevel(level + 1, graph, graph.getSuccessors(eachVertex));
        }
    }

    public Map<V, Integer> getLevelMap() {
        return Collections.unmodifiableMap(this.levelMap);
    }
}

