/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.bsm.service.internal;

import java.util.Objects;
import org.opennms.netmgt.bsm.service.internal.SeverityMapper;
import org.opennms.netmgt.bsm.service.model.AlarmWrapper;
import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.model.OnmsAlarm;

public class AlarmWrapperImpl
implements AlarmWrapper {
    private final String m_reductionKey;
    private final Status m_status;

    public AlarmWrapperImpl(OnmsAlarm alarm) {
        Objects.requireNonNull(alarm);
        this.m_reductionKey = alarm.getReductionKey();
        this.m_status = SeverityMapper.toStatus(alarm.getSeverity());
    }

    public String getReductionKey() {
        return this.m_reductionKey;
    }

    public Status getStatus() {
        return this.m_status;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlarmWrapperImpl)) {
            return false;
        }
        AlarmWrapperImpl castOther = (AlarmWrapperImpl)other;
        return Objects.equals(this.m_reductionKey, castOther.m_reductionKey) && Objects.equals(this.m_status, castOther.m_status);
    }

    public int hashCode() {
        return Objects.hash(this.m_reductionKey, this.m_status);
    }

    public String toString() {
        return String.format("AlarmWrapperImpl[reductionKey=%s, status=%s]", this.m_reductionKey, this.m_status);
    }
}

