/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.ObjectKeyTimer;
import org.opennms.netmgt.provision.service.operations.ImportOperation;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.core.io.Resource;

public class TimeTrackingMonitor
implements ProvisionMonitor {
    private MetricRegistry metricRegistry;
    private Timer loadingTimer;
    private Timer auditTimer;
    private Timer importTimer;
    private Timer schedulingTimer;
    private Timer relateTimer;
    private Timer.Context importDuration;
    private Timer.Context auditDuration;
    private Timer.Context loadingDuration;
    private Timer.Context schedulingDuration;
    private Timer.Context relateDuration;
    private ObjectKeyTimer scanEventTimer;
    private ObjectKeyTimer scanningTimer;
    private ObjectKeyTimer persistingTimer;
    private ObjectKeyTimer eventTimer;
    private int nodeCount;
    private String name;
    private Date startTime;
    private Date endTime;
    private Map<NodeScan, Date> currentNodes = new HashMap<NodeScan, Date>();

    public TimeTrackingMonitor(String name, MetricRegistry metricRegistry) {
        this.name = name;
        this.metricRegistry = metricRegistry;
        this.scanEventTimer = new ObjectKeyTimer(metricRegistry.timer(MetricRegistry.name((String)name, (String[])new String[]{"Scan Event"})));
        this.persistingTimer = new ObjectKeyTimer(metricRegistry.timer(MetricRegistry.name((String)name, (String[])new String[]{"Persisting"})));
        this.eventTimer = new ObjectKeyTimer(metricRegistry.timer(MetricRegistry.name((String)name, (String[])new String[]{"Event"})));
        this.scanningTimer = new ObjectKeyTimer(metricRegistry.timer(MetricRegistry.name((String)name, (String[])new String[]{"Scanning"})));
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start() {
        this.startTime = new Date();
    }

    @Override
    public void finish() {
        this.endTime = new Date();
    }

    public Map<NodeScan, Date> getCurrentNodes() {
        return this.currentNodes;
    }

    public Timer getLoadingTimer() {
        return this.loadingTimer;
    }

    public Timer getAuditTimer() {
        return this.auditTimer;
    }

    public Timer getImportTimer() {
        return this.importTimer;
    }

    public Timer getSchedulingTimer() {
        return this.schedulingTimer;
    }

    public Timer getRelateTimer() {
        return this.relateTimer;
    }

    public Timer getScanEventTimer() {
        return this.scanEventTimer.getTimer();
    }

    public Timer getScanningTimer() {
        return this.scanningTimer.getTimer();
    }

    public Timer getPersistingTimer() {
        return this.persistingTimer.getTimer();
    }

    public Timer getEventTimer() {
        return this.eventTimer.getTimer();
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public void beginScheduling() {
        this.schedulingTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.name, (String[])new String[]{"Scheduling"}));
        this.schedulingDuration = this.schedulingTimer.time();
    }

    @Override
    public void finishScheduling() {
        if (this.schedulingDuration != null) {
            this.schedulingDuration.stop();
        }
    }

    @Override
    public void beginScanEvent(ImportOperation oper) {
        this.scanEventTimer.begin(oper);
    }

    @Override
    public void finishScanEvent(ImportOperation oper) {
        this.scanEventTimer.end(oper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginScanning(NodeScan nodeScan) {
        Map<NodeScan, Date> map = this.currentNodes;
        synchronized (map) {
            this.currentNodes.put(nodeScan, new Date());
        }
        this.scanningTimer.begin(nodeScan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishScanning(NodeScan nodeScan) {
        this.scanningTimer.end(nodeScan);
        Map<NodeScan, Date> map = this.currentNodes;
        synchronized (map) {
            this.currentNodes.remove(nodeScan);
        }
    }

    @Override
    public void beginPersisting(ImportOperation oper) {
        this.persistingTimer.begin(oper);
    }

    @Override
    public void finishPersisting(ImportOperation oper) {
        this.persistingTimer.end(oper);
    }

    @Override
    public void beginSendingEvent(Event event) {
        this.eventTimer.begin(event);
    }

    @Override
    public void finishSendingEvent(Event event) {
        this.eventTimer.end(event);
    }

    @Override
    public void beginLoadingResource(Resource resource) {
        this.loadingTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.name, (String[])new String[]{"Loading", resource.getFilename()}));
        this.loadingDuration = this.loadingTimer.time();
    }

    @Override
    public void finishLoadingResource(Resource resource, int nodeCount) {
        if (this.loadingDuration != null) {
            this.loadingDuration.stop();
        }
        this.nodeCount = nodeCount;
    }

    @Override
    public void beginImporting() {
        this.importTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.name, (String[])new String[]{"Importing"}));
        this.importDuration = this.importTimer.time();
    }

    @Override
    public void finishImporting() {
        if (this.importDuration != null) {
            this.importDuration.stop();
        }
    }

    @Override
    public void beginAuditNodes() {
        this.auditTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.name, (String[])new String[]{"Auditing"}));
        this.auditDuration = this.auditTimer.time();
    }

    @Override
    public void finishAuditNodes() {
        if (this.auditDuration != null) {
            this.auditDuration.stop();
        }
    }

    @Override
    public void beginRelateNodes() {
        this.relateTimer = this.metricRegistry.timer(MetricRegistry.name((String)this.name, (String[])new String[]{"Relating"}));
        this.relateDuration = this.relateTimer.time();
    }

    @Override
    public void finishRelateNodes() {
        if (this.relateDuration != null) {
            this.relateDuration.stop();
        }
    }

    public String toString() {
        StringBuilder stats = new StringBuilder();
        stats.append("NodeCount: ").append(this.nodeCount).append("\n");
        stats.append(this.importDuration).append(", ");
        stats.append(this.loadingDuration).append(", ");
        stats.append(this.auditDuration).append('\n');
        stats.append(this.schedulingDuration).append(", ");
        stats.append(this.relateDuration).append("\n");
        stats.append(this.scanEventTimer.getTimer().getMeanRate()).append(", ");
        stats.append(this.persistingTimer.getTimer().getMeanRate()).append(", ");
        stats.append(this.eventTimer.getTimer().getMeanRate());
        return stats.toString();
    }
}

