/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import io.opentracing.Span;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.tasks.Task;
import org.opennms.core.tasks.TaskCoordinator;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.service.IpInterfaceScan;
import org.opennms.netmgt.provision.service.NodeInfoScan;
import org.opennms.netmgt.provision.service.NodeScan;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.Scan;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.opennms.netmgt.provision.service.operations.ProvisionMonitor;
import org.opennms.netmgt.provision.service.operations.ProvisionOverallMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceRescanScan
implements Scan {
    private static final Logger LOG = LoggerFactory.getLogger(ForceRescanScan.class);
    private Integer m_nodeId;
    private ProvisionService m_provisionService;
    private EventForwarder m_eventForwarder;
    private SnmpAgentConfigFactory m_agentConfigFactory;
    private TaskCoordinator m_taskCoordinator;
    private Span m_span;
    private ProvisionMonitor monitor;
    private ProvisionOverallMonitor overallMonitor;

    public ForceRescanScan(Integer nodeId, ProvisionService provisionService, EventForwarder eventForwarder, SnmpAgentConfigFactory agentConfigFactory, TaskCoordinator taskCoordinator, ProvisionMonitor monitor, ProvisionOverallMonitor overallMonitor) {
        this.m_nodeId = nodeId;
        this.m_provisionService = provisionService;
        this.m_eventForwarder = eventForwarder;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_taskCoordinator = taskCoordinator;
        this.monitor = monitor;
        this.overallMonitor = overallMonitor;
    }

    @Override
    public Task createTask() {
        return this.m_taskCoordinator.createBatch().add(new RunInBatch[]{this}).get();
    }

    public void run(BatchTask phase) {
        this.m_span = this.m_provisionService.buildAndStartSpan("ForceScan", null);
        this.scanExistingNode(phase);
    }

    protected void scanExistingNode(BatchTask phase) {
        LOG.info("Attempting to re-scan node with Id {}", (Object)this.m_nodeId);
        OnmsNode node = this.m_provisionService.getNode(this.m_nodeId);
        if (node != null) {
            this.m_span.setTag("nodeId", (Number)node.getId());
            this.m_span.setTag("location", node.getLocation().getLocationName());
            OnmsIpInterface iface = this.m_provisionService.getPrimaryInterfaceForNode(node);
            if (iface == null) {
                OnmsIpInterface onmsIpInterface = iface = node.getIpInterfaces().isEmpty() ? null : (OnmsIpInterface)node.getIpInterfaces().iterator().next();
                if (iface != null) {
                    LOG.info("The node with ID {} does not have a primary interface", (Object)this.m_nodeId);
                }
            }
            if (iface == null) {
                LOG.info("The node with ID {} does not have any IP addresses", (Object)this.m_nodeId);
            } else {
                phase.getBuilder().addSequence(new RunInBatch[]{new NodeInfoScan(node, iface.getIpAddress(), node.getForeignSource(), node.getLocation(), this.createScanProgress(), this.m_agentConfigFactory, this.m_provisionService, node.getId(), this.m_span), new IpInterfaceScan(node.getId(), iface.getIpAddress(), node.getForeignSource(), node.getLocation(), this.m_provisionService, this.m_span), new NodeScan(node.getId(), node.getForeignSource(), node.getForeignId(), node.getLocation(), this.m_provisionService, this.m_eventForwarder, this.m_agentConfigFactory, this.m_taskCoordinator, this.m_span, this.monitor, this.overallMonitor), new RunInBatch(){

                    public void run(BatchTask batch) {
                        LOG.info("Done re-scanning node with Id {}", (Object)ForceRescanScan.this.m_nodeId);
                        ForceRescanScan.this.m_span.finish();
                    }
                }});
            }
        } else {
            LOG.info("Can't find node with ID {}", (Object)this.m_nodeId);
        }
    }

    private ScanProgress createScanProgress() {
        return new ScanProgress(){
            private boolean m_aborted = false;

            @Override
            public void abort(String message) {
                this.m_aborted = true;
                ForceRescanScan.this.m_span.setTag("error", true);
                ForceRescanScan.this.m_span.setTag("abort", true);
                ForceRescanScan.this.m_span.log(message);
                LOG.info(message);
            }

            @Override
            public boolean isAborted() {
                return this.m_aborted;
            }
        };
    }

    protected void reparentNodes(BatchTask batch, Integer nodeId) {
        LOG.debug("reparenting node ID {} not supported", (Object)nodeId);
    }
}

