/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.graphml.service.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import org.graphdrawing.graphml.GraphmlType;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.graphml.service.GraphmlRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphmlRepositoryImpl
implements GraphmlRepository {
    protected static final String TOPOLOGY_CFG_FILE_PREFIX = "org.opennms.features.topology.plugins.topo.graphml";
    protected static final String GRAPH_CFG_FILE_PREFIX = "org.opennms.netmgt.graph.provider.graphml";
    protected static final String TOPOLOGY_LOCATION = "topologyLocation";
    protected static final String GRAPH_LOCATION = "graphLocation";
    protected static final String LABEL = "label";
    private static final Logger LOG = LoggerFactory.getLogger(GraphmlRepositoryImpl.class);

    public GraphmlRepositoryImpl() {
        Preconditions.checkState((System.getProperty("opennms.home") != null ? 1 : 0) != 0, (Object)"No opennms.home defined. Bailing out...");
    }

    public GraphmlType findByName(String name) throws IOException {
        Objects.requireNonNull(name);
        if (!this.exists(name)) {
            throw new NoSuchElementException("No GraphML file found with name  " + name);
        }
        GraphmlType graphmlType = (GraphmlType)JaxbUtils.unmarshal(GraphmlType.class, (File)new File(GraphmlRepositoryImpl.buildGraphmlFilepath(name)));
        return graphmlType;
    }

    public void save(String name, String label, GraphmlType graphmlType) throws IOException {
        LOG.debug("Saving GraphML file {}\u00a0with label", (Object)name, (Object)label);
        Objects.requireNonNull(name);
        Objects.requireNonNull(label);
        Objects.requireNonNull(graphmlType);
        if (this.exists(name)) {
            LOG.warn("GraphML file with name {} already exists", (Object)name);
            throw new IOException(name + " already exists");
        }
        File graphFile = new File(GraphmlRepositoryImpl.buildGraphmlFilepath(name));
        File topologyCfgFile = new File(GraphmlRepositoryImpl.buildTopologyCfgFilepath(name));
        File graphServiceCfgFile = new File(GraphmlRepositoryImpl.buildGraphCfgFilepath(name));
        LOG.debug("GraphML xml location: {}", (Object)graphFile);
        LOG.debug("GraphML topology cfg location: {}", (Object)topologyCfgFile);
        LOG.debug("GraphML graph cfg location: {}", (Object)graphServiceCfgFile);
        graphFile.getParentFile().mkdirs();
        topologyCfgFile.getParentFile().mkdirs();
        graphServiceCfgFile.getParentFile().mkdirs();
        JaxbUtils.marshal((Object)graphmlType, (File)graphFile);
        Properties properties = new Properties();
        properties.put(TOPOLOGY_LOCATION, graphFile.toString());
        properties.put(LABEL, label);
        properties.store(new FileWriter(topologyCfgFile), "Generated by " + this.getClass().getSimpleName() + ". DO NOT EDIT!");
        properties = new Properties();
        properties.put(GRAPH_LOCATION, graphFile.toString());
        properties.store(new FileWriter(graphServiceCfgFile), "Generated by " + this.getClass().getSimpleName() + ". DO NOT EDIT!");
    }

    public void delete(String name) throws IOException {
        LOG.debug("Delete GraphML file with name {}", (Object)name);
        Objects.requireNonNull(name);
        this.findByName(name);
        Files.delete(Paths.get(GraphmlRepositoryImpl.buildTopologyCfgFilepath(name), new String[0]));
        Files.delete(Paths.get(GraphmlRepositoryImpl.buildGraphCfgFilepath(name), new String[0]));
        Files.delete(Paths.get(GraphmlRepositoryImpl.buildGraphmlFilepath(name), new String[0]));
    }

    public boolean exists(String name) {
        String filename = GraphmlRepositoryImpl.buildGraphmlFilepath(name);
        return new File(filename).exists() && new File(filename).isFile();
    }

    protected static String buildCfgFilepath(String filename, String cfgFilePrefix) {
        return Paths.get(System.getProperty("opennms.home"), "etc", cfgFilePrefix + "-" + filename + ".cfg").toString();
    }

    protected static String buildTopologyCfgFilepath(String filename) {
        return GraphmlRepositoryImpl.buildCfgFilepath(filename, TOPOLOGY_CFG_FILE_PREFIX);
    }

    protected static String buildGraphCfgFilepath(String filename) {
        return GraphmlRepositoryImpl.buildCfgFilepath(filename, GRAPH_CFG_FILE_PREFIX);
    }

    protected static String buildGraphmlFilepath(String filename) {
        return Paths.get(System.getProperty("opennms.home"), "etc", "graphml", filename + ".xml").toString();
    }
}

