/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSetHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.OptionsTemplateRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.OptionsTemplateRecordHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Packet;

public class OptionsTemplateSet
extends FlowSet<OptionsTemplateRecord> {
    public final List<OptionsTemplateRecord> records;

    public OptionsTemplateSet(InformationElementDatabase informationElementDatabase, Packet packet, FlowSetHeader header, ByteBuf buffer) throws InvalidPacketException {
        super(packet, header);
        LinkedList<OptionsTemplateRecord> records = new LinkedList<OptionsTemplateRecord>();
        while (buffer.isReadable(6)) {
            OptionsTemplateRecordHeader recordHeader = new OptionsTemplateRecordHeader(buffer);
            records.add(new OptionsTemplateRecord(informationElementDatabase, recordHeader, buffer));
        }
        if (records.size() == 0) {
            throw new InvalidPacketException(buffer, "Empty set", new Object[0]);
        }
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public Iterator<OptionsTemplateRecord> iterator() {
        return this.records.iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("records", this.records).toString();
    }
}

