/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;

public final class OptionsTemplateRecordHeader {
    public static final int SIZE = 6;
    public final int templateId;
    public final int fieldCount;
    public final int scopeFieldCount;

    public OptionsTemplateRecordHeader(ByteBuf buffer) throws InvalidPacketException {
        this.templateId = BufferUtils.uint16((ByteBuf)buffer);
        if (this.templateId <= 255 && this.templateId != 3) {
            throw new InvalidPacketException(buffer, "Invalid template ID: %d", this.templateId);
        }
        this.fieldCount = BufferUtils.uint16((ByteBuf)buffer);
        this.scopeFieldCount = BufferUtils.uint16((ByteBuf)buffer);
        if (this.scopeFieldCount > this.fieldCount) {
            throw new InvalidPacketException(buffer, "More scope fields than fields available: %d > %d", this.scopeFieldCount, this.fieldCount);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("templateId", this.templateId).add("fieldCount", this.fieldCount).add("scopeFieldCount", this.scopeFieldCount).toString();
    }
}

