/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.util.Enumeration;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.DEREncodable;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.DEROctetString;
import org.opennms.shaded.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.opennms.shaded.org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.jce.interfaces.GOST3410Params;
import org.opennms.shaded.org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import org.opennms.shaded.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.opennms.shaded.org.bouncycastle.jce.provider.PKCS12BagAttributeCarrierImpl;
import org.opennms.shaded.org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.opennms.shaded.org.bouncycastle.jce.spec.GOST3410PrivateKeySpec;
import org.opennms.shaded.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;

public class JDKGOST3410PrivateKey
implements GOST3410PrivateKey,
PKCS12BagAttributeCarrier {
    BigInteger x;
    GOST3410Params gost3410Spec;
    private PKCS12BagAttributeCarrier attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected JDKGOST3410PrivateKey() {
    }

    JDKGOST3410PrivateKey(GOST3410PrivateKey gOST3410PrivateKey) {
        this.x = gOST3410PrivateKey.getX();
        this.gost3410Spec = gOST3410PrivateKey.getParameters();
    }

    JDKGOST3410PrivateKey(GOST3410PrivateKeySpec gOST3410PrivateKeySpec) {
        this.x = gOST3410PrivateKeySpec.getX();
        this.gost3410Spec = new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(gOST3410PrivateKeySpec.getP(), gOST3410PrivateKeySpec.getQ(), gOST3410PrivateKeySpec.getA()));
    }

    JDKGOST3410PrivateKey(PrivateKeyInfo privateKeyInfo) {
        GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters((ASN1Sequence)privateKeyInfo.getAlgorithmId().getParameters());
        DEROctetString dEROctetString = (DEROctetString)privateKeyInfo.getPrivateKey();
        byte[] byArray = dEROctetString.getOctets();
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i != byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - 1 - i];
        }
        this.x = new BigInteger(1, byArray2);
        this.gost3410Spec = GOST3410ParameterSpec.fromPublicKeyAlg(gOST3410PublicKeyAlgParameters);
    }

    JDKGOST3410PrivateKey(GOST3410PrivateKeyParameters gOST3410PrivateKeyParameters, GOST3410ParameterSpec gOST3410ParameterSpec) {
        this.x = gOST3410PrivateKeyParameters.getX();
        this.gost3410Spec = gOST3410ParameterSpec;
        if (gOST3410ParameterSpec == null) {
            throw new IllegalArgumentException("spec is null");
        }
    }

    public String getAlgorithm() {
        return "GOST3410";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        byte[] byArray = this.getX().toByteArray();
        byte[] byArray2 = byArray[0] == 0 ? new byte[byArray.length - 1] : new byte[byArray.length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = byArray[byArray.length - 1 - i];
        }
        PrivateKeyInfo privateKeyInfo = this.gost3410Spec instanceof GOST3410ParameterSpec ? new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(new DERObjectIdentifier(this.gost3410Spec.getPublicKeyParamSetOID()), new DERObjectIdentifier(this.gost3410Spec.getDigestParamSetOID())).getDERObject()), new DEROctetString(byArray2)) : new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94), new DEROctetString(byArray2));
        return privateKeyInfo.getDEREncoded();
    }

    public GOST3410Params getParameters() {
        return this.gost3410Spec;
    }

    public BigInteger getX() {
        return this.x;
    }

    public void setBagAttribute(DERObjectIdentifier dERObjectIdentifier, DEREncodable dEREncodable) {
        this.attrCarrier.setBagAttribute(dERObjectIdentifier, dEREncodable);
    }

    public DEREncodable getBagAttribute(DERObjectIdentifier dERObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(dERObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

