/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import net.jradius.tls.Certificate;
import net.jradius.tls.CertificateVerifyer;
import net.jradius.tls.SecurityParameters;
import net.jradius.tls.TlsBlockCipher;
import net.jradius.tls.TlsCipher;
import net.jradius.tls.TlsClient;
import net.jradius.tls.TlsDHKeyExchange;
import net.jradius.tls.TlsDSSSigner;
import net.jradius.tls.TlsKeyExchange;
import net.jradius.tls.TlsProtocolHandler;
import net.jradius.tls.TlsRSAKeyExchange;
import net.jradius.tls.TlsRSASigner;
import net.jradius.tls.TlsSRPKeyExchange;
import net.jradius.tls.TlsSigner;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.opennms.shaded.org.bouncycastle.crypto.BlockCipher;
import org.opennms.shaded.org.bouncycastle.crypto.CryptoException;
import org.opennms.shaded.org.bouncycastle.crypto.digests.SHA1Digest;
import org.opennms.shaded.org.bouncycastle.crypto.engines.AESFastEngine;
import org.opennms.shaded.org.bouncycastle.crypto.engines.DESedeEngine;
import org.opennms.shaded.org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.opennms.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;

public class DefaultTlsClient
implements TlsClient {
    private static final int TLS_RSA_WITH_3DES_EDE_CBC_SHA = 10;
    private static final int TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA = 13;
    private static final int TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA = 16;
    private static final int TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA = 19;
    private static final int TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA = 22;
    private static final int TLS_RSA_WITH_AES_128_CBC_SHA = 47;
    private static final int TLS_DH_DSS_WITH_AES_128_CBC_SHA = 48;
    private static final int TLS_DH_RSA_WITH_AES_128_CBC_SHA = 49;
    private static final int TLS_DHE_DSS_WITH_AES_128_CBC_SHA = 50;
    private static final int TLS_DHE_RSA_WITH_AES_128_CBC_SHA = 51;
    private static final int TLS_RSA_WITH_AES_256_CBC_SHA = 53;
    private static final int TLS_DH_DSS_WITH_AES_256_CBC_SHA = 54;
    private static final int TLS_DH_RSA_WITH_AES_256_CBC_SHA = 55;
    private static final int TLS_DHE_DSS_WITH_AES_256_CBC_SHA = 56;
    private static final int TLS_DHE_RSA_WITH_AES_256_CBC_SHA = 57;
    private static final int TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA = 49178;
    private static final int TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA = 49179;
    private static final int TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA = 49180;
    private static final int TLS_SRP_SHA_WITH_AES_128_CBC_SHA = 49181;
    private static final int TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA = 49182;
    private static final int TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA = 49183;
    private static final int TLS_SRP_SHA_WITH_AES_256_CBC_SHA = 49184;
    private static final int TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA = 49185;
    private static final int TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA = 49186;
    private CertificateVerifyer verifyer;
    private TlsProtocolHandler handler;
    private Certificate clientCert = new Certificate(new X509CertificateStructure[0]);
    private AsymmetricKeyParameter clientPrivateKey = null;
    private TlsSigner clientSigner = null;
    private int selectedCipherSuite;

    public DefaultTlsClient(CertificateVerifyer verifyer) {
        this.verifyer = verifyer;
    }

    public void enableClientAuthentication(Certificate clientCertificate, AsymmetricKeyParameter clientPrivateKey) {
        if (clientCertificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (clientCertificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (clientPrivateKey == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!clientPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (clientPrivateKey instanceof RSAKeyParameters) {
            this.clientSigner = new TlsRSASigner();
        } else if (clientPrivateKey instanceof DSAPrivateKeyParameters) {
            this.clientSigner = new TlsDSSSigner();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + clientPrivateKey.getClass().getName());
        }
        this.clientCert = clientCertificate;
        this.clientPrivateKey = clientPrivateKey;
    }

    public void init(TlsProtocolHandler handler) {
        this.handler = handler;
    }

    public int[] getCipherSuites() {
        return new int[]{57, 56, 51, 50, 22, 19, 53, 47, 10};
    }

    public Hashtable generateClientExtensions() {
        return null;
    }

    public void notifySessionID(byte[] sessionID) {
    }

    public void notifySelectedCipherSuite(int selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void processServerExtensions(Hashtable serverExtensions) {
    }

    public TlsKeyExchange createKeyExchange() throws IOException {
        switch (this.selectedCipherSuite) {
            case 10: 
            case 47: 
            case 53: {
                return this.createRSAKeyExchange();
            }
            case 13: 
            case 48: 
            case 54: {
                return this.createDHKeyExchange((short)7);
            }
            case 16: 
            case 49: 
            case 55: {
                return this.createDHKeyExchange((short)8);
            }
            case 19: 
            case 50: 
            case 56: {
                return this.createDHKeyExchange((short)3);
            }
            case 22: 
            case 51: 
            case 57: {
                return this.createDHKeyExchange((short)5);
            }
            case 49178: 
            case 49181: 
            case 49184: {
                return this.createSRPExchange((short)10);
            }
            case 49179: 
            case 49182: 
            case 49185: {
                return this.createSRPExchange((short)12);
            }
            case 49180: 
            case 49183: 
            case 49186: {
                return this.createSRPExchange((short)11);
            }
        }
        this.handler.failWithError((short)2, (short)80);
        return null;
    }

    public void processServerCertificateRequest(byte[] certificateTypes, List certificateAuthorities) {
    }

    public byte[] generateCertificateSignature(byte[] md5andsha1) throws IOException {
        if (this.clientSigner == null) {
            return null;
        }
        try {
            return this.clientSigner.calculateRawSignature(this.clientPrivateKey, md5andsha1);
        }
        catch (CryptoException e) {
            this.handler.failWithError((short)2, (short)80);
            return null;
        }
    }

    public Certificate getCertificate() {
        return this.clientCert;
    }

    public TlsCipher createCipher(SecurityParameters securityParameters) throws IOException {
        switch (this.selectedCipherSuite) {
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 49178: 
            case 49179: 
            case 49180: {
                return this.createDESedeCipher(24, securityParameters);
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 49181: 
            case 49182: 
            case 49183: {
                return this.createAESCipher(16, securityParameters);
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 49184: 
            case 49185: 
            case 49186: {
                return this.createAESCipher(32, securityParameters);
            }
        }
        this.handler.failWithError((short)2, (short)80);
        return null;
    }

    private TlsKeyExchange createDHKeyExchange(short keyExchange) {
        return new TlsDHKeyExchange(this.handler, this.verifyer, keyExchange);
    }

    private TlsKeyExchange createRSAKeyExchange() {
        return new TlsRSAKeyExchange(this.handler, this.verifyer);
    }

    private TlsKeyExchange createSRPExchange(short keyExchange) {
        return new TlsSRPKeyExchange(this.handler, this.verifyer, keyExchange);
    }

    private TlsCipher createAESCipher(int cipherKeySize, SecurityParameters securityParameters) {
        return new TlsBlockCipher(this.handler, DefaultTlsClient.createAESBlockCipher(), DefaultTlsClient.createAESBlockCipher(), new SHA1Digest(), new SHA1Digest(), cipherKeySize, securityParameters);
    }

    private TlsCipher createDESedeCipher(int cipherKeySize, SecurityParameters securityParameters) {
        return new TlsBlockCipher(this.handler, DefaultTlsClient.createDESedeBlockCipher(), DefaultTlsClient.createDESedeBlockCipher(), new SHA1Digest(), new SHA1Digest(), cipherKeySize, securityParameters);
    }

    private static BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    private static BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }
}

