/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.dhcp;

import java.io.Serializable;
import java.net.InetAddress;
import net.jradius.dictionary.vsa_dhcp.Attr_DHCPDHCPServerIdentifier;
import net.jradius.dictionary.vsa_dhcp.Attr_DHCPDomainNameServer;
import net.jradius.dictionary.vsa_dhcp.Attr_DHCPIPAddressLeaseTime;
import net.jradius.dictionary.vsa_dhcp.Attr_DHCPMessageType;
import net.jradius.dictionary.vsa_dhcp.Attr_DHCPRouterAddress;
import net.jradius.dictionary.vsa_dhcp.Attr_DHCPSubnetMask;
import net.jradius.dictionary.vsa_dhcp.Attr_DHCPYourIPAddress;
import net.jradius.handler.PacketHandlerChain;
import net.jradius.handler.dhcp.AddressPool;
import net.jradius.handler.dhcp.AddressPoolImpl;
import net.jradius.handler.dhcp.DHCPException;
import net.jradius.packet.DHCPAck;
import net.jradius.packet.DHCPNack;
import net.jradius.packet.DHCPOffer;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusRequest;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.springframework.beans.factory.InitializingBean;

public class DHCPPoolHandler
extends PacketHandlerChain
implements InitializingBean {
    private CacheManager cacheManager;
    private Cache cache;
    private AddressPoolImpl _pool;

    private AddressPool getDefaultPool() {
        if (this._pool != null) {
            return this._pool;
        }
        try {
            InetAddress[] dns = new InetAddress[]{InetAddress.getByName("10.1.0.1")};
            this._pool = new AddressPoolImpl();
            this._pool.setNetwork(InetAddress.getByName("10.1.0.0"));
            this._pool.setNetmask(InetAddress.getByName("255.255.0.0"));
            this._pool.setRouter(InetAddress.getByName("10.1.0.1"));
            this._pool.setLeaseTime(900);
            this._pool.setDns(dns);
            if (this.cache == null) {
                this.cache = new Cache("ippool", 10000, true, false, (long)(this._pool.getLeaseTime() + 60), (long)(this._pool.getLeaseTime() + 30));
                this.cacheManager.addCache(this.cache);
            }
            this._pool.setLeases(this.cache);
            return this._pool;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean handle(JRadiusRequest request) throws Exception {
        RadiusPacket req = request.getRequestPacket();
        if (req.getCode() < 1024) {
            return false;
        }
        byte[] hwAddress = (byte[])req.getAttributeValue(3539211L);
        if (hwAddress == null) {
            throw new DHCPException("no hardware address");
        }
        return this.handle(request, hwAddress, this.getDefaultPool());
    }

    public boolean handle(JRadiusRequest request, byte[] hwAddress, AddressPool pool) throws Exception {
        RadiusPacket req = request.getRequestPacket();
        RadiusPacket rep = request.getReplyPacket();
        InetAddress requested = (InetAddress)req.getAttributeValue(3538994L);
        if (requested == null) {
            requested = (InetAddress)req.getAttributeValue(3539207L);
        }
        boolean forceRenew = req.getCode() == 1028;
        InetAddress ipAddress = pool.getIP(hwAddress, requested, forceRenew);
        AttributeList attributes = rep.getAttributes();
        switch (req.getCode()) {
            case 1025: {
                if (ipAddress == null && requested != null) {
                    ipAddress = pool.getIP(hwAddress, null, true);
                }
                rep = ipAddress == null ? new DHCPNack() : new DHCPOffer();
                break;
            }
            case 1027: {
                rep = ipAddress == null ? new DHCPNack() : new DHCPAck();
                break;
            }
            case 1028: {
                rep = ipAddress == null ? new DHCPNack() : new DHCPOffer();
                break;
            }
            case 1032: {
                rep = new DHCPAck();
                break;
            }
            case 1031: {
                rep = new DHCPAck();
                break;
            }
            default: {
                return true;
            }
        }
        attributes.add((RadiusAttribute)new Attr_DHCPMessageType((Serializable)Integer.valueOf(rep.getCode() - 1024)));
        if (ipAddress != null) {
            switch (req.getCode()) {
                case 1025: 
                case 1027: {
                    attributes.add((RadiusAttribute)new Attr_DHCPYourIPAddress((Serializable)ipAddress));
                    attributes.add((RadiusAttribute)new Attr_DHCPIPAddressLeaseTime((Serializable)Integer.valueOf(pool.getLeaseTime())));
                    attributes.add((RadiusAttribute)new Attr_DHCPDHCPServerIdentifier((Serializable)pool.getRouter()));
                    InetAddress[] dns = pool.getDns();
                    if (dns != null) {
                        for (int i = 0; i < dns.length; ++i) {
                            attributes.add((RadiusAttribute)new Attr_DHCPDomainNameServer((Serializable)dns[i]), false);
                        }
                    }
                    attributes.add((RadiusAttribute)new Attr_DHCPSubnetMask((Serializable)pool.getNetmask()));
                    attributes.add((RadiusAttribute)new Attr_DHCPRouterAddress((Serializable)pool.getRouter()));
                }
                case 1032: {
                    break;
                }
            }
        }
        rep.getAttributes().add(attributes);
        request.setReplyPacket(rep);
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.cacheManager == null) {
            throw new RuntimeException("cacheManager required");
        }
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }
}

