/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.javamail;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.TransportListener;
import javax.mail.internet.MimeMessage;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.javamail.JavaMailer2;
import org.opennms.javamail.JavaMailerConfig;
import org.opennms.javamail.JavaMailerException;
import org.opennms.netmgt.config.javamail.JavamailProperty;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.config.javamail.SendmailHost;
import org.opennms.netmgt.config.javamail.SendmailMessage;
import org.opennms.netmgt.config.javamail.SendmailProtocol;
import org.opennms.netmgt.config.javamail.UserAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMessageHelper;

public class JavaSendMailer
extends JavaMailer2 {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSendMailer.class);
    private Properties m_properties;
    private SendmailConfig m_config;
    private MimeMessage m_message;
    private Session m_session;

    public JavaSendMailer(SendmailConfig config, boolean useJmProps) throws JavaMailerException {
        this.m_config = config;
        try {
            this.m_session = Session.getInstance((Properties)this.createProps(useJmProps), (Authenticator)this.createAuthenticator());
            if (config.getSendmailMessage() == null) {
                throw new JavaMailerException("Unable to build mime message: sendmail-message missing from config!");
            }
            this.m_message = this.buildMimeMessage(config.getSendmailMessage());
            if (this.m_config.isDebug().booleanValue()) {
                this.m_session.setDebugOut(new PrintStream(new JavaMailer2.LoggingByteArrayOutputStream()));
            }
            this.m_session.setDebug(this.m_config.isDebug().booleanValue());
        }
        catch (IOException e) {
            throw new JavaMailerException("IO problem creating session", e);
        }
    }

    public JavaSendMailer(SendmailConfig config) throws JavaMailerException {
        this(config, true);
    }

    public MimeMessage buildMimeMessage(SendmailMessage msg) {
        MimeMessage mimeMsg = new MimeMessage(this.m_session);
        if (this.m_config.getSendmailMessage() != msg) {
            this.m_config.setSendmailMessage(msg);
        }
        if (this.m_config.getSendmailMessage() != null) {
            SendmailMessage configMsg = this.m_config.getSendmailMessage();
            try {
                String charset = this.m_config.getSendmailProtocol() != null ? this.m_config.getSendmailProtocol().getCharSet() : Charset.defaultCharset().name();
                MimeMessageHelper helper = new MimeMessageHelper(mimeMsg, false, charset);
                helper.setFrom(configMsg.getFrom());
                if (!Strings.isNullOrEmpty((String)configMsg.getReplyTo())) {
                    helper.setReplyTo(configMsg.getReplyTo());
                }
                helper.setTo(configMsg.getTo());
                helper.setSubject(configMsg.getSubject());
            }
            catch (MessagingException e) {
                LOG.warn("found a problem building message: {}", (Object)e.getMessage());
            }
        } else {
            LOG.warn("Missing sendmail message configuration. This MIME message will probably be wrong.");
        }
        return mimeMsg;
    }

    public Authenticator createAuthenticator() {
        Authenticator auth = this.m_config.isUseAuthentication() != false ? new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                if (JavaSendMailer.this.m_config.getUserAuth() != null) {
                    UserAuth userAuth = JavaSendMailer.this.m_config.getUserAuth();
                    return new PasswordAuthentication(JavaMailerConfig.interpolate(userAuth.getUserName()), JavaMailerConfig.interpolate(userAuth.getPassword()));
                }
                LOG.debug("No user authentication configured.");
                return new PasswordAuthentication(null, null);
            }
        } : null;
        return auth;
    }

    private Properties createProps(boolean useJmProps) throws IOException {
        Properties props = this.generatePropsFromConfig(this.m_config.getJavamailProperties());
        this.configureProperties(props, useJmProps);
        return Session.getDefaultInstance((Properties)new Properties()).getProperties();
    }

    private Properties generatePropsFromConfig(List<JavamailProperty> javamailPropertyCollection) {
        Properties props = new Properties();
        for (JavamailProperty property : javamailPropertyCollection) {
            props.put(property.getName(), property.getValue());
        }
        return props;
    }

    private void configureProperties(Properties sendmailConfigDefinedProps, boolean useJmProps) {
        SendmailProtocol sendmailProtocol;
        Properties props = null;
        try {
            props = JavaMailerConfig.getProperties();
            if (useJmProps) {
                this.m_config.setDebug(Boolean.valueOf(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.debug", (boolean)this.m_config.isDebug())));
                if (this.m_config.getSendmailHost() != null) {
                    SendmailHost sendmailHost = this.m_config.getSendmailHost();
                    sendmailHost.setHost(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.mailHost", (String)sendmailHost.getHost()));
                    sendmailHost.setPort(Integer.valueOf(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.smtpport", (int)sendmailHost.getPort())));
                }
                if (this.m_config.getSendmailProtocol() != null) {
                    sendmailProtocol = this.m_config.getSendmailProtocol();
                    sendmailProtocol.setMailer(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.mailer", (String)sendmailProtocol.getMailer()));
                    sendmailProtocol.setTransport(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.transport", (String)sendmailProtocol.getTransport()));
                    sendmailProtocol.setMessageContentType(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.messageContentType", (String)sendmailProtocol.getMessageContentType()));
                    sendmailProtocol.setCharSet(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.charset", (String)sendmailProtocol.getCharSet()));
                    sendmailProtocol.setMessageEncoding(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.encoding", (String)sendmailProtocol.getMessageEncoding()));
                    sendmailProtocol.setStartTls(Boolean.valueOf(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.starttls.enable", (boolean)sendmailProtocol.isStartTls())));
                    sendmailProtocol.setQuitWait(Boolean.valueOf(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.quitwait", (boolean)sendmailProtocol.isQuitWait())));
                    sendmailProtocol.setSslEnable(Boolean.valueOf(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.smtpssl.enable", (boolean)sendmailProtocol.isSslEnable())));
                }
                if (this.m_config.getUserAuth() != null) {
                    UserAuth userAuth = this.m_config.getUserAuth();
                    userAuth.setUserName(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.authenticateUser", (String)userAuth.getUserName()));
                    userAuth.setPassword(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.authenticatePassword", (String)userAuth.getPassword()));
                }
                if (this.m_config.getSendmailMessage() != null) {
                    SendmailMessage sendmailMessage = this.m_config.getSendmailMessage();
                    sendmailMessage.setFrom(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.fromAddress", (String)sendmailMessage.getFrom()));
                    String replyTo = PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.replyToAddress", (String)sendmailMessage.getReplyTo());
                    if (!Strings.isNullOrEmpty((String)replyTo)) {
                        sendmailMessage.setReplyTo(replyTo);
                    }
                }
                this.m_config.setUseJmta(Boolean.valueOf(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.useJMTA", (boolean)this.m_config.isUseJmta())));
                this.m_config.setUseAuthentication(Boolean.valueOf(PropertiesUtils.getProperty((Properties)props, (String)"org.opennms.core.utils.authenticate", (boolean)this.m_config.isUseAuthentication())));
            }
        }
        catch (IOException e) {
            LOG.info("configureProperties: could not load javamail.properties, continuing for is no longer required", (Throwable)e);
        }
        if (props == null) {
            props = new Properties();
        }
        props.putAll((Map<?, ?>)sendmailConfigDefinedProps);
        if (this.m_config.getSendmailProtocol() != null) {
            sendmailProtocol = this.m_config.getSendmailProtocol();
            if (!props.containsKey("mail.smtp.starttls.enable")) {
                props.setProperty("mail.smtp.starttls.enable", String.valueOf(sendmailProtocol.isStartTls()));
            }
            if (!props.containsKey("mail.smtp.quitwait")) {
                props.setProperty("mail.smtp.quitwait", String.valueOf(sendmailProtocol.isQuitWait()));
            }
            if (!props.containsKey("mail.smtp.quitwait")) {
                props.setProperty("mail.smtp.quitwait", String.valueOf(sendmailProtocol.isQuitWait()));
            }
            if (sendmailProtocol.isSslEnable().booleanValue()) {
                if (!props.containsKey("mail.smtps.auth")) {
                    props.setProperty("mail.smtps.auth", String.valueOf(this.m_config.isUseAuthentication()));
                }
                if (!props.containsKey("mail.smtps.socketFactory.class")) {
                    props.setProperty("mail.smtps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                }
                if (!props.containsKey("mail.smtps.socketFactory.port") && this.m_config.getSendmailHost() != null) {
                    props.setProperty("mail.smtps.socketFactory.port", String.valueOf(this.m_config.getSendmailHost().getPort()));
                }
            }
        }
        if (!props.containsKey("mail.smtp.auth")) {
            props.setProperty("mail.smtp.auth", String.valueOf(this.m_config.isUseAuthentication()));
        }
        if (!props.containsKey("mail.smtp.port") && this.m_config.getSendmailHost() != null) {
            props.setProperty("mail.smtp.port", String.valueOf(this.m_config.getSendmailHost().getPort()));
        }
    }

    public void send() throws JavaMailerException {
        if (this.m_config.getSendmailProtocol() == null || this.m_config.getSendmailMessage() == null) {
            throw new JavaMailerException("sendmail-protocol or sendmail-message are not configured!");
        }
        try {
            SendmailProtocol sendmailProtocol = this.m_config.getSendmailProtocol();
            String body = this.m_config.getSendmailMessage().getBody();
            if ("text/plain".equals(sendmailProtocol.getMessageContentType().toLowerCase())) {
                this.m_message.setText(body);
            } else {
                this.m_message.setContent((Object)body, sendmailProtocol.getMessageContentType());
            }
        }
        catch (MessagingException e) {
            LOG.error("Java Mailer messaging exception: {}", (Object)e, (Object)e);
            throw new JavaMailerException("Java Mailer messaging exception: " + String.valueOf((Object)e), e);
        }
        this.send(this.m_message);
    }

    public void send(MimeMessage message) throws JavaMailerException {
        Transport t = null;
        if (this.m_config.getSendmailProtocol() == null || this.m_config.getSendmailHost() == null) {
            throw new JavaMailerException("sendmail-protocol or sendmail-host are not configured!");
        }
        try {
            SendmailProtocol protoConfig = this.m_config.getSendmailProtocol();
            t = this.m_session.getTransport(protoConfig.getTransport());
            LOG.debug("for transport name '{}' got: {}@{}", new Object[]{protoConfig.getTransport(), t.getClass().getName(), Integer.toHexString(t.hashCode())});
            JavaMailer2.LoggingTransportListener listener = new JavaMailer2.LoggingTransportListener();
            t.addTransportListener((TransportListener)listener);
            if ("mta".equals(t.getURLName().getProtocol())) {
                LOG.debug("transport is 'mta', not trying to connect()");
            } else {
                SendmailHost sendmailHost = this.m_config.getSendmailHost();
                if (this.m_config.isUseAuthentication().booleanValue() && this.m_config.getUserAuth() != null) {
                    LOG.debug("authenticating to {}", (Object)sendmailHost.getHost());
                    UserAuth userAuth = this.m_config.getUserAuth();
                    t.connect(sendmailHost.getHost(), sendmailHost.getPort().intValue(), JavaMailerConfig.interpolate(userAuth.getUserName()), JavaMailerConfig.interpolate(userAuth.getPassword()));
                } else {
                    LOG.debug("not authenticating to {}", (Object)sendmailHost.getHost());
                    t.connect(sendmailHost.getHost(), sendmailHost.getPort().intValue(), null, null);
                }
            }
            t.sendMessage((Message)message, message.getAllRecipients());
            listener.assertAllMessagesDelivered();
        }
        catch (NoSuchProviderException e) {
            LOG.error("Couldn't get a transport: {}", (Object)e, (Object)e);
            throw new JavaMailerException("Couldn't get a transport: " + String.valueOf((Object)e), e);
        }
        catch (MessagingException e) {
            LOG.error("Java Mailer messaging exception: {}", (Object)e, (Object)e);
            throw new JavaMailerException("Java Mailer messaging exception: " + String.valueOf((Object)e), e);
        }
        finally {
            try {
                if (t != null && t.isConnected()) {
                    t.close();
                }
            }
            catch (MessagingException e) {
                throw new JavaMailerException("Java Mailer messaging exception on transport close: " + String.valueOf((Object)e), e);
            }
        }
    }

    public void setConfig(SendmailConfig config) {
        this.m_config = config;
    }

    public SendmailConfig getConfig() {
        return this.m_config;
    }

    public void setMessage(MimeMessage message) {
        this.m_message = message;
    }

    public MimeMessage getMessage() {
        return this.m_message;
    }

    public void setProperties(Properties properties) {
        this.m_properties = properties;
    }

    public Properties getProperties() {
        return this.m_properties;
    }
}

