/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.ui;

import com.google.common.base.Strings;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.ui.MarginInfo;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.util.BeanItemContainer;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.DashletSelectorAccess;
import org.opennms.features.vaadin.dashboard.model.Wallboard;
import org.opennms.features.vaadin.dashboard.ui.HeaderLayout;
import org.opennms.features.vaadin.dashboard.ui.dashboard.DashboardView;
import org.opennms.features.vaadin.dashboard.ui.wallboard.WallboardView;

@Theme(value="dashboard")
@Title(value="OpenNMS Ops Board")
public class WallboardUI
extends UI
implements DashletSelectorAccess {
    DashletSelector m_dashletSelector;

    public void setDashletSelector(DashletSelector dashletSelector) {
        this.m_dashletSelector = dashletSelector;
    }

    @Override
    public DashletSelector getDashletSelector() {
        return this.m_dashletSelector;
    }

    protected void init(VaadinRequest request) {
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSizeFull();
        rootLayout.setSpacing(true);
        rootLayout.setMargin(false);
        final HeaderLayout headerLayout = new HeaderLayout();
        MarginInfo headerMargin = headerLayout.getMargin();
        MarginInfo newMargin = new MarginInfo(true, headerMargin.hasRight(), headerMargin.hasBottom(), headerMargin.hasLeft());
        headerLayout.setMargin(newMargin);
        rootLayout.addComponent((Component)headerLayout);
        VerticalLayout portalWrapper = new VerticalLayout();
        portalWrapper.setSizeFull();
        portalWrapper.setMargin(false);
        rootLayout.addComponent((Component)portalWrapper);
        rootLayout.setExpandRatio((Component)portalWrapper, 1.0f);
        this.setContent((Component)rootLayout);
        this.addVueMenu();
        Navigator navigator = new Navigator((UI)this, (ComponentContainer)portalWrapper);
        navigator.addView("dashboard", DashboardView.class);
        navigator.addView("wallboard", WallboardView.class);
        navigator.addViewChangeListener(new ViewChangeListener(){

            public void afterViewChange(ViewChangeListener.ViewChangeEvent viewChangeEvent) {
                headerLayout.setWallboard(viewChangeEvent.getParameters());
            }

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent viewChangeEvent) {
                return true;
            }
        });
        BeanItemContainer<Wallboard> beanItemContainer = WallboardProvider.getInstance().getBeanContainer();
        if (Strings.isNullOrEmpty((String)navigator.getState())) {
            navigator.navigateTo("wallboard");
            for (Wallboard wallboard : beanItemContainer.getItemIds()) {
                if (!wallboard.isDefault()) continue;
                headerLayout.gotoWallboard(wallboard);
                break;
            }
        }
    }

    private void addVueMenu() {
        this.getPage().getJavaScript().execute("var link = document.createElement('link');link.rel = \"stylesheet\";link.type = \"text/css\";link.media = \"screen\";link.href = \"/opennms/ui-components/assets/index.css\"; document.head.appendChild(link);");
        this.getPage().getJavaScript().execute("var div = document.createElement('div');div.id = \"opennms-sidemenu-container\";document.body.appendChild(div);var s = document.createElement('script');s.type = \"module\";s.src = \"/opennms/ui-components/assets/index.js\";document.body.appendChild(s);");
    }
}

