/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.AbstractStringValidator;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.TextField;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.config.ui.DashletSpecEditor;
import org.opennms.features.vaadin.dashboard.config.ui.HelpClickListener;
import org.opennms.features.vaadin.dashboard.config.ui.PreviewClickListener;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.model.DashletFactory;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.features.vaadin.dashboard.model.Wallboard;

public class WallboardEditor
extends VerticalLayout {
    private TabSheet.Tab m_tab;
    private VerticalLayout m_verticalLayout = new VerticalLayout();
    private DashletSelector m_dashletSelector;
    private Wallboard m_wallboard;
    private Map<DashletSpec, DashletSpecEditor> m_dashletSpecEditorMap = new HashMap<DashletSpec, DashletSpecEditor>();

    public WallboardEditor(DashletSelector dashletSelector, Wallboard wallboard) {
        this.m_dashletSelector = dashletSelector;
        this.m_wallboard = wallboard;
        for (DashletSpec dashletSpec : wallboard.getDashletSpecs()) {
            this.addDashletSpec(dashletSpec);
        }
        this.setMargin(true);
        HorizontalLayout upperHorizontalLayout = new HorizontalLayout();
        Label label = new Label("Ops Board configuration");
        label.addStyleName("configuration-title");
        upperHorizontalLayout.addComponent((Component)label);
        upperHorizontalLayout.addComponent((Component)label);
        Button helpButton = new Button("Help");
        helpButton.setDescription("Display help and usage");
        helpButton.setStyleName("small");
        helpButton.addClickListener((Button.ClickListener)new HelpClickListener((Component)this, this.m_dashletSelector));
        upperHorizontalLayout.addComponent((Component)helpButton);
        upperHorizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        upperHorizontalLayout.setComponentAlignment((Component)label, Alignment.MIDDLE_LEFT);
        upperHorizontalLayout.setComponentAlignment((Component)helpButton, Alignment.MIDDLE_RIGHT);
        this.addComponent((Component)upperHorizontalLayout);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        Button addButton = new Button("Add dashlet");
        addButton.setId("opsboard.action.addDashlet");
        addButton.setStyleName("small");
        addButton.setDescription("Add a new dashlet instance");
        addButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                WallboardEditor.this.addDashletSpec(new DashletSpec());
            }
        });
        TextField titleField = new TextField();
        titleField.setDescription("Title for this Ops Board configuration");
        titleField.setValue(wallboard.getTitle());
        titleField.setImmediate(true);
        titleField.addValidator((Validator)new AbstractStringValidator("Title must be unique"){

            protected boolean isValidValue(String s) {
                return (!WallboardProvider.getInstance().containsWallboard(s) || WallboardProvider.getInstance().getWallboard(s).equals(WallboardEditor.this.m_wallboard)) && !"".equals(s);
            }
        });
        titleField.addTextChangeListener(new FieldEvents.TextChangeListener(){

            public void textChange(FieldEvents.TextChangeEvent textChangeEvent) {
                AbstractTextField source = (AbstractTextField)textChangeEvent.getSource();
                source.setValue(textChangeEvent.getText());
                if (source.isValid()) {
                    WallboardEditor.this.m_tab.setCaption(textChangeEvent.getText());
                    WallboardEditor.this.m_wallboard.setTitle(textChangeEvent.getText());
                    WallboardProvider.getInstance().save();
                    ((WallboardConfigUI)WallboardEditor.this.getUI()).notifyMessage("Data saved", "Title");
                }
            }
        });
        titleField.setCaption("Title");
        Button previewButton = new Button("Preview");
        previewButton.setId("opsboard.action.preview");
        previewButton.setDescription("Preview this Ops Board configuration");
        previewButton.setStyleName("small");
        previewButton.addClickListener((Button.ClickListener)new PreviewClickListener((Component)this, this.m_wallboard));
        FormLayout formLayout1 = new FormLayout();
        formLayout1.addComponent((Component)titleField);
        horizontalLayout.addComponent((Component)formLayout1);
        FormLayout formLayout2 = new FormLayout();
        formLayout2.addComponent((Component)addButton);
        horizontalLayout.addComponent((Component)formLayout2);
        FormLayout formLayout3 = new FormLayout();
        formLayout3.addComponent((Component)previewButton);
        horizontalLayout.addComponent((Component)formLayout3);
        this.addComponent((Component)horizontalLayout);
        this.addComponent((Component)this.m_verticalLayout);
    }

    public void swapDashletSpec(DashletSpec dashletSpec, int direction) {
        int index = this.m_wallboard.getDashletSpecs().indexOf(dashletSpec);
        if (index + direction >= 0 && index + direction < this.m_wallboard.getDashletSpecs().size()) {
            Collections.swap(this.m_wallboard.getDashletSpecs(), index, index + direction);
            this.updateDashletSpecs();
            WallboardProvider.getInstance().save();
        }
    }

    public void updateServiceList(List<DashletFactory> serviceList) {
        for (DashletSpecEditor dashletSpecEditor : this.m_dashletSpecEditorMap.values()) {
            dashletSpecEditor.updateDashletSelection(serviceList);
        }
        ((WallboardConfigUI)this.getUI()).notifyMessage("Configuration change", "Dashlet list modified");
    }

    public Wallboard getWallboard() {
        return this.m_wallboard;
    }

    public void setTab(TabSheet.Tab tab) {
        this.m_tab = tab;
    }

    public void updateDashletSpecs() {
        this.m_verticalLayout.removeAllComponents();
        for (DashletSpec dashletSpec : this.m_wallboard.getDashletSpecs()) {
            this.m_verticalLayout.addComponent((Component)this.m_dashletSpecEditorMap.get(dashletSpec));
        }
    }

    public void removeDashletSpecEditor(DashletSpecEditor dashletSpecEditor) {
        this.m_verticalLayout.removeComponent((Component)dashletSpecEditor);
        this.m_dashletSpecEditorMap.remove(dashletSpecEditor.getDashletSpec());
        this.m_wallboard.getDashletSpecs().remove(dashletSpecEditor.getDashletSpec());
        WallboardProvider.getInstance().save();
    }

    private void addDashletSpec(DashletSpec dashletSpec) {
        DashletSpecEditor dashletSpecEditor = new DashletSpecEditor(this, this.m_dashletSelector, dashletSpec);
        this.m_dashletSpecEditorMap.put(dashletSpec, dashletSpecEditor);
        this.m_verticalLayout.addComponent((Component)dashletSpecEditor);
        if (!this.m_wallboard.getDashletSpecs().contains(dashletSpec)) {
            this.m_wallboard.getDashletSpecs().add(dashletSpec);
            WallboardProvider.getInstance().save();
        }
    }
}

