/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.config.Configuration;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONObject;

public class GlassfishDetector
extends AbstractServerDetector {
    private static final Pattern GLASSFISH_VERSION = Pattern.compile("^.*Glassfish.*\\sv?(.*?)$", 2);
    private static final Pattern GLASSFISH_FULL_VERSION = Pattern.compile("^.*Glassfish.*?\\sv?([.\\d]+).*$", 2);
    private static final Pattern PAYARA_VERSION = Pattern.compile("^.*Payara.*\\sv?(.*?)$", 2);
    private static final Pattern PAYARA_FULL_VERSION = Pattern.compile("^.*Payara.*?\\sv?([.\\d]+).*$", 2);
    private static final String GLASSFISH_NAME = "glassfish";
    private static final String GLASSFISH_VENDOR_NAME = "Oracle";
    private static final String PAYARA_NAME = "Payara Server";
    private static final String PAYARA_VENDOR_NAME = "Payara Foundation";
    private String serverName;
    private String vendorName;

    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        String version = this.detectVersion(pMBeanServerExecutor);
        if (version != null) {
            return new GlassfishServerHandle(version, new HashMap<String, String>());
        }
        return null;
    }

    private String detectVersion(MBeanServerExecutor pMBeanServerExecutor) {
        String fullVersion = this.getSingleStringAttribute(pMBeanServerExecutor, "com.sun.appserv:j2eeType=J2EEServer,*", "serverVersion");
        String version = this.extractVersionFromFullVersion(fullVersion);
        if (fullVersion == null || "3".equals(version)) {
            String versionFromAmx = this.getSingleStringAttribute(pMBeanServerExecutor, "amx:type=domain-root,*", "ApplicationServerFullVersion");
            version = this.getVersionFromFullVersion(version, versionFromAmx != null ? versionFromAmx : System.getProperty("glassfish.version"));
        } else if (this.mBeanExists(pMBeanServerExecutor, "com.sun.appserver:type=Host,*")) {
            version = "3";
        }
        return version;
    }

    private String extractVersionFromFullVersion(String pFullVersion) {
        if (pFullVersion != null) {
            Matcher matcher = GLASSFISH_VERSION.matcher(pFullVersion);
            if (matcher.matches()) {
                this.serverName = GLASSFISH_NAME;
                this.vendorName = GLASSFISH_VENDOR_NAME;
                return matcher.group(1);
            }
            matcher = PAYARA_VERSION.matcher(pFullVersion);
            if (matcher.matches()) {
                this.serverName = PAYARA_NAME;
                this.vendorName = PAYARA_VENDOR_NAME;
                return matcher.group(1);
            }
        }
        return null;
    }

    private boolean isAmxBooted(MBeanServerExecutor pServerManager) {
        return this.mBeanExists(pServerManager, "amx:type=domain-root,*");
    }

    private synchronized boolean bootAmx(MBeanServerExecutor pServers, LogHandler pLoghandler) {
        ObjectName bootMBean = null;
        try {
            bootMBean = new ObjectName("amx-support:type=boot-amx");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        try {
            pServers.call(bootMBean, new MBeanServerExecutor.MBeanAction<Void>(){

                @Override
                public Void execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException {
                    pConn.invoke(pName, "bootAMX", null, null);
                    return null;
                }
            }, new Object[0]);
            return true;
        }
        catch (InstanceNotFoundException e) {
            pLoghandler.error("No bootAmx MBean found: " + e, e);
            return false;
        }
        catch (IllegalArgumentException e) {
            pLoghandler.error("Exception while booting AMX: " + e, e);
            return true;
        }
        catch (Exception e) {
            pLoghandler.error("Exception while executing bootAmx: " + e, e);
            return true;
        }
    }

    private String getVersionFromFullVersion(String pOriginalVersion, String pFullVersion) {
        if (pFullVersion == null) {
            return pOriginalVersion;
        }
        Matcher v3Matcher = GLASSFISH_FULL_VERSION.matcher(pFullVersion);
        Matcher payaraMatcher = PAYARA_FULL_VERSION.matcher(pFullVersion);
        if (v3Matcher.matches()) {
            this.serverName = GLASSFISH_NAME;
            this.vendorName = GLASSFISH_VENDOR_NAME;
            return v3Matcher.group(1);
        }
        if (payaraMatcher.matches()) {
            this.serverName = PAYARA_NAME;
            this.vendorName = PAYARA_VENDOR_NAME;
            return payaraMatcher.group(1);
        }
        return pOriginalVersion;
    }

    private class GlassfishServerHandle
    extends ServerHandle {
        private boolean amxShouldBeBooted;
        private LogHandler logHandler;

        public GlassfishServerHandle(String version, Map<String, String> extraInfo) {
            super(GlassfishDetector.this.vendorName, GlassfishDetector.this.serverName, version, extraInfo);
            this.amxShouldBeBooted = false;
        }

        @Override
        public Map<String, String> getExtraInfo(MBeanServerExecutor pServerManager) {
            Map<String, String> extra = super.getExtraInfo(pServerManager);
            if (pServerManager != null && extra != null && this.getVersion().startsWith("3")) {
                extra.put("amxBooted", Boolean.toString(GlassfishDetector.this.isAmxBooted(pServerManager)));
            }
            return extra;
        }

        @Override
        public void preDispatch(MBeanServerExecutor pMBeanServerExecutor, JmxRequest pJmxReq) {
            if (this.amxShouldBeBooted) {
                this.amxShouldBeBooted = !GlassfishDetector.this.bootAmx(pMBeanServerExecutor, this.logHandler);
            }
        }

        @Override
        public void postDetect(MBeanServerExecutor pServerManager, Configuration pConfig, LogHandler pLoghandler) {
            JSONObject opts = this.getDetectorOptions(pConfig, pLoghandler);
            this.amxShouldBeBooted = (opts == null || opts.get("bootAmx") == null || (Boolean)opts.get("bootAmx") != false) && !GlassfishDetector.this.isAmxBooted(pServerManager);
            this.logHandler = pLoghandler;
        }
    }
}

