/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing.impl;

import java.net.InetAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.integration.api.v1.flows.Flow;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.api.FlowSource;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRequest;
import org.opennms.netmgt.flows.classification.persistence.api.Protocols;
import org.opennms.netmgt.flows.processing.enrichment.EnrichedFlow;
import org.opennms.netmgt.flows.processing.impl.DocumentMangler;
import org.opennms.netmgt.telemetry.protocols.cache.NodeInfoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentEnricherImpl {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentEnricherImpl.class);
    private final SessionUtils sessionUtils;
    private final ClassificationEngine classificationEngine;
    private final NodeInfoCache nodeInfoCache;
    private final long clockSkewCorrectionThreshold;
    private final DocumentMangler mangler;

    public DocumentEnricherImpl(SessionUtils sessionUtils, ClassificationEngine classificationEngine, long clockSkewCorrectionThreshold, DocumentMangler mangler, NodeInfoCache nodeInfoCache) {
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.classificationEngine = Objects.requireNonNull(classificationEngine);
        this.nodeInfoCache = Objects.requireNonNull(nodeInfoCache);
        this.clockSkewCorrectionThreshold = clockSkewCorrectionThreshold;
        this.mangler = Objects.requireNonNull(mangler);
    }

    public List<EnrichedFlow> enrich(Collection<Flow> flows, FlowSource source) {
        if (flows.isEmpty()) {
            LOG.info("Nothing to enrich.");
            return Collections.emptyList();
        }
        return (List)this.sessionUtils.withTransaction(() -> flows.stream().flatMap(flow -> {
            Duration skew;
            EnrichedFlow document = this.mangler.mangle(EnrichedFlow.from(flow));
            if (document == null) {
                return Stream.empty();
            }
            document.setHost(source.getSourceAddress());
            document.setLocation(source.getLocation());
            this.nodeInfoCache.getNodeInfoFromCache(source.getLocation(), source.getSourceAddress(), source.getContextKey(), flow.getNodeIdentifier()).ifPresent(document::setExporterNodeInfo);
            if (flow.getDstAddr() != null) {
                this.nodeInfoCache.getNodeInfoFromCache(source.getLocation(), flow.getDstAddr(), null, null).ifPresent(document::setSrcNodeInfo);
            }
            if (flow.getSrcAddr() != null) {
                this.nodeInfoCache.getNodeInfoFromCache(source.getLocation(), flow.getSrcAddr(), null, null).ifPresent(document::setDstNodeInfo);
            }
            if (flow.getSrcAddr() != null) {
                document.setSrcLocality(DocumentEnricherImpl.isPrivateAddress(flow.getSrcAddr()) ? Flow.Locality.PRIVATE : Flow.Locality.PUBLIC);
            }
            if (flow.getDstAddr() != null) {
                document.setDstLocality(DocumentEnricherImpl.isPrivateAddress(flow.getDstAddr()) ? Flow.Locality.PRIVATE : Flow.Locality.PUBLIC);
            }
            if (Flow.Locality.PUBLIC.equals((Object)document.getDstLocality()) || Flow.Locality.PUBLIC.equals((Object)document.getSrcLocality())) {
                document.setFlowLocality(Flow.Locality.PUBLIC);
            } else if (Flow.Locality.PRIVATE.equals((Object)document.getDstLocality()) || Flow.Locality.PRIVATE.equals((Object)document.getSrcLocality())) {
                document.setFlowLocality(Flow.Locality.PRIVATE);
            }
            ClassificationRequest classificationRequest = DocumentEnricherImpl.createClassificationRequest(document);
            if (classificationRequest.isClassifiable()) {
                document.setApplication(this.classificationEngine.classify(classificationRequest));
            }
            if (this.clockSkewCorrectionThreshold > 0L && (skew = Duration.between(flow.getReceivedAt(), flow.getTimestamp())).abs().toMillis() >= this.clockSkewCorrectionThreshold) {
                document.setClockCorrection(skew.negated());
                document.setTimestamp(flow.getTimestamp().minus(skew));
                document.setFirstSwitched(flow.getFirstSwitched().minus(skew));
                document.setDeltaSwitched(flow.getDeltaSwitched().minus(skew));
                document.setLastSwitched(flow.getLastSwitched().minus(skew));
            }
            return Stream.of(document);
        }).collect(Collectors.toList()));
    }

    private static boolean isPrivateAddress(String ipAddress) {
        InetAddress inetAddress = InetAddressUtils.addr((String)ipAddress);
        return inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress();
    }

    public static ClassificationRequest createClassificationRequest(EnrichedFlow document) {
        ClassificationRequest request = new ClassificationRequest();
        request.setProtocol(Protocols.getProtocol((Integer)document.getProtocol()));
        request.setLocation(document.getLocation());
        request.setExporterAddress(document.getHost());
        request.setDstAddress(document.getDstAddr());
        request.setDstPort(document.getDstPort());
        request.setSrcAddress(document.getSrcAddr());
        request.setSrcPort(document.getSrcPort());
        return request;
    }
}

