/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.perspectivepoller;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.api.ThresholdingSession;

public class PerspectivePolledService {
    private final int nodeId;
    private final InetAddress ipAddress;
    private final String serviceName;
    private final String foreignSource;
    private final String foreignId;
    private final String nodeLabel;
    private final Package pkg;
    private final Package.ServiceMatch serviceMatch;
    private final ServiceMonitorLocator serviceMonitorLocator;
    private final String perspectiveLocation;
    private final String residentLocation;
    private final RrdRepository rrdRepository;
    private final ThresholdingSession thresholdingSession;
    private final MonitoredService monitoredService;
    private PollStatus lastStatus;

    public PerspectivePolledService(final int nodeId, final InetAddress ipAddress, final String serviceName, String foreignSource, String foreignId, final String nodeLabel, Package pkg, Package.ServiceMatch serviceMatch, ServiceMonitorLocator serviceMonitorLocator, final String perspectiveLocation, String residentLocation, RrdRepository rrdRepository, ThresholdingSession thresholdingSession) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.ipAddress = Objects.requireNonNull(ipAddress);
        this.serviceName = Objects.requireNonNull(serviceName);
        this.foreignSource = Objects.requireNonNull(foreignSource);
        this.foreignId = Objects.requireNonNull(foreignId);
        this.nodeLabel = Objects.requireNonNull(nodeLabel);
        this.pkg = Objects.requireNonNull(pkg);
        this.serviceMatch = Objects.requireNonNull(serviceMatch);
        this.serviceMonitorLocator = Objects.requireNonNull(serviceMonitorLocator);
        this.perspectiveLocation = Objects.requireNonNull(perspectiveLocation);
        this.residentLocation = Objects.requireNonNull(residentLocation);
        this.rrdRepository = rrdRepository;
        this.thresholdingSession = thresholdingSession;
        this.monitoredService = new MonitoredService(){

            public String getSvcName() {
                return serviceName;
            }

            public String getIpAddr() {
                return InetAddressUtils.str((InetAddress)ipAddress);
            }

            public int getNodeId() {
                return nodeId;
            }

            public String getNodeLabel() {
                return nodeLabel;
            }

            public String getNodeLocation() {
                return perspectiveLocation;
            }

            public InetAddress getAddress() {
                return ipAddress;
            }
        };
    }

    public boolean updateStatus(PollStatus status) {
        if (!Objects.equals(this.lastStatus, status)) {
            this.lastStatus = status;
            return true;
        }
        return false;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public Package getPkg() {
        return this.pkg;
    }

    public Service getServiceConfig() {
        return this.serviceMatch.service;
    }

    public Map<String, String> getPatternVariables() {
        return this.serviceMatch.patternVariables;
    }

    public ServiceMonitorLocator getServiceMonitorLocator() {
        return this.serviceMonitorLocator;
    }

    public MonitoredService getMonitoredService() {
        return this.monitoredService;
    }

    public String getPerspectiveLocation() {
        return this.perspectiveLocation;
    }

    public String getResidentLocation() {
        return this.residentLocation;
    }

    public RrdRepository getRrdRepository() {
        return this.rrdRepository;
    }

    public ThresholdingSession getThresholdingSession() {
        return this.thresholdingSession;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeId", this.nodeId).add("ipAddress", (Object)this.ipAddress).add("serviceName", (Object)this.serviceName).add("pkg", (Object)this.pkg).add("serviceMatch", (Object)this.serviceMatch).add("serviceMonitorLocator", (Object)this.serviceMonitorLocator).add("monitoredService", (Object)this.monitoredService).add("perspectiveLocation", (Object)this.perspectiveLocation).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerspectivePolledService)) {
            return false;
        }
        PerspectivePolledService that = (PerspectivePolledService)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.pkg, that.pkg) && Objects.equals(this.serviceMatch, that.serviceMatch) && Objects.equals(this.serviceMonitorLocator, that.serviceMonitorLocator) && Objects.equals(this.monitoredService, that.monitoredService) && Objects.equals(this.perspectiveLocation, that.perspectiveLocation);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.ipAddress, this.serviceName, this.pkg, this.serviceMatch, this.serviceMonitorLocator, this.monitoredService, this.perspectiveLocation);
    }
}

