/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.opennms.newts.aggregate.IntervalGenerator;
import org.opennms.newts.api.Duration;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.MetricType;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.Results;
import org.opennms.newts.api.Sample;
import org.opennms.newts.api.Timestamp;
import org.opennms.newts.api.ValueType;
import org.opennms.newts.api.query.Datasource;
import org.opennms.newts.api.query.ResultDescriptor;

class PrimaryData
implements Iterator<Results.Row<Measurement>>,
Iterable<Results.Row<Measurement>> {
    private final ResultDescriptor m_resultDescriptor;
    private final Resource m_resource;
    private final Iterator<Timestamp> m_timestamps;
    private final Duration m_interval;
    private Timestamp lastIntervalCeiling = null;
    private final ArrayList<Results.Row<Sample>> m_samples = Lists.newArrayList();
    private final Map<String, Integer> m_lastSampleIndex = Maps.newHashMap();
    private final Map<String, Accumulation> m_accumulation = Maps.newHashMap();

    PrimaryData(Resource resource, Timestamp start, Timestamp end, ResultDescriptor resultDescriptor, Iterator<Results.Row<Sample>> input) {
        this.m_resultDescriptor = (ResultDescriptor)Preconditions.checkNotNull((Object)resultDescriptor, (Object)"result descriptor argument");
        this.m_resource = (Resource)Preconditions.checkNotNull((Object)resource, (Object)"resource argument");
        Preconditions.checkNotNull((Object)start, (Object)"start argument");
        Preconditions.checkNotNull((Object)end, (Object)"end argument");
        this.m_interval = resultDescriptor.getInterval();
        this.m_timestamps = new IntervalGenerator(start.stepFloor(this.m_interval), end.stepCeiling(this.m_interval), this.m_interval);
        Iterators.addAll(this.m_samples, (Iterator)((Iterator)Preconditions.checkNotNull(input, (Object)"input argument")));
    }

    @Override
    public boolean hasNext() {
        return this.m_timestamps.hasNext();
    }

    @Override
    public Results.Row<Measurement> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Timestamp intervalCeiling = this.m_timestamps.next();
        Results.Row output = new Results.Row(intervalCeiling, this.m_resource);
        for (Datasource ds : this.m_resultDescriptor.getDatasources().values()) {
            Accumulation accumulation = this.getOrCreateAccumulation(ds.getSource());
            accumulation.reset();
            int lastSampleIdx = 0;
            if (this.m_lastSampleIndex.containsKey(ds.getSource())) {
                lastSampleIdx = this.m_lastSampleIndex.get(ds.getSource());
            }
            Sample last = null;
            for (int sampleIdx = lastSampleIdx; sampleIdx < this.m_samples.size(); ++sampleIdx) {
                Timestamp upperBound;
                Results.Row<Sample> row = this.m_samples.get(sampleIdx);
                Sample current = (Sample)row.getElement(ds.getSource());
                if (current == null) continue;
                if (last == null) {
                    last = current;
                    lastSampleIdx = sampleIdx;
                    continue;
                }
                if (intervalCeiling.lt(last.getTimestamp())) break;
                Timestamp lowerBound = last.getTimestamp();
                if (this.lastIntervalCeiling != null && this.lastIntervalCeiling.gt(lowerBound)) {
                    lowerBound = this.lastIntervalCeiling;
                }
                if (intervalCeiling.lt(upperBound = current.getTimestamp())) {
                    upperBound = intervalCeiling;
                }
                if (lowerBound.gt(upperBound)) {
                    lowerBound = upperBound;
                }
                Duration elapsedWithinInterval = upperBound.minus(lowerBound);
                Duration elapsedBetweenSamples = current.getTimestamp().minus(last.getTimestamp());
                this.m_lastSampleIndex.put(ds.getSource(), lastSampleIdx);
                accumulation.accumulateValue(elapsedWithinInterval, elapsedBetweenSamples, ds.getHeartbeat(), current.getValue()).accumlateAttrs(current.getAttributes());
                last = current;
                lastSampleIdx = sampleIdx;
            }
            output.addElement((Element)new Measurement(output.getTimestamp(), output.getResource(), ds.getSource(), accumulation.getAverage().doubleValue(), accumulation.getAttributes()));
        }
        this.lastIntervalCeiling = intervalCeiling;
        return output;
    }

    private Accumulation getOrCreateAccumulation(String name) {
        Accumulation result = this.m_accumulation.get(name);
        if (result == null) {
            result = new Accumulation();
            this.m_accumulation.put(name, result);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Results.Row<Measurement>> iterator() {
        return this;
    }

    private static class Accumulation {
        private long m_known;
        private long m_unknown;
        private ValueType<?> m_value;
        private Map<String, String> m_attributes = Maps.newHashMap();

        private Accumulation() {
            this.reset();
        }

        private Accumulation accumulateValue(Duration elapsedWithinInterval, Duration elapsedBetweenSamples, Duration heartbeat, ValueType<?> value) {
            if (elapsedBetweenSamples.lt(heartbeat)) {
                this.m_known += elapsedWithinInterval.asMillis();
                this.m_value = this.m_value.plus((Number)value.times((Number)elapsedWithinInterval.asMillis()));
            } else {
                this.m_unknown += elapsedWithinInterval.asMillis();
            }
            return this;
        }

        private Accumulation accumlateAttrs(Map<String, String> attributes) {
            if (attributes != null) {
                this.m_attributes.putAll(attributes);
            }
            return this;
        }

        private Double getAverage() {
            return this.isValid() ? this.m_value.divideBy((Number)this.m_known).doubleValue() : Double.NaN;
        }

        private long getKnown() {
            return this.m_known;
        }

        private long getUnknown() {
            return this.m_unknown;
        }

        private double getElapsed() {
            return this.getKnown() + this.getUnknown();
        }

        private boolean isValid() {
            return (double)this.getUnknown() < this.getElapsed() / 2.0;
        }

        private void reset() {
            this.m_unknown = 0L;
            this.m_known = 0L;
            this.m_value = ValueType.compose((Number)0, (MetricType)MetricType.GAUGE);
            this.m_attributes = Maps.newHashMap();
        }

        private Map<String, String> getAttributes() {
            return this.m_attributes;
        }
    }
}

