/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext2.cm.change.AbstractCmChange;
import liquibase.ext2.cm.change.AbstractSchemaChange;
import liquibase.ext2.cm.change.HashUtil;
import liquibase.ext2.cm.database.CmDatabase;
import liquibase.ext2.cm.statement.GenericCmStatement;
import liquibase.statement.SqlStatement;
import org.opennms.features.config.dao.impl.util.XsdHelper;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DatabaseChange(name="importSchemaFromXsd", description="Imports a schema from a xsd file.", priority=5)
public class UpgradeSchema
extends AbstractSchemaChange {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSchemaChange.class);
    protected String id;
    protected String xsdFileName;
    protected String xsdFileHash;
    protected String rootElement;

    @Override
    public ValidationErrors validate(CmDatabase database, ValidationErrors validationErrors) {
        this.checkRequiredField(validationErrors, "id", this.id);
        this.checkRequiredField(validationErrors, "xsdFileName", this.xsdFileName);
        this.checkRequiredField(validationErrors, "rootElement", this.rootElement);
        this.checkRequiredField(validationErrors, "xsdFileHash", this.xsdFileHash);
        this.checkHash(validationErrors, this.xsdFileName, this.xsdFileHash);
        return validationErrors;
    }

    private void checkHash(ValidationErrors validationErrors, String xsdFileName, String expectedXsdHash) {
        try {
            String actualHash = HashUtil.getHash(xsdFileName);
            if (!actualHash.equals(this.xsdFileHash)) {
                validationErrors.addError(String.format("The hashes for the schema file %s don't match. Expected from changelog: %s, actual: %s.%n", xsdFileName, expectedXsdHash, actualHash));
            }
        }
        catch (Exception e) {
            validationErrors.addError(String.format("Cannot compare hashes for the schema file %s. Expected from changelog: %s.%n%s", xsdFileName, expectedXsdHash, e.getMessage()));
        }
    }

    @Override
    protected String getChangeName() {
        return "Upgrad";
    }

    @Override
    protected AbstractCmChange.RunnableWithException getCmFunction(ConfigurationManagerService m) {
        return () -> m.changeConfigDefinition(this.id, XsdHelper.buildConfigDefinition((String)this.id, (String)this.xsdFileName, (String)this.rootElement, (String)"/rest/cm"));
    }

    @Override
    public String getConfirmationMessage() {
        return String.format("%sed new schema with schemaName=%s, xsdName=%s, rootElement=%s", this.getChangeName(), this.id, this.xsdFileName, this.rootElement);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new GenericCmStatement(m -> {
            LOG.info("{}ing new schema with schemaName={}, xsdFileName={}, xsdHash={}, rootElement={}", new Object[]{this.getChangeName(), this.id, this.xsdFileName, this.xsdFileHash, this.rootElement});
            try {
                this.getCmFunction((ConfigurationManagerService)m).doRun();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })};
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getXsdFileName() {
        return this.xsdFileName;
    }

    @Override
    public void setXsdFileName(String xsdFileName) {
        this.xsdFileName = xsdFileName;
    }

    @Override
    public String getXsdFileHash() {
        return this.xsdFileHash;
    }

    @Override
    public void setXsdFileHash(String xsdHash) {
        this.xsdFileHash = xsdHash;
    }

    @Override
    public String getRootElement() {
        return this.rootElement;
    }

    @Override
    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }
}

