/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import liquibase.ext2.cm.change.types.BooleanType;
import liquibase.ext2.cm.change.types.NumberType;
import liquibase.ext2.cm.change.types.PropertyType;
import liquibase.ext2.cm.change.types.StringType;
import liquibase.parser.core.ParsedNode;
import org.opennms.features.config.dao.api.ConfigItem;

public class Liqui2ConfigItemUtil {
    public static ConfigItem createConfigItemForProperty(List<ParsedNode> listOfAttributes) {
        String type = Liqui2ConfigItemUtil.getAttributeValueOrThrowException(listOfAttributes, "type");
        if (PropertyType.BOOLEAN.equals(type)) {
            return new BooleanType(listOfAttributes).toItem();
        }
        if (PropertyType.STRING.equals(type)) {
            return new StringType(listOfAttributes).toItem();
        }
        if (PropertyType.NUMBER.equals(type)) {
            return new NumberType(listOfAttributes).toItem();
        }
        throw new IllegalArgumentException(String.format("Unknown type='%s'", type));
    }

    public static Optional<ConfigItem> findPropertyDefinition(ConfigItem schema, String propertyName) {
        Objects.requireNonNull(propertyName);
        return schema.getChildren().stream().filter(i -> propertyName.equals(i.getName())).findAny();
    }

    public static String getAttributeValueOrThrowException(List<ParsedNode> listOfAttributes, String name) {
        return Liqui2ConfigItemUtil.getAttributeValue(listOfAttributes, name).orElseThrow(() -> new IllegalArgumentException(String.format("Attribute %s must not be null.", name)));
    }

    public static Optional<String> getAttributeValue(List<ParsedNode> listOfAttributes, String name) {
        return listOfAttributes.stream().filter(n -> name.equals(n.getName())).findAny().map(ParsedNode::getValue).map(Object::toString);
    }
}

