/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;

public enum MemcacheCmd {
    OTHER(0),
    SET(1),
    ADD(2),
    REPLACE(3),
    APPEND(4),
    PREPEND(5),
    CAS(6),
    GET(7),
    GETS(8),
    INCR(9),
    DECR(10),
    DELETE(11),
    STATS(12),
    FLUSH(13),
    VERSION(14),
    QUIT(15),
    TOUCH(16);

    public final int value;

    private MemcacheCmd(int value) {
        this.value = value;
    }

    public static MemcacheCmd from(ByteBuf buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuf)buffer);
        switch (value) {
            case 0: {
                return OTHER;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return ADD;
            }
            case 3: {
                return REPLACE;
            }
            case 4: {
                return APPEND;
            }
            case 5: {
                return PREPEND;
            }
            case 6: {
                return CAS;
            }
            case 7: {
                return GET;
            }
            case 8: {
                return GETS;
            }
            case 9: {
                return INCR;
            }
            case 10: {
                return DECR;
            }
            case 11: {
                return DELETE;
            }
            case 12: {
                return STATS;
            }
            case 13: {
                return FLUSH;
            }
            case 14: {
                return VERSION;
            }
            case 15: {
                return QUIT;
            }
            case 16: {
                return TOUCH;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeInt32(this.value);
    }
}

