/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.jfree.chart.urls;

import java.io.Serializable;
import org.jfree.util.ObjectUtilities;
import org.opennms.shaded.jasper.org.jfree.chart.urls.XYURLGenerator;
import org.opennms.shaded.jasper.org.jfree.chart.util.ParamChecks;
import org.opennms.shaded.jasper.org.jfree.data.xy.XYDataset;

public class StandardXYURLGenerator
implements XYURLGenerator,
Serializable {
    private static final long serialVersionUID = -1771624523496595382L;
    public static final String DEFAULT_PREFIX = "index.html";
    public static final String DEFAULT_SERIES_PARAMETER = "series";
    public static final String DEFAULT_ITEM_PARAMETER = "item";
    private String prefix;
    private String seriesParameterName;
    private String itemParameterName;

    public StandardXYURLGenerator() {
        this(DEFAULT_PREFIX, DEFAULT_SERIES_PARAMETER, DEFAULT_ITEM_PARAMETER);
    }

    public StandardXYURLGenerator(String prefix) {
        this(prefix, DEFAULT_SERIES_PARAMETER, DEFAULT_ITEM_PARAMETER);
    }

    public StandardXYURLGenerator(String prefix, String seriesParameterName, String itemParameterName) {
        ParamChecks.nullNotPermitted(prefix, "prefix");
        ParamChecks.nullNotPermitted(seriesParameterName, "seriesParameterName");
        ParamChecks.nullNotPermitted(itemParameterName, "itemParameterName");
        this.prefix = prefix;
        this.seriesParameterName = seriesParameterName;
        this.itemParameterName = itemParameterName;
    }

    @Override
    public String generateURL(XYDataset dataset, int series, int item) {
        String url = this.prefix;
        boolean firstParameter = url.indexOf("?") == -1;
        url = url + (firstParameter ? "?" : "&amp;");
        url = url + this.seriesParameterName + "=" + series + "&amp;" + this.itemParameterName + "=" + item;
        return url;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardXYURLGenerator)) {
            return false;
        }
        StandardXYURLGenerator that = (StandardXYURLGenerator)obj;
        if (!ObjectUtilities.equal((Object)that.prefix, (Object)this.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal((Object)that.seriesParameterName, (Object)this.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal((Object)that.itemParameterName, (Object)this.itemParameterName);
    }
}

