/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.types;

import java.text.ParseException;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.FieldDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.ValidityException;
import org.opennms.shaded.jasper.org.exolab.castor.types.BaseDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.types.Time;
import org.opennms.shaded.jasper.org.exolab.castor.xml.NodeType;
import org.opennms.shaded.jasper.org.exolab.castor.xml.XMLFieldDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.xml.XMLFieldHandler;
import org.opennms.shaded.jasper.org.exolab.castor.xml.util.XMLFieldDescriptorImpl;

public class TimeDescriptor
extends BaseDescriptor {
    private static final String XML_NAME = "time";
    private static final XMLFieldDescriptorImpl CONTENT_DESCRIPTOR = new XMLFieldDescriptorImpl(String.class, "content", "content", NodeType.Text);
    private static final FieldDescriptor[] FIELDS;

    public TimeDescriptor() {
        super(XML_NAME, Time.class);
    }

    @Override
    public XMLFieldDescriptor getContentDescriptor() {
        return CONTENT_DESCRIPTOR;
    }

    @Override
    public FieldDescriptor[] getFields() {
        return FIELDS;
    }

    static {
        CONTENT_DESCRIPTOR.setHandler(new TimeDescriptor().new TimeFieldHandler());
        FIELDS = new FieldDescriptor[1];
        TimeDescriptor.FIELDS[0] = CONTENT_DESCRIPTOR;
    }

    class TimeFieldHandler
    extends XMLFieldHandler {
        @Override
        public Object getValue(Object target) throws IllegalStateException {
            Time time = (Time)target;
            return time.toString();
        }

        @Override
        public void setValue(Object target, Object value) throws IllegalStateException {
            if (!(target instanceof Time)) {
                String err = "TimeDescriptor#setValue: expected Date, received instead: " + target.getClass();
                throw new IllegalStateException(err);
            }
            Time timeTarget = (Time)target;
            if (value == null) {
                String err = "TimeDescriptor#setValue: null value.";
                throw new IllegalStateException(err);
            }
            try {
                Time temp = Time.parseTime(value.toString());
                timeTarget.setHour(temp.getHour());
                timeTarget.setMinute(temp.getMinute());
                timeTarget.setSecond(temp.getSeconds(), temp.getMilli());
                if (temp.isUTC()) {
                    timeTarget.setUTC();
                    timeTarget.setZone(temp.getZoneHour(), temp.getZoneMinute());
                    timeTarget.setZoneNegative(temp.isZoneNegative());
                }
            }
            catch (ParseException ex) {
                String err = "TimeDescriptor#setValue: wrong value\n" + ex.getMessage();
                throw new IllegalStateException(err);
            }
        }

        @Override
        public void resetValue(Object target) throws IllegalStateException {
        }

        @Override
        public void checkValidity(Object object) throws ValidityException, IllegalStateException {
        }

        @Override
        public Object newInstance(Object parent) throws IllegalStateException {
            return new Time();
        }
    }
}

