/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.jasper.org.exolab.castor.types;

import java.text.ParseException;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.FieldDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.mapping.ValidityException;
import org.opennms.shaded.jasper.org.exolab.castor.types.BaseDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.types.DateTime;
import org.opennms.shaded.jasper.org.exolab.castor.xml.NodeType;
import org.opennms.shaded.jasper.org.exolab.castor.xml.XMLFieldDescriptor;
import org.opennms.shaded.jasper.org.exolab.castor.xml.XMLFieldHandler;
import org.opennms.shaded.jasper.org.exolab.castor.xml.util.XMLFieldDescriptorImpl;

public class DateTimeDescriptor
extends BaseDescriptor {
    private static final String XML_NAME = "dateTime";
    private static final XMLFieldDescriptorImpl CONTENT_DESCRIPTOR = new XMLFieldDescriptorImpl(String.class, "content", "content", NodeType.Text);
    private static final FieldDescriptor[] FIELDS;

    public DateTimeDescriptor() {
        super(XML_NAME, DateTime.class);
    }

    @Override
    public XMLFieldDescriptor getContentDescriptor() {
        return CONTENT_DESCRIPTOR;
    }

    @Override
    public FieldDescriptor[] getFields() {
        return FIELDS;
    }

    static {
        CONTENT_DESCRIPTOR.setHandler(new DateTimeDescriptor().new DateTimeFieldHandler());
        FIELDS = new FieldDescriptor[1];
        DateTimeDescriptor.FIELDS[0] = CONTENT_DESCRIPTOR;
    }

    class DateTimeFieldHandler
    extends XMLFieldHandler {
        @Override
        public Object getValue(Object target) throws IllegalStateException {
            DateTime date = (DateTime)target;
            return date.toString();
        }

        @Override
        public void setValue(Object target, Object value) throws IllegalStateException {
            if (!(target instanceof DateTime)) {
                String err = "DateTimeDescriptor#setValue: expected DateTime, received instead: " + target.getClass();
                throw new IllegalStateException(err);
            }
            DateTime dateTarget = (DateTime)target;
            if (value == null) {
                String err = "DateTimeDescriptor#setValue: null value.";
                throw new IllegalStateException(err);
            }
            try {
                DateTime temp = DateTime.parseDateTime(value.toString());
                dateTarget.setCentury(temp.getCentury());
                dateTarget.setYear(temp.getYear());
                dateTarget.setMonth(temp.getMonth());
                dateTarget.setDay(temp.getDay());
                dateTarget.setHour(temp.getHour());
                dateTarget.setMinute(temp.getMinute());
                dateTarget.setSecond(temp.getSeconds(), temp.getMilli());
                if (temp.isUTC()) {
                    dateTarget.setUTC();
                    dateTarget.setZone(temp.getZoneHour(), temp.getZoneMinute());
                    dateTarget.setZoneNegative(temp.isZoneNegative());
                }
            }
            catch (ParseException ex) {
                String err = "DateDescriptor#setValue: wrong value\n" + ex.getMessage();
                throw new IllegalStateException(err);
            }
        }

        @Override
        public void resetValue(Object target) throws IllegalStateException {
        }

        @Override
        public void checkValidity(Object object) throws ValidityException, IllegalStateException {
        }

        @Override
        public Object newInstance(Object parent) throws IllegalStateException {
            return new DateTime();
        }
    }
}

