/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.Grid;
import net.sf.jasperreports.engine.export.GridRow;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxDocumentHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxFontHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxFontTableHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxFontTableRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxRunHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxSettingsHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxStyleHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxTableHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxZip;
import net.sf.jasperreports.engine.export.ooxml.GenericElementDocxHandler;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporterContext;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporterNature;
import net.sf.jasperreports.engine.export.ooxml.PropsAppHelper;
import net.sf.jasperreports.engine.export.ooxml.PropsCoreHelper;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.ExifOrientationEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.engine.util.StyledTextWriteContext;
import net.sf.jasperreports.export.DocxExporterConfiguration;
import net.sf.jasperreports.export.DocxReportConfiguration;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRDocxExporter
extends JRAbstractExporter<DocxReportConfiguration, DocxExporterConfiguration, OutputStreamExporterOutput, JRDocxExporterContext> {
    private static final Log log = LogFactory.getLog(JRDocxExporter.class);
    public static final String DOCX_EXPORTER_KEY = "net.sf.jasperreports.docx";
    public static final String EXCEPTION_MESSAGE_KEY_COLUMN_COUNT_OUT_OF_RANGE = "export.docx.column.count.out.of.range";
    public static final String DOCX_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.docx.";
    public static final String PROPERTY_HIDDEN_TEXT = "net.sf.jasperreports.export.docx.hidden.text";
    public static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    public static final String IMAGE_LINK_PREFIX = "link_img_";
    protected DocxZip docxZip;
    protected DocxDocumentHelper docHelper;
    protected Writer docWriter;
    protected Map<String, Pair<String, ExifOrientationEnum>> rendererToImagePathMap;
    protected RenderersCache renderersCache;
    protected int reportIndex;
    protected int pageIndex;
    protected int startPageIndex;
    protected int endPageIndex;
    protected int tableIndex;
    protected boolean startPage;
    protected String invalidCharReplacement;
    protected PrintPageFormat pageFormat;
    protected JRGridLayout pageGridLayout;
    protected LinkedList<Color> backcolorStack = new LinkedList();
    protected Color backcolor;
    protected DocxRunHelper runHelper;
    protected ExporterNature nature;
    protected long bookmarkIndex;
    protected String pageAnchor;
    protected DocxRelsHelper relsHelper;
    protected PropsAppHelper appHelper;
    protected PropsCoreHelper coreHelper;
    protected DocxFontHelper docxFontHelper;
    protected DocxFontTableHelper docxFontTableHelper;
    protected DocxFontTableRelsHelper docxFontTableRelsHelper;
    boolean emptyPageState;

    public JRDocxExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRDocxExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext(null);
    }

    @Override
    protected Class<DocxExporterConfiguration> getConfigurationInterface() {
        return DocxExporterConfiguration.class;
    }

    @Override
    protected Class<DocxReportConfiguration> getItemConfigurationInterface() {
        return DocxReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        this.rendererToImagePathMap = new HashMap<String, Pair<String, ExifOrientationEnum>>();
    }

    @Override
    protected void initReport() {
        super.initReport();
        this.invalidCharReplacement = this.jasperPrint.hasProperties() && this.jasperPrint.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") ? this.jasperPrint.getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars") : this.getPropertiesUtil().getProperty("net.sf.jasperreports.export.xml.replace.invalid.chars", this.jasperPrint);
        DocxReportConfiguration configuration = (DocxReportConfiguration)this.getCurrentItemConfiguration();
        this.nature = new JRDocxExporterNature(this.jasperReportsContext, this.filter, configuration.isFramesAsNestedTables() == false);
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
    }

    protected void exportReportToStream(OutputStream os) throws JRException, IOException {
        String keywords;
        String author;
        String subject;
        this.docxZip = new DocxZip();
        this.docWriter = this.docxZip.getDocumentEntry().getWriter();
        this.docHelper = new DocxDocumentHelper(this.jasperReportsContext, this.docWriter);
        this.docHelper.exportHeader();
        this.relsHelper = new DocxRelsHelper(this.jasperReportsContext, this.docxZip.getRelsEntry().getWriter());
        this.relsHelper.exportHeader();
        this.appHelper = new PropsAppHelper(this.jasperReportsContext, this.docxZip.getAppEntry().getWriter());
        this.coreHelper = new PropsCoreHelper(this.jasperReportsContext, this.docxZip.getCoreEntry().getWriter());
        this.appHelper.exportHeader();
        DocxExporterConfiguration configuration = (DocxExporterConfiguration)this.getCurrentConfiguration();
        String application = configuration.getMetadataApplication();
        if (application == null) {
            application = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
        }
        this.appHelper.exportProperty("Application", application);
        this.coreHelper.exportHeader();
        String title = configuration.getMetadataTitle();
        if (title != null) {
            this.coreHelper.exportProperty("dc:title", title);
        }
        if ((subject = configuration.getMetadataSubject()) != null) {
            this.coreHelper.exportProperty("dc:subject", subject);
        }
        if ((author = configuration.getMetadataAuthor()) != null) {
            this.coreHelper.exportProperty("dc:creator", author);
        }
        if ((keywords = configuration.getMetadataKeywords()) != null) {
            this.coreHelper.exportProperty("cp:keywords", keywords);
        }
        List<ExporterInputItem> items = this.exporterInput.getItems();
        boolean isEmbedFonts = Boolean.TRUE.equals(configuration.isEmbedFonts());
        this.docxFontHelper = new DocxFontHelper(this.jasperReportsContext, this.docxZip, isEmbedFonts);
        DocxStyleHelper styleHelper = new DocxStyleHelper(this, this.docxZip.getStylesEntry().getWriter(), this.docxFontHelper);
        styleHelper.export(this.exporterInput);
        styleHelper.close();
        DocxSettingsHelper settingsHelper = new DocxSettingsHelper(this.jasperReportsContext, this.docxZip.getSettingsEntry().getWriter());
        settingsHelper.export(this.jasperPrint, isEmbedFonts);
        settingsHelper.close();
        this.docxFontTableHelper = new DocxFontTableHelper(this.jasperReportsContext, this.docxZip.getFontTableEntry().getWriter());
        this.docxFontTableHelper.exportHeader();
        this.docxFontTableRelsHelper = new DocxFontTableRelsHelper(this.jasperReportsContext, this.docxZip.getFontTableRelsEntry().getWriter());
        this.docxFontTableRelsHelper.exportHeader();
        this.runHelper = new DocxRunHelper(this.jasperReportsContext, this.docWriter, this.docxFontHelper);
        this.pageFormat = null;
        PrintPageFormat oldPageFormat = null;
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            this.bookmarkIndex = 0L;
            this.emptyPageState = false;
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                this.startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                this.endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new ExportInterruptedException();
                    }
                    page = pages.get(this.pageIndex);
                    this.pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
                    if (oldPageFormat != null && oldPageFormat != this.pageFormat) {
                        this.docHelper.exportSection(oldPageFormat, this.pageGridLayout, false);
                    }
                    this.exportPage(page);
                    oldPageFormat = this.pageFormat;
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (oldPageFormat != null) {
            this.docHelper.exportSection(oldPageFormat, this.pageGridLayout, true);
        }
        this.docHelper.exportFooter();
        this.docHelper.close();
        this.relsHelper.exportFooter();
        this.relsHelper.close();
        this.appHelper.exportFooter();
        this.appHelper.close();
        this.coreHelper.exportFooter();
        this.coreHelper.close();
        this.docxFontHelper.exportFonts();
        this.docxFontTableHelper.exportFooter();
        this.docxFontTableHelper.close();
        this.docxFontTableRelsHelper.exportFooter();
        this.docxFontTableRelsHelper.close();
        this.docxZip.zipEntries(os);
        this.docxZip.dispose();
    }

    protected void exportPage(JRPrintPage page) throws JRException {
        this.startPage = true;
        this.pageAnchor = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.pageIndex + 1);
        Object configuration = this.getCurrentItemConfiguration();
        this.pageGridLayout = new JRGridLayout(this.nature, page.getElements(), (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight(), configuration.getOffsetX() == null ? 0 : configuration.getOffsetX(), configuration.getOffsetY() == null ? 0 : configuration.getOffsetY(), null);
        this.exportGrid(this.pageGridLayout, null);
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, JRPrintElementIndex frameIndex) throws JRException {
        CutsInfo xCuts = gridLayout.getXCuts();
        Grid grid = gridLayout.getGrid();
        DocxTableHelper tableHelper = null;
        int rowCount = grid.getRowCount();
        if (rowCount > 0 && grid.getColumnCount() > 63) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_COLUMN_COUNT_OUT_OF_RANGE, grid.getColumnCount());
        }
        if (!(rowCount != 0 || this.pageIndex >= this.endPageIndex && this.emptyPageState)) {
            tableHelper = new DocxTableHelper(this.jasperReportsContext, this.docWriter, xCuts, false, this.pageFormat, frameIndex);
            int maxReportIndex = this.exporterInput.getItems().size() - 1;
            boolean twice = this.pageIndex > this.startPageIndex && this.pageIndex < this.endPageIndex && !this.emptyPageState || this.reportIndex < maxReportIndex && this.pageIndex == this.endPageIndex;
            tableHelper.getParagraphHelper().exportEmptyPage(this.pageAnchor, this.bookmarkIndex, twice);
            ++this.bookmarkIndex;
            this.emptyPageState = true;
            return;
        }
        tableHelper = new DocxTableHelper(this.jasperReportsContext, this.docWriter, xCuts, frameIndex == null && (this.reportIndex != 0 || this.pageIndex != this.startPageIndex), this.pageFormat, frameIndex);
        tableHelper.exportHeader();
        boolean isFlexibleRowHeight = ((DocxReportConfiguration)this.getCurrentItemConfiguration()).isFlexibleRowHeight();
        for (int row = 0; row < rowCount; ++row) {
            int emptyCellColSpan = 0;
            boolean allowRowResize = false;
            int maxTopPadding = 0;
            int maxBottomPadding = 0;
            GridRow gridRow = grid.getRow(row);
            int rowSize = gridRow.size();
            for (int col = 0; col < rowSize; ++col) {
                JRExporterGridCell gridCell = gridRow.get(col);
                JRLineBox box = gridCell.getBox();
                if (box != null) {
                    Integer bottomPadding;
                    Integer topPadding = box.getTopPadding() + Math.round(box.getTopPen().getLineWidth().floatValue());
                    if (topPadding != null && maxTopPadding < topPadding) {
                        maxTopPadding = topPadding;
                    }
                    if ((bottomPadding = box.getBottomPadding()) != null && maxBottomPadding < bottomPadding) {
                        maxBottomPadding = bottomPadding;
                    }
                }
                allowRowResize = isFlexibleRowHeight && (allowRowResize || gridCell.getElement() instanceof JRPrintText || gridCell.getType() == 2 && ((OccupiedGridCell)gridCell).getOccupier().getElement() instanceof JRPrintText);
            }
            tableHelper.setRowMaxTopPadding(maxTopPadding);
            int rowHeight = gridLayout.getRowHeight(row) - maxBottomPadding;
            if (row == 0 && frameIndex == null) {
                rowHeight -= Math.min(rowHeight, this.pageFormat.getTopMargin());
            }
            tableHelper.exportRowHeader(rowHeight, allowRowResize);
            for (int col = 0; col < rowSize; ++col) {
                JRExporterGridCell gridCell = gridRow.get(col);
                if (gridCell.getType() == 2) {
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                    }
                    OccupiedGridCell occupiedGridCell = (OccupiedGridCell)gridCell;
                    ElementGridCell elementGridCell = (ElementGridCell)occupiedGridCell.getOccupier();
                    tableHelper.exportOccupiedCells(elementGridCell, this.startPage, this.bookmarkIndex, this.pageAnchor);
                    if (this.startPage) {
                        ++this.bookmarkIndex;
                    }
                    col += elementGridCell.getColSpan() - 1;
                } else if (gridCell.getType() == 3) {
                    JRPrintElement element;
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                    }
                    if ((element = gridCell.getElement()) instanceof JRPrintLine) {
                        this.exportLine(tableHelper, (JRPrintLine)element, gridCell);
                    } else if (element instanceof JRPrintRectangle) {
                        this.exportRectangle(tableHelper, (JRPrintRectangle)element, gridCell);
                    } else if (element instanceof JRPrintEllipse) {
                        this.exportEllipse(tableHelper, (JRPrintEllipse)element, gridCell);
                    } else if (element instanceof JRPrintImage) {
                        this.exportImage(tableHelper, (JRPrintImage)element, gridCell);
                    } else if (element instanceof JRPrintText) {
                        this.exportText(tableHelper, (JRPrintText)element, gridCell);
                    } else if (element instanceof JRPrintFrame) {
                        this.exportFrame(tableHelper, (JRPrintFrame)element, gridCell);
                    } else if (element instanceof JRGenericPrintElement) {
                        this.exportGenericElement(tableHelper, (JRGenericPrintElement)element, gridCell);
                    }
                    col += gridCell.getColSpan() - 1;
                } else {
                    ++emptyCellColSpan;
                    tableHelper.exportEmptyCell(gridCell, 1, this.startPage, this.bookmarkIndex, this.pageAnchor);
                    if (this.startPage) {
                        ++this.bookmarkIndex;
                    }
                }
                this.startPage = false;
            }
            tableHelper.exportRowFooter();
        }
        tableHelper.exportFooter();
        this.emptyPageState = false;
    }

    protected void exportLine(DocxTableHelper tableHelper, JRPrintLine line, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = null;
        float ratio = line.getWidth() / line.getHeight();
        pen = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getTopPen() : box.getBottomPen()) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? box.getLeftPen() : box.getRightPen());
        pen.setLineColor(line.getLinePen().getLineColor());
        pen.setLineStyle(line.getLinePen().getLineStyleValue());
        pen.setLineWidth(line.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableHelper.getCellHelper().exportHeader(line, gridCell);
        tableHelper.getParagraphHelper().exportEmptyParagraph(this.startPage, this.bookmarkIndex, this.pageAnchor);
        if (this.startPage) {
            ++this.bookmarkIndex;
        }
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportRectangle(DocxTableHelper tableHelper, JRPrintRectangle rectangle, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableHelper.getCellHelper().exportHeader(rectangle, gridCell);
        tableHelper.getParagraphHelper().exportEmptyParagraph(this.startPage, this.bookmarkIndex, this.pageAnchor);
        if (this.startPage) {
            ++this.bookmarkIndex;
        }
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportEllipse(DocxTableHelper tableHelper, JRPrintEllipse ellipse, JRExporterGridCell gridCell) {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(ellipse.getLinePen().getLineColor());
        pen.setLineStyle(ellipse.getLinePen().getLineStyleValue());
        pen.setLineWidth(ellipse.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableHelper.getCellHelper().exportHeader(ellipse, gridCell);
        tableHelper.getParagraphHelper().exportEmptyParagraph(this.startPage, this.bookmarkIndex, this.pageAnchor);
        if (this.startPage) {
            ++this.bookmarkIndex;
        }
        tableHelper.getCellHelper().exportFooter();
    }

    public void exportText(DocxTableHelper tableHelper, JRPrintText text, JRExporterGridCell gridCell) {
        tableHelper.getCellHelper().exportHeader(text, gridCell);
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.docHelper.write("     <w:p>\n");
        tableHelper.getParagraphHelper().exportProps(text);
        if (this.startPage) {
            this.insertBookmark(this.pageAnchor, this.docHelper);
        }
        if (text.getAnchorName() != null) {
            this.insertBookmark(text.getAnchorName(), this.docHelper);
        }
        boolean startedHyperlink = this.startHyperlink(text, true);
        boolean isNewLineAsParagraph = false;
        if (HorizontalTextAlignEnum.JUSTIFIED.equals(text.getHorizontalTextAlign())) {
            isNewLineAsParagraph = text.hasProperties() && text.getPropertiesMap().containsProperty("net.sf.jasperreports.export.docx.new.line.as.paragraph") ? this.getPropertiesUtil().getBooleanProperty(text, "net.sf.jasperreports.export.docx.new.line.as.paragraph", false) : ((DocxReportConfiguration)this.getCurrentItemConfiguration()).isNewLineAsParagraph().booleanValue();
        }
        if (textLength > 0) {
            this.exportStyledText(this.getCurrentJasperPrint().getDefaultStyleProvider().getStyleResolver().getBaseStyle(text), styledText, this.getTextLocale(text), this.getPropertiesUtil().getBooleanProperty(text, PROPERTY_HIDDEN_TEXT, false), startedHyperlink, isNewLineAsParagraph);
        }
        if (startedHyperlink) {
            this.endHyperlink(true);
        }
        this.docHelper.write("     </w:p>\n");
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportStyledText(JRStyle style, JRStyledText styledText, Locale locale, boolean hiddenText, boolean startedHyperlink, boolean isNewLineJustified) {
        StyledTextWriteContext context = new StyledTextWriteContext();
        Color elementBackcolor = null;
        Map<AttributedCharacterIterator.Attribute, Object> globalAttributes = styledText.getGlobalAttributes();
        if (globalAttributes != null) {
            elementBackcolor = (Color)styledText.getGlobalAttributes().get(TextAttribute.BACKGROUND);
        }
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            String runText = text.substring(iterator.getIndex(), runLimit);
            context.next(attributes, runText);
            if (context.listItemStartsWithNewLine() && !context.isListItemStart() && (context.isListItemEnd() || context.isListStart() || context.isListEnd())) {
                runText = runText.substring(1);
            }
            if (runText.length() > 0) {
                JRPrintHyperlink hyperlink;
                boolean localHyperlink = false;
                if (!startedHyperlink && (hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK)) != null) {
                    localHyperlink = this.startHyperlink(hyperlink, true);
                }
                String bulletText = JRStyledTextUtil.getIndentedBulletText(context);
                this.runHelper.export(style, attributes, (bulletText == null ? "" : bulletText) + runText, locale, hiddenText, this.invalidCharReplacement, elementBackcolor, isNewLineJustified);
                if (localHyperlink) {
                    this.endHyperlink(true);
                }
            }
            iterator.setIndex(runLimit);
        }
    }

    public void exportImage(DocxTableHelper tableHelper, JRPrintImage image, JRExporterGridCell gridCell) throws JRException {
        int leftPadding = image.getLineBox().getLeftPadding();
        int topPadding = image.getLineBox().getTopPadding() + Math.round(image.getLineBox().getTopPen().getLineWidth().floatValue());
        int rightPadding = image.getLineBox().getRightPadding();
        int bottomPadding = image.getLineBox().getBottomPadding();
        int availableImageWidth = image.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = image.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        tableHelper.getCellHelper().exportHeader(image, gridCell);
        this.docHelper.write("<w:p>\n");
        tableHelper.getParagraphHelper().exportProps(image);
        Renderable renderer = image.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block37: {
                InternalImageProcessor imageProcessor = new InternalImageProcessor(image, gridCell, availableImageWidth, availableImageHeight);
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, image.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block37;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                int renderWidth = availableImageWidth;
                int renderHeight = availableImageHeight;
                float xoffset = 0.0f;
                float yoffset = 0.0f;
                double cropTop = 0.0;
                double cropLeft = 0.0;
                double cropBottom = 0.0;
                double cropRight = 0.0;
                int angle = 0;
                block1 : switch (image.getScaleImageValue()) {
                    case FILL_FRAME: {
                        switch (ImageUtil.getRotation(image.getRotation(), imageProcessorResult.exifOrientation)) {
                            case LEFT: {
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                angle = -90;
                                break block1;
                            }
                            case RIGHT: {
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                angle = 90;
                                break block1;
                            }
                            case UPSIDE_DOWN: {
                                renderWidth = availableImageWidth;
                                renderHeight = availableImageHeight;
                                angle = 180;
                                break block1;
                            }
                        }
                        renderWidth = availableImageWidth;
                        renderHeight = availableImageHeight;
                        angle = 0;
                        break;
                    }
                    case CLIP: {
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        renderWidth = availableImageWidth;
                        renderHeight = availableImageHeight;
                        switch (ImageUtil.getRotation(image.getRotation(), imageProcessorResult.exifOrientation)) {
                            case LEFT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                angle = -90;
                                break;
                            }
                            case RIGHT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - normalWidth) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - normalHeight) / (double)availableImageWidth;
                                angle = 90;
                                break;
                            }
                            case UPSIDE_DOWN: {
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                angle = 180;
                                break;
                            }
                            default: {
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - normalWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - normalHeight) / (double)availableImageHeight;
                                angle = 0;
                            }
                        }
                        ImageUtil.Insets exifCrop = ImageUtil.getExifCrop(image, imageProcessorResult.exifOrientation, cropTop, cropLeft, cropBottom, cropRight);
                        cropLeft = exifCrop.left;
                        cropRight = exifCrop.right;
                        cropTop = exifCrop.top;
                        cropBottom = exifCrop.bottom;
                        break;
                    }
                    default: {
                        double normalWidth = availableImageWidth;
                        double normalHeight = availableImageHeight;
                        Dimension2D dimension = imageProcessorResult.dimension;
                        if (dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                        double ratioX = 1.0;
                        double ratioY = 1.0;
                        double imageWidth = availableImageWidth;
                        double imageHeight = availableImageHeight;
                        switch (ImageUtil.getRotation(image.getRotation(), imageProcessorResult.exifOrientation)) {
                            case LEFT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                ratioX = (double)availableImageWidth / normalHeight;
                                ratioY = (double)availableImageHeight / normalWidth;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalHeight * ratioX);
                                imageHeight = (int)(normalWidth * ratioY);
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                angle = -90;
                                break;
                            }
                            case RIGHT: {
                                if (dimension == null) {
                                    normalWidth = availableImageHeight;
                                    normalHeight = availableImageWidth;
                                }
                                renderWidth = availableImageHeight;
                                renderHeight = availableImageWidth;
                                ratioX = (double)availableImageWidth / normalHeight;
                                ratioY = (double)availableImageHeight / normalWidth;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalHeight * ratioX);
                                imageHeight = (int)(normalWidth * ratioY);
                                xoffset = (availableImageWidth - availableImageHeight) / 2;
                                yoffset = -(availableImageWidth - availableImageHeight) / 2;
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                angle = 90;
                                break;
                            }
                            case UPSIDE_DOWN: {
                                renderWidth = availableImageWidth;
                                renderHeight = availableImageHeight;
                                ratioX = (double)availableImageWidth / normalWidth;
                                ratioY = (double)availableImageHeight / normalHeight;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalWidth * ratioX);
                                imageHeight = (int)(normalHeight * ratioY);
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                angle = 180;
                                break;
                            }
                            default: {
                                renderWidth = availableImageWidth;
                                renderHeight = availableImageHeight;
                                ratioX = (double)availableImageWidth / normalWidth;
                                ratioY = (double)availableImageHeight / normalHeight;
                                ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                                imageWidth = (int)(normalWidth * ratioX);
                                imageHeight = (int)(normalHeight * ratioY);
                                cropLeft = (double)ImageUtil.getXAlignFactor(image) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropRight = (double)(1.0f - ImageUtil.getXAlignFactor(image)) * ((double)availableImageWidth - imageWidth) / (double)availableImageWidth;
                                cropTop = (double)ImageUtil.getYAlignFactor(image) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                cropBottom = (double)(1.0f - ImageUtil.getYAlignFactor(image)) * ((double)availableImageHeight - imageHeight) / (double)availableImageHeight;
                                angle = 0;
                            }
                        }
                        ImageUtil.Insets exifCrop = ImageUtil.getExifCrop(image, imageProcessorResult.exifOrientation, cropTop, cropLeft, cropBottom, cropRight);
                        cropLeft = exifCrop.left;
                        cropRight = exifCrop.right;
                        cropTop = exifCrop.top;
                        cropBottom = exifCrop.bottom;
                    }
                }
                if (this.startPage) {
                    this.insertBookmark(this.pageAnchor, this.docHelper);
                }
                if (image.getAnchorName() != null) {
                    this.insertBookmark(image.getAnchorName(), this.docHelper);
                }
                this.docHelper.write("<w:r>\n");
                this.docHelper.write("<w:rPr/>\n");
                this.docHelper.write("<w:drawing>\n");
                this.docHelper.write("<wp:anchor distT=\"0\" distB=\"0\" distL=\"0\" distR=\"0\" simplePos=\"0\" relativeHeight=\"0\" behindDoc=\"0\" locked=\"0\" layoutInCell=\"1\" allowOverlap=\"1\">\n");
                this.docHelper.write("<wp:simplePos x=\"0\" y=\"0\"/>\n");
                this.docHelper.write("<wp:positionH relativeFrom=\"column\">\n");
                this.docHelper.write("<wp:posOffset>" + LengthUtil.emu(xoffset) + "</wp:posOffset>\n");
                this.docHelper.write("</wp:positionH>\n");
                this.docHelper.write("<wp:positionV relativeFrom=\"paragraph\">\n");
                this.docHelper.write("<wp:posOffset>" + LengthUtil.emu(yoffset + (float)topPadding - (float)tableHelper.getRowMaxTopPadding()) + "</wp:posOffset>\n");
                this.docHelper.write("</wp:positionV>\n");
                this.docHelper.write("<wp:extent cx=\"" + LengthUtil.emu(renderWidth) + "\" cy=\"" + LengthUtil.emu(renderHeight) + "\"/>\n");
                this.docHelper.write("<wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/>\n");
                this.docHelper.write("<wp:wrapNone/>\n");
                int imageId = image.hashCode() > 0 ? image.hashCode() : -image.hashCode();
                String rId = IMAGE_LINK_PREFIX + this.getElementIndex(gridCell);
                this.docHelper.write("<wp:docPr id=\"" + imageId + "\" name=\"Picture\">\n");
                if (this.getHyperlinkURL(image) != null) {
                    this.docHelper.write("<a:hlinkClick xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" r:id=\"" + rId + "\"/>\n");
                }
                this.docHelper.write("</wp:docPr>\n");
                this.docHelper.write("<a:graphic>\n");
                this.docHelper.write("<a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/picture\">\n");
                this.docHelper.write("<pic:pic>\n");
                this.docHelper.write("<pic:nvPicPr><pic:cNvPr id=\"" + imageId + "\" name=\"Picture\"/><pic:cNvPicPr/></pic:nvPicPr>\n");
                this.docHelper.write("<pic:blipFill>\n");
                this.docHelper.write("<a:blip r:embed=\"" + imageProcessorResult.imagePath + "\"/>");
                this.docHelper.write("<a:srcRect/>");
                this.docHelper.write("<a:stretch><a:fillRect");
                this.docHelper.write(" l=\"" + (int)(100000.0 * cropLeft) + "\"");
                this.docHelper.write(" t=\"" + (int)(100000.0 * cropTop) + "\"");
                this.docHelper.write(" r=\"" + (int)(100000.0 * cropRight) + "\"");
                this.docHelper.write(" b=\"" + (int)(100000.0 * cropBottom) + "\"");
                this.docHelper.write("/></a:stretch>\n");
                this.docHelper.write("</pic:blipFill>\n");
                this.docHelper.write("<pic:spPr>\n");
                this.docHelper.write("  <a:xfrm rot=\"" + 60000 * angle + "\">\n");
                this.docHelper.write("    <a:off x=\"0\" y=\"0\"/>\n");
                this.docHelper.write("    <a:ext cx=\"" + LengthUtil.emu(renderWidth) + "\" cy=\"" + LengthUtil.emu(renderHeight) + "\"/>");
                this.docHelper.write("  </a:xfrm>\n");
                this.docHelper.write("  <a:prstGeom prst=\"rect\"></a:prstGeom>\n");
                this.docHelper.write("</pic:spPr>\n");
                this.docHelper.write("</pic:pic>\n");
                this.docHelper.write("</a:graphicData>\n");
                this.docHelper.write("</a:graphic>\n");
                this.docHelper.write("</wp:anchor>\n");
                this.docHelper.write("</w:drawing>\n");
                this.docHelper.write("</w:r>");
                String url = this.getHyperlinkURL(image);
                if (url != null) {
                    String targetMode = "";
                    switch (image.getHyperlinkTypeValue()) {
                        case LOCAL_PAGE: 
                        case LOCAL_ANCHOR: {
                            this.relsHelper.exportImageLink(rId, "#" + url.replaceAll("\\W", ""), targetMode);
                            break;
                        }
                        case REMOTE_PAGE: 
                        case REMOTE_ANCHOR: 
                        case REFERENCE: {
                            targetMode = " TargetMode=\"External\"";
                            this.relsHelper.exportImageLink(rId, url, targetMode);
                            break;
                        }
                    }
                }
            }
        }
        this.docHelper.write("</w:p>");
        tableHelper.getCellHelper().exportFooter();
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getElementAddress());
        return imageIndex;
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("export.common.invalid.image.name", imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(DocxTableHelper tableHelper, JRPrintFrame frame, JRExporterGridCell gridCell) throws JRException {
        boolean appendBackcolor;
        tableHelper.getCellHelper().exportHeader(frame, gridCell);
        boolean bl = appendBackcolor = frame.getModeValue() == ModeEnum.OPAQUE && (this.backcolor == null || frame.getBackcolor().getRGB() != this.backcolor.getRGB());
        if (appendBackcolor) {
            this.setBackcolor(frame.getBackcolor());
        }
        try {
            JRGridLayout layout = ((ElementGridCell)gridCell).getLayout();
            JRPrintElementIndex frameIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getElementAddress());
            this.exportGrid(layout, frameIndex);
        }
        finally {
            if (appendBackcolor) {
                this.restoreBackcolor();
            }
        }
        tableHelper.getParagraphHelper().exportEmptyParagraph();
        tableHelper.getCellHelper().exportFooter();
    }

    protected void exportGenericElement(DocxTableHelper tableHelper, JRGenericPrintElement element, JRExporterGridCell gridCell) {
        GenericElementDocxHandler handler = (GenericElementDocxHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), DOCX_EXPORTER_KEY);
        if (handler != null) {
            ExporterContext exporterContext = new ExporterContext(tableHelper);
            handler.exportElement(exporterContext, element, gridCell);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No DOCX generic element handler for " + element.getGenericType()));
        }
    }

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = this.backcolorStack.removeLast();
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText) {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            String tooltip;
            this.docHelper.write("<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r>\n");
            String localType = HyperlinkTypeEnum.LOCAL_ANCHOR == link.getHyperlinkTypeValue() || HyperlinkTypeEnum.LOCAL_PAGE == link.getHyperlinkTypeValue() ? "\\l " : "";
            this.docHelper.write("<w:r><w:instrText xml:space=\"preserve\"> HYPERLINK " + localType + "\"" + JRStringUtil.xmlEncode(href, this.invalidCharReplacement) + "\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.docHelper.write(" \\t \"" + target + "\"");
            }
            if ((tooltip = link.getHyperlinkTooltip()) != null) {
                this.docHelper.write(" \\o \"" + JRStringUtil.xmlEncode(tooltip, this.invalidCharReplacement) + "\"");
            }
            this.docHelper.write(" </w:instrText></w:r>\n");
            this.docHelper.write("<w:r><w:fldChar w:fldCharType=\"separate\"/></w:r>\n");
        }
        return href != null;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block14: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.docx.ignore.hyperlink", link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = ((DocxReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
                }
                if (ignoreHyperlink.booleanValue()) break block13;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block14;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkAnchor().replaceAll("\\W", "");
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink(boolean isText) {
        this.docHelper.write("<w:r><w:fldChar w:fldCharType=\"end\"/></w:r>\n");
    }

    protected void insertBookmark(String bookmark, BaseHelper helper) {
        helper.write("<w:bookmarkStart w:id=\"" + this.bookmarkIndex);
        helper.write("\" w:name=\"" + (bookmark == null ? null : bookmark.replaceAll("\\W", "")));
        helper.write("\"/><w:bookmarkEnd w:id=\"" + this.bookmarkIndex++);
        helper.write("\"/>");
    }

    @Override
    protected void ensureInput() {
        super.ensureInput();
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        return this.styledTextUtil.getProcessedStyledText(textElement, setBackcolor ? this.allSelector : this.noBackcolorSelector, this.getExporterKey());
    }

    @Override
    public String getExporterKey() {
        return DOCX_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return DOCX_EXPORTER_PROPERTIES_PREFIX;
    }

    private class InternalImageProcessorResult {
        protected final String imagePath;
        protected final Dimension2D dimension;
        protected final ExifOrientationEnum exifOrientation;

        protected InternalImageProcessorResult(String imagePath, Dimension2D dimension, ExifOrientationEnum exifOrientation) {
            this.imagePath = imagePath;
            this.dimension = dimension;
            this.exifOrientation = exifOrientation;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintElement imageElement;
        private final RenderersCache imageRenderersCache;
        private final boolean needDimension;
        private final JRExporterGridCell cell;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement, JRExporterGridCell cell, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.cell = cell;
            this.imageRenderersCache = imageElement.isUsingCache() ? JRDocxExporter.this.renderersCache : new RenderersCache(JRDocxExporter.this.getJasperReportsContext());
            boolean bl = this.needDimension = imageElement.getScaleImageValue() != ScaleImageEnum.FILL_FRAME;
            if (imageElement.getRotation() == RotationEnum.LEFT || imageElement.getRotation() == RotationEnum.RIGHT) {
                this.availableImageWidth = availableImageHeight;
                this.availableImageHeight = availableImageWidth;
            } else {
                this.availableImageWidth = availableImageWidth;
                this.availableImageHeight = availableImageHeight;
            }
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException {
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            Dimension2D dimension = null;
            if (this.needDimension) {
                DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable(renderer);
                dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(JRDocxExporter.this.jasperReportsContext);
            }
            ExifOrientationEnum exifOrientation = ExifOrientationEnum.NORMAL;
            String imagePath = null;
            if (renderer instanceof DataRenderable && JRDocxExporter.this.rendererToImagePathMap.containsKey(renderer.getId())) {
                Pair<String, ExifOrientationEnum> imagePair = JRDocxExporter.this.rendererToImagePathMap.get(renderer.getId());
                imagePath = imagePair.first();
                exifOrientation = imagePair.second();
            } else {
                JRPrintElementIndex imageIndex = JRDocxExporter.this.getElementIndex(this.cell);
                DataRenderable imageRenderer = JRDocxExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, new Dimension(this.availableImageWidth, this.availableImageHeight), ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null);
                byte[] imageData = imageRenderer.getData(JRDocxExporter.this.jasperReportsContext);
                exifOrientation = ImageUtil.getExifOrientation(imageData);
                String fileExtension = JRTypeSniffer.getImageTypeValue(imageData).getFileExtension();
                String imageName = JRDocxExporter.IMAGE_NAME_PREFIX + imageIndex.toString() + (fileExtension == null ? "" : "." + fileExtension);
                JRDocxExporter.this.docxZip.addEntry(new FileBufferedZipEntry("word/media/" + imageName, imageData));
                JRDocxExporter.this.relsHelper.exportImage(imageName);
                imagePath = imageName;
                if (imageRenderer == renderer) {
                    JRDocxExporter.this.rendererToImagePathMap.put(renderer.getId(), new Pair<String, ExifOrientationEnum>(imagePath, exifOrientation));
                }
            }
            return new InternalImageProcessorResult(imagePath, dimension, exifOrientation);
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRDocxExporterContext {
        DocxTableHelper tableHelper = null;

        public ExporterContext(DocxTableHelper tableHelper) {
            this.tableHelper = tableHelper;
        }

        @Override
        public DocxTableHelper getTableHelper() {
            return this.tableHelper;
        }
    }
}

