/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementXlsMetadataHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.ImageSettings;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractMetadataExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterContext;
import net.sf.jasperreports.engine.export.JRXlsExporterNature;
import net.sf.jasperreports.engine.export.JRXlsMetadataExporterNature;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.export.data.TextValueHandler;
import net.sf.jasperreports.engine.export.type.ImageAnchorTypeEnum;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.export.XlsExporterConfiguration;
import net.sf.jasperreports.export.XlsMetadataExporterConfiguration;
import net.sf.jasperreports.export.XlsMetadataReportConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HeaderFooter;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellReference;

public class JRXlsMetadataExporter
extends JRXlsAbstractMetadataExporter<XlsMetadataReportConfiguration, XlsMetadataExporterConfiguration, JRXlsExporterContext> {
    private static final Log log = LogFactory.getLog(JRXlsMetadataExporter.class);
    public static final String XLS_EXPORTER_KEY = "net.sf.jasperreports.xls";
    public static short MAX_COLOR_INDEX = (short)56;
    public static short MIN_COLOR_INDEX = (short)10;
    public static String CURRENT_ROW_HEIGHT = "CURRENT_ROW_HEIGHT";
    private static Map<Color, HSSFColor> hssfColorsCache = new ReferenceMap();
    protected final DateFormat isoDateFormat = JRDataUtils.getIsoDateFormat();
    protected Map<StyleInfo, HSSFCellStyle> loadedCellStyles = new HashMap<StyleInfo, HSSFCellStyle>();
    protected Map<String, List<Hyperlink>> anchorLinks = new HashMap<String, List<Hyperlink>>();
    protected Map<Integer, List<Hyperlink>> pageLinks = new HashMap<Integer, List<Hyperlink>>();
    protected Map<String, HSSFName> anchorNames = new HashMap<String, HSSFName>();
    protected HSSFWorkbook workbook;
    protected HSSFSheet sheet;
    protected HSSFRow row;
    protected HSSFCell cell;
    protected HSSFCellStyle emptyCellStyle;
    protected CreationHelper createHelper;
    private HSSFPalette palette = null;
    protected Map<String, HSSFCellStyle> columnStylesMap;
    protected Map<String, Integer> columnWidths;
    protected Map<String, Float> columnWidthRatios;
    protected Map<HSSFCell, String> formulaCellsMap;
    protected short whiteIndex = HSSFColor.HSSFColorPredefined.WHITE.getIndex();
    protected short blackIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
    protected short customColorIndex = MIN_COLOR_INDEX;
    protected FillPatternType backgroundMode = FillPatternType.SOLID_FOREGROUND;
    protected HSSFDataFormat dataFormat;
    protected HSSFPatriarch patriarch;
    protected static final String EMPTY_SHEET_NAME = "Sheet1";

    public JRXlsMetadataExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXlsMetadataExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<XlsMetadataExporterConfiguration> getConfigurationInterface() {
        return XlsMetadataExporterConfiguration.class;
    }

    @Override
    protected Class<XlsMetadataReportConfiguration> getItemConfigurationInterface() {
        return XlsMetadataReportConfiguration.class;
    }

    @Override
    protected void initExport() {
        super.initExport();
        this.sheet = null;
    }

    @Override
    protected void initReport() {
        super.initReport();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        if (!configuration.isWhitePageBackground().booleanValue()) {
            this.backgroundMode = FillPatternType.NO_FILL;
        }
        this.nature = new JRXlsMetadataExporterNature(this.jasperReportsContext, this.filter, configuration.isIgnoreGraphics(), configuration.isIgnorePageMargins());
    }

    @Override
    protected void openWorkbook(OutputStream os) throws JRException {
        String lcWorkbookTemplate;
        XlsMetadataExporterConfiguration configuration = (XlsMetadataExporterConfiguration)this.getCurrentConfiguration();
        String string = lcWorkbookTemplate = this.workbookTemplate == null ? configuration.getWorkbookTemplate() : this.workbookTemplate;
        if (lcWorkbookTemplate == null) {
            this.workbook = new HSSFWorkbook();
        } else {
            InputStream templateIs = null;
            try {
                templateIs = this.getRepository().getInputStreamFromLocation(lcWorkbookTemplate);
                if (templateIs == null) {
                    throw new JRRuntimeException("export.xls.common.template.not.found", lcWorkbookTemplate);
                }
                this.workbook = new HSSFWorkbook(new POIFSFileSystem(templateIs));
                boolean keepSheets = this.keepTemplateSheets == null ? configuration.isKeepWorkbookTemplateSheets() : this.keepTemplateSheets;
                if (keepSheets) {
                    this.sheetIndex += this.workbook.getNumberOfSheets();
                } else {
                    for (int i = 0; i < this.workbook.getNumberOfSheets(); ++i) {
                        this.workbook.removeSheetAt(i);
                    }
                }
            }
            catch (IOException | JRException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                if (templateIs != null) {
                    try {
                        templateIs.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.emptyCellStyle = this.workbook.createCellStyle();
        this.emptyCellStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.emptyCellStyle.setFillPattern(this.backgroundMode);
        this.dataFormat = this.workbook.createDataFormat();
        this.createHelper = this.workbook.getCreationHelper();
        this.firstPageNotSet = true;
        this.palette = this.workbook.getCustomPalette();
        this.customColorIndex = MIN_COLOR_INDEX;
        this.columnWidths = new HashMap<String, Integer>();
        this.columnWidthRatios = new HashMap<String, Float>();
        this.formulaCellsMap = new HashMap<HSSFCell, String>();
    }

    @Override
    protected void createSheet(JRXlsAbstractExporter.SheetInfo sheetInfo) {
        String password;
        this.sheetInfo = sheetInfo;
        this.sheet = this.workbook.createSheet(sheetInfo.sheetName);
        this.patriarch = this.sheet.createDrawingPatriarch();
        HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
        printSetup.setLandscape(this.pageFormat.getOrientation() == OrientationEnum.LANDSCAPE);
        short paperSize = this.getSuitablePaperSize();
        XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
        if (paperSize != -1) {
            printSetup.setPaperSize(paperSize);
        }
        if ((password = configuration.getPassword()) != null) {
            this.sheet.protectSheet(password);
        }
        this.sheet.setMargin((short)0, LengthUtil.inch(configuration.getPrintPageLeftMargin().intValue()));
        this.sheet.setMargin((short)1, LengthUtil.inch(configuration.getPrintPageRightMargin().intValue()));
        this.sheet.setMargin((short)2, LengthUtil.inch(configuration.getPrintPageTopMargin().intValue()));
        this.sheet.setMargin((short)3, LengthUtil.inch(configuration.getPrintPageBottomMargin().intValue()));
        if (configuration.getSheetHeaderLeft() != null) {
            this.sheet.getHeader().setLeft(configuration.getSheetHeaderLeft());
        }
        if (configuration.getSheetHeaderCenter() != null) {
            this.sheet.getHeader().setCenter(configuration.getSheetHeaderCenter());
        }
        if (configuration.getSheetHeaderRight() != null) {
            this.sheet.getHeader().setRight(configuration.getSheetHeaderRight());
        }
        if (configuration.getSheetFooterLeft() != null) {
            this.sheet.getFooter().setLeft(configuration.getSheetFooterLeft());
        }
        if (configuration.getSheetFooterCenter() != null) {
            this.sheet.getFooter().setCenter(configuration.getSheetFooterCenter());
        }
        if (configuration.getSheetFooterRight() != null) {
            this.sheet.getFooter().setRight(configuration.getSheetFooterRight());
        }
        printSetup.setHeaderMargin(LengthUtil.inch(configuration.getPrintHeaderMargin().intValue()));
        printSetup.setFooterMargin(LengthUtil.inch(configuration.getPrintFooterMargin().intValue()));
        RunDirectionEnum sheetDirection = configuration.getSheetDirection();
        if (sheetDirection != null) {
            printSetup.setLeftToRight(sheetDirection == RunDirectionEnum.LTR);
            this.sheet.setRightToLeft(sheetDirection == RunDirectionEnum.RTL);
        }
        if (sheetInfo.sheetFirstPageNumber != null && sheetInfo.sheetFirstPageNumber > 0) {
            printSetup.setPageStart((short)sheetInfo.sheetFirstPageNumber.intValue());
            printSetup.setUsePage(true);
            this.firstPageNotSet = false;
        } else {
            Integer documentFirstPageNumber = configuration.getFirstPageNumber();
            if (documentFirstPageNumber != null && documentFirstPageNumber > 0 && this.firstPageNotSet) {
                printSetup.setPageStart((short)documentFirstPageNumber.intValue());
                printSetup.setUsePage(true);
                this.firstPageNotSet = false;
            }
        }
        if (!(this.firstPageNotSet || this.sheet.getFooter().getCenter() != null && this.sheet.getFooter().getCenter().length() != 0)) {
            this.sheet.getFooter().setCenter("Page " + HeaderFooter.page());
        }
        boolean showGridlines = true;
        if (sheetInfo.sheetShowGridlines == null) {
            Boolean documentShowGridlines = configuration.isShowGridLines();
            if (documentShowGridlines != null) {
                showGridlines = documentShowGridlines;
            }
        } else {
            showGridlines = sheetInfo.sheetShowGridlines;
        }
        this.sheet.setDisplayGridlines(showGridlines);
        this.backgroundMode = Boolean.TRUE.equals(sheetInfo.whitePageBackground) ? FillPatternType.SOLID_FOREGROUND : FillPatternType.NO_FILL;
        this.onePagePerSheetMap.put(this.sheetIndex, configuration.isOnePagePerSheet());
        this.sheetsBeforeCurrentReportMap.put(this.sheetIndex, this.sheetsBeforeCurrentReport);
    }

    @Override
    protected void closeSheet() {
        if (this.sheet == null) {
            return;
        }
        HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
        if (this.isValidScale(this.sheetInfo.sheetPageScale)) {
            printSetup.setScale((short)this.sheetInfo.sheetPageScale.intValue());
        } else {
            Integer fitHeight;
            XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
            Integer fitWidth = configuration.getFitWidth();
            if (fitWidth != null) {
                printSetup.setFitWidth(fitWidth.shortValue());
                this.sheet.setAutobreaks(true);
            }
            Integer n = (fitHeight = configuration.getFitHeight()) == null ? (Boolean.TRUE == configuration.isAutoFitPageHeight() ? Integer.valueOf(this.pageIndex - this.sheetInfo.sheetFirstPageIndex) : null) : (fitHeight = fitHeight);
            if (fitHeight != null) {
                printSetup.setFitHeight(fitHeight.shortValue());
                this.sheet.setAutobreaks(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void closeWorkbook(OutputStream os) throws JRException {
        try {
            void var3_12;
            for (Map.Entry<String, HSSFName> entry : this.anchorNames.entrySet()) {
                String anchorName = entry.getKey();
                HSSFName anchor = entry.getValue();
                List<Hyperlink> linkList = this.anchorLinks.get(anchorName);
                anchor.setRefersToFormula("'" + this.workbook.getSheetName(anchor.getSheetIndex()) + "'!" + anchor.getRefersToFormula());
                if (linkList == null || linkList.isEmpty()) continue;
                for (Hyperlink link : linkList) {
                    link.setAddress(anchor.getRefersToFormula());
                }
            }
            if (!this.definedNamesMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.definedNamesMap.entrySet()) {
                    HSSFName name = this.workbook.createName();
                    JRXlsAbstractExporter.NameScope nameScope = (JRXlsAbstractExporter.NameScope)((Object)entry.getKey());
                    name.setNameName(nameScope.getName());
                    name.setRefersToFormula((String)entry.getValue());
                    int scopeIndex = this.workbook.getSheetIndex(nameScope.getScope());
                    if (nameScope.getScope() == null || "workbook".equalsIgnoreCase(nameScope.getScope()) || scopeIndex < 0) continue;
                    name.setSheetIndex(scopeIndex);
                }
            }
            if (this.formulaCellsMap != null && !this.formulaCellsMap.isEmpty()) {
                for (Map.Entry<String, Object> entry : this.formulaCellsMap.entrySet()) {
                    try {
                        ((HSSFCell)entry.getKey()).setCellFormula((String)entry.getValue());
                    }
                    catch (Exception e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)e.getMessage());
                        }
                        throw new JRException(e);
                    }
                }
            }
            int index = 0;
            for (Map.Entry<Integer, List<Hyperlink>> entry : this.pageLinks.entrySet()) {
                Integer linkPage = entry.getKey();
                List<Hyperlink> linkList = entry.getValue();
                if (linkList == null || linkList.isEmpty()) continue;
                for (Hyperlink link : linkList) {
                    index = this.onePagePerSheetMap.get(linkPage - 1) != null ? (((Boolean)this.onePagePerSheetMap.get(linkPage - 1)).booleanValue() ? Math.max(0, linkPage - 1) : Math.max(0, (Integer)this.sheetsBeforeCurrentReportMap.get(linkPage))) : 0;
                    link.setAddress("'" + this.workbook.getSheetName(index) + "'!$A$1");
                }
            }
            boolean bl = false;
            while (var3_12 < this.workbook.getNumberOfSheets()) {
                HSSFSheet currentSheet = this.workbook.getSheetAt((int)var3_12);
                currentSheet.setForceFormulaRecalculation(true);
                for (String columnName : this.columnNames) {
                    Integer columnWidth = this.columnWidths.get(columnName);
                    Float columnWidthRatio = this.columnWidthRatios.get(columnName);
                    if (columnWidth != null && columnWidth < Integer.MAX_VALUE) {
                        columnWidth = columnWidthRatio != null && columnWidthRatio.floatValue() > 1.0f ? Integer.valueOf(Math.round((float)(43 * columnWidth) * columnWidthRatio.floatValue())) : Integer.valueOf(43 * columnWidth);
                        currentSheet.setColumnWidth(((Integer)this.columnNamesMap.get(columnName)).intValue(), Math.min(columnWidth, 65280));
                        continue;
                    }
                    currentSheet.autoSizeColumn(((Integer)this.columnNamesMap.get(columnName)).intValue(), false);
                }
                ++var3_12;
            }
            this.workbook.write(os);
        }
        catch (IOException e) {
            throw new JRException("export.xls.common.report.generation.error", new Object[]{this.jasperPrint.getName()}, e);
        }
    }

    @Override
    protected void setColumnWidth(int col, int width) {
    }

    protected void setRowHeight(HSSFRow row) {
        Integer rowHeight = (Integer)this.currentRow.get(CURRENT_ROW_HEIGHT);
        if (row != null && rowHeight != null && rowHeight < Integer.MAX_VALUE) {
            row.setHeightInPoints((float)((Integer)this.currentRow.get(CURRENT_ROW_HEIGHT)).intValue());
        }
    }

    protected void adjustRowHeight(int rowHeight, Boolean isAutofit) {
        if (isAutofit != null && isAutofit.booleanValue()) {
            this.currentRow.put(CURRENT_ROW_HEIGHT, Integer.MAX_VALUE);
        } else if (!this.currentRow.containsKey(CURRENT_ROW_HEIGHT) || (Integer)this.currentRow.get(CURRENT_ROW_HEIGHT) < rowHeight) {
            this.currentRow.put(CURRENT_ROW_HEIGHT, rowHeight);
        }
    }

    protected void adjustColumnWidth(String columnName, int columnWidth, Boolean isAutofit) {
        if (isAutofit != null && isAutofit.booleanValue()) {
            this.columnWidths.put(columnName, Integer.MAX_VALUE);
        } else {
            if (!this.columnWidths.containsKey(columnName) || this.columnWidths.get(columnName) < columnWidth) {
                this.columnWidths.put(columnName, columnWidth);
            }
            if (!this.columnWidthRatios.containsKey(columnName) && this.sheetInfo.columnWidthRatio != null) {
                this.columnWidthRatios.put(columnName, this.sheetInfo.columnWidthRatio);
            }
        }
    }

    protected void addBlankCell(HSSFCellStyle cellStyle, Map<String, Object> cellValueMap, String currentColumnName) throws JRException {
        HSSFCellStyle currentStyle = cellStyle != null ? cellStyle : (this.columnStylesMap.get(currentColumnName) != null ? this.columnStylesMap.get(currentColumnName) : this.emptyCellStyle);
        cellValueMap.put(currentColumnName, new CellSettings(currentStyle));
    }

    @Override
    protected void writeCurrentRow(Map<String, Object> currentRow, Map<String, Object> repeatedValues) throws JRException {
        this.row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
        this.setRowHeight(this.row);
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String columnName = (String)this.columnNames.get(i);
            CellSettings cellSettings = (CellSettings)currentRow.get(columnName) == null ? (repeatedValues.get(columnName) != null ? (CellSettings)repeatedValues.get(columnName) : null) : (CellSettings)currentRow.get(columnName);
            this.cell = this.row.createCell(i);
            if (cellSettings == null) continue;
            CellType type = cellSettings.getCellType();
            this.cell.setCellType(type);
            Object cellValue = cellSettings.getCellValue();
            if (cellValue != null) {
                if (cellValue instanceof RichTextString) {
                    this.cell.setCellValue((RichTextString)cellSettings.getCellValue());
                } else if (cellValue instanceof Number) {
                    this.cell.setCellValue(((Number)cellSettings.getCellValue()).doubleValue());
                } else if (cellValue instanceof Date) {
                    this.cell.setCellValue((Date)cellSettings.getCellValue());
                } else if (cellValue instanceof Boolean) {
                    this.cell.setCellValue(((Boolean)cellSettings.getCellValue()).booleanValue());
                } else if (cellValue instanceof ImageSettings) {
                    ImageSettings imageSettings = (ImageSettings)cellValue;
                    try {
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)i, this.rowIndex, (short)(i + 1), this.rowIndex + 1);
                        anchor.setAnchorType(imageSettings.getAnchorType());
                        this.patriarch.createPicture(anchor, imageSettings.getIndex());
                    }
                    catch (Exception ex) {
                        throw new JRException("export.xls.common.cannot.add.cell", null, ex);
                    }
                    catch (Error err) {
                        throw new JRException("export.xls.common.cannot.add.cell", null, err);
                    }
                }
            }
            if (cellSettings.getCellStyle() != null) {
                this.cell.setCellStyle(cellSettings.getCellStyle());
            }
            if (cellSettings.getFormula() != null) {
                this.formulaCellsMap.put(this.cell, cellSettings.getFormula());
            }
            if (cellSettings.getLink() == null) continue;
            this.cell.setHyperlink(cellSettings.getLink());
        }
        ++this.rowIndex;
    }

    @Override
    protected void exportLine(JRPrintLine line) throws JRException {
        String currentColumnName = line.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(line, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.adjustColumnWidth(currentColumnName, line.getWidth(), ((JRXlsExporterNature)this.nature).getColumnAutoFit(line));
            this.adjustRowHeight(line.getHeight(), ((JRXlsExporterNature)this.nature).getRowAutoFit(line));
            short forecolor = this.getWorkbookColor(line.getLinePen().getLineColor()).getIndex();
            int side = 0;
            float ratio = line.getWidth() / line.getHeight();
            side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 0 : 2) : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? 1 : 3);
            BoxStyle boxStyle = new BoxStyle(side, line.getLinePen());
            FillPatternType mode = this.backgroundMode;
            short backcolor = this.whiteIndex;
            if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && line.getBackcolor() != null) {
                mode = FillPatternType.SOLID_FOREGROUND;
                backcolor = this.getWorkbookColor(line.getBackcolor()).getIndex();
            }
            HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), boxStyle, this.isCellLocked(line), this.isCellHidden(line), this.isShrinkToFit(line));
            this.addBlankElement(cellStyle, repeatValue, currentColumnName);
        }
    }

    @Override
    protected void exportRectangle(JRPrintGraphicElement element) throws JRException {
        String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.adjustColumnWidth(currentColumnName, element.getWidth(), ((JRXlsExporterNature)this.nature).getColumnAutoFit(element));
            this.adjustRowHeight(element.getHeight(), ((JRXlsExporterNature)this.nature).getRowAutoFit(element));
            short forecolor = this.getWorkbookColor(element.getLinePen().getLineColor()).getIndex();
            FillPatternType mode = this.backgroundMode;
            short backcolor = this.whiteIndex;
            if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && element.getBackcolor() != null) {
                mode = FillPatternType.SOLID_FOREGROUND;
                backcolor = this.getWorkbookColor(element.getBackcolor()).getIndex();
            }
            HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), new BoxStyle(element), this.isCellLocked(element), this.isCellHidden(element), this.isShrinkToFit(element));
            this.addBlankElement(cellStyle, repeatValue, currentColumnName);
        }
    }

    @Override
    protected void exportText(final JRPrintText textElement) throws JRException {
        String currentColumnName = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            String anchorName;
            String convertedPattern;
            String formula;
            String textStr;
            JRStyledText styledText;
            final boolean hasCurrentColumnData = textElement.getPropertiesMap().containsProperty("net.sf.jasperreports.export.xls.data");
            String currentColumnData = textElement.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.data");
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(textElement, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.adjustColumnWidth(currentColumnName, textElement.getWidth(), ((JRXlsExporterNature)this.nature).getColumnAutoFit(textElement));
            this.adjustRowHeight(textElement.getHeight(), this.isWrapText(textElement) || Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getRowAutoFit(textElement)));
            final short forecolor = this.getWorkbookColor(textElement.getForecolor()).getIndex();
            JRXlsAbstractExporter.TextAlignHolder textAlignHolder = JRXlsMetadataExporter.getTextAlignHolder(textElement);
            HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment(textAlignHolder);
            VerticalAlignment verticalAlignment = this.getVerticalAlignment(textAlignHolder);
            short rotation = this.getRotation(textAlignHolder);
            XlsReportConfiguration configuration = (XlsReportConfiguration)this.getCurrentItemConfiguration();
            FillPatternType mode = this.backgroundMode;
            short backcolor = this.whiteIndex;
            if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && textElement.getBackcolor() != null) {
                mode = FillPatternType.SOLID_FOREGROUND;
                backcolor = this.getWorkbookColor(textElement.getBackcolor()).getIndex();
            }
            final StyleInfo baseStyle = this.isIgnoreTextFormatting(textElement) ? new StyleInfo(mode, this.whiteIndex, horizontalAlignment, verticalAlignment, 0, null, null, this.isWrapText(textElement) || Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getColumnAutoFit(textElement)), this.isCellLocked(textElement), this.isCellHidden(textElement), this.isShrinkToFit(textElement)) : new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, this.getLoadedFont(textElement, forecolor, null, this.getTextLocale(textElement)), new BoxStyle(textElement), this.isWrapText(textElement) || Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getColumnAutoFit(textElement)), this.isCellLocked(textElement), this.isCellHidden(textElement), this.isShrinkToFit(textElement));
            final CellSettings cellSettings = new CellSettings();
            if (hasCurrentColumnData) {
                styledText = new JRStyledText();
                if (currentColumnData != null) {
                    styledText.append(currentColumnData);
                }
                textStr = currentColumnData;
                formula = null;
            } else {
                styledText = this.getStyledText(textElement);
                textStr = styledText != null ? styledText.getText() : null;
                formula = this.getFormula(textElement);
            }
            TextValue value = null;
            String pattern = null;
            if (formula != null || configuration.isDetectCellType().booleanValue()) {
                value = this.getTextValue(textElement, textStr);
                if (value instanceof NumberTextValue) {
                    pattern = ((NumberTextValue)value).getPattern();
                } else if (value instanceof DateTextValue) {
                    pattern = ((DateTextValue)value).getPattern();
                }
            }
            if ((convertedPattern = this.getConvertedPattern(textElement, pattern)) != null) {
                baseStyle.setDataFormat(this.dataFormat.getFormat(convertedPattern));
            }
            if (formula != null) {
                cellSettings.importValues(CellType.FORMULA, this.getLoadedCellStyle(baseStyle), null, formula);
            } else if (configuration.isDetectCellType().booleanValue()) {
                value.handle(new TextValueHandler(){

                    @Override
                    public void handle(StringTextValue textValue) {
                        if ("none".equals(textElement.getMarkup()) || JRXlsMetadataExporter.this.isIgnoreTextFormatting(textElement)) {
                            cellSettings.importValues(CellType.STRING, JRXlsMetadataExporter.this.getLoadedCellStyle(baseStyle), new HSSFRichTextString(textValue.getText()));
                        } else {
                            cellSettings.importValues(CellType.STRING, JRXlsMetadataExporter.this.getLoadedCellStyle(baseStyle), JRXlsMetadataExporter.this.getRichTextString(styledText, forecolor, textElement, JRXlsMetadataExporter.this.getTextLocale(textElement)));
                        }
                    }

                    @Override
                    public void handle(NumberTextValue textValue) {
                        Number value = null;
                        if (hasCurrentColumnData) {
                            if (textStr != null) {
                                try {
                                    value = Double.parseDouble(textStr);
                                }
                                catch (NumberFormatException nfe) {
                                    throw new JRRuntimeException(nfe);
                                }
                            }
                        } else {
                            value = textValue.getValue();
                        }
                        if (value != null && "[h]:mm:ss".equals(convertedPattern)) {
                            value = value.doubleValue() / 86400.0;
                        }
                        cellSettings.importValues(CellType.NUMERIC, JRXlsMetadataExporter.this.getLoadedCellStyle(baseStyle), value);
                    }

                    @Override
                    public void handle(DateTextValue textValue) {
                        Date value = null;
                        if (hasCurrentColumnData) {
                            if (textStr != null) {
                                try {
                                    value = new Date(Long.parseLong(textStr));
                                }
                                catch (NumberFormatException nfe) {
                                    try {
                                        value = JRXlsMetadataExporter.this.isoDateFormat.parse(textStr);
                                    }
                                    catch (ParseException pe) {
                                        throw new JRRuntimeException(pe);
                                    }
                                }
                            }
                        } else {
                            value = textValue.getValue() == null ? null : JRXlsMetadataExporter.this.translateDateValue(textElement, textValue.getValue());
                        }
                        cellSettings.importValues(CellType.NUMERIC, JRXlsMetadataExporter.this.getLoadedCellStyle(baseStyle), value);
                    }

                    @Override
                    public void handle(BooleanTextValue textValue) {
                        Boolean value = hasCurrentColumnData ? Boolean.valueOf(textStr) : textValue.getValue();
                        cellSettings.importValues(CellType.BOOLEAN, JRXlsMetadataExporter.this.getLoadedCellStyle(baseStyle), value);
                    }
                });
            } else if ("none".equals(textElement.getMarkup()) || this.isIgnoreTextFormatting(textElement)) {
                cellSettings.importValues(CellType.STRING, this.getLoadedCellStyle(baseStyle), new HSSFRichTextString(textStr));
            } else {
                cellSettings.importValues(CellType.STRING, this.getLoadedCellStyle(baseStyle), this.getRichTextString(styledText, forecolor, textElement, this.getTextLocale(textElement)));
            }
            if (!configuration.isIgnoreAnchors().booleanValue() && (anchorName = textElement.getAnchorName()) != null) {
                HSSFName aName = this.workbook.createName();
                aName.setNameName(this.toExcelName(anchorName));
                aName.setSheetIndex(this.workbook.getSheetIndex((Sheet)this.sheet));
                CellReference cRef = new CellReference(this.rowIndex, ((Integer)this.columnNamesMap.get(currentColumnName)).intValue(), true, true);
                aName.setRefersToFormula(cRef.formatAsString());
                this.anchorNames.put(anchorName, aName);
            }
            this.setHyperlinkCell(textElement, cellSettings);
            this.addTextElement(cellSettings, textStr, repeatValue, currentColumnName);
        }
    }

    protected void setHyperlinkCell(JRPrintHyperlink hyperlink, CellSettings cellSettings) {
        block17: {
            Hyperlink link;
            block19: {
                JRHyperlinkProducer customHandler;
                block18: {
                    link = null;
                    Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink("net.sf.jasperreports.export.xls.ignore.hyperlink", hyperlink);
                    if (ignoreHyperlink == null) {
                        ignoreHyperlink = ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
                    }
                    if (ignoreHyperlink.booleanValue()) break block17;
                    customHandler = this.getHyperlinkProducer(hyperlink);
                    if (customHandler != null) break block18;
                    switch (hyperlink.getHyperlinkTypeValue()) {
                        case REFERENCE: {
                            String href = hyperlink.getHyperlinkReference();
                            if (href != null) {
                                link = this.createHelper.createHyperlink(HyperlinkType.URL);
                                link.setAddress(href);
                                break;
                            }
                            break block19;
                        }
                        case LOCAL_ANCHOR: {
                            String href;
                            if (!((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreAnchors().booleanValue() && (href = hyperlink.getHyperlinkAnchor()) != null) {
                                link = this.createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                                if (this.anchorLinks.containsKey(href)) {
                                    this.anchorLinks.get(href).add(link);
                                    break;
                                }
                                ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                                hrefList.add(link);
                                this.anchorLinks.put(href, hrefList);
                                break;
                            }
                            break block19;
                        }
                        case LOCAL_PAGE: {
                            Integer hrefPage = ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isOnePagePerSheet() != false ? hyperlink.getHyperlinkPage() : 0;
                            if (hrefPage != null) {
                                link = this.createHelper.createHyperlink(HyperlinkType.DOCUMENT);
                                if (this.pageLinks.containsKey(this.sheetsBeforeCurrentReport + hrefPage)) {
                                    this.pageLinks.get(this.sheetsBeforeCurrentReport + hrefPage).add(link);
                                    break;
                                }
                                ArrayList<Hyperlink> hrefList = new ArrayList<Hyperlink>();
                                hrefList.add(link);
                                this.pageLinks.put(this.sheetsBeforeCurrentReport + hrefPage, hrefList);
                                break;
                            }
                            break block19;
                        }
                        case REMOTE_ANCHOR: {
                            String href = hyperlink.getHyperlinkReference();
                            if (href != null && hyperlink.getHyperlinkAnchor() != null) {
                                href = href + "#" + hyperlink.getHyperlinkAnchor();
                                link = this.createHelper.createHyperlink(HyperlinkType.FILE);
                                link.setAddress(href);
                                break;
                            }
                            break block19;
                        }
                        case REMOTE_PAGE: {
                            String href = hyperlink.getHyperlinkReference();
                            if (href != null && hyperlink.getHyperlinkPage() != null) {
                                href = href + "#JR_PAGE_ANCHOR_0_" + hyperlink.getHyperlinkPage().toString();
                                link = this.createHelper.createHyperlink(HyperlinkType.FILE);
                                link.setAddress(href);
                                break;
                            }
                            break block19;
                        }
                    }
                    break block19;
                }
                String href = customHandler.getHyperlink(hyperlink);
                if (href != null) {
                    link = this.createHelper.createHyperlink(HyperlinkType.URL);
                    link.setAddress(href);
                }
            }
            if (link != null) {
                cellSettings.setLink(link);
            }
        }
    }

    protected void addTextElement(CellSettings cellSettings, String textStr, boolean repeatValue, String currentColumnName) throws JRException {
        if (this.columnNames.size() > 0) {
            if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && this.isColumnReadOnTime(this.currentRow, currentColumnName)) {
                this.addCell(cellSettings, this.currentRow, currentColumnName);
            } else if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && !this.isColumnReadOnTime(this.currentRow, currentColumnName) || this.columnNames.contains(currentColumnName) && this.currentRow.containsKey(currentColumnName)) {
                if (this.rowIndex == 1 && ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isWriteHeader().booleanValue()) {
                    this.writeReportHeader();
                }
                this.writeCurrentRow(this.currentRow, this.repeatedValues);
                this.currentRow.clear();
                this.addCell(cellSettings, this.currentRow, currentColumnName);
            }
            if (repeatValue) {
                if (currentColumnName != null && currentColumnName.length() > 0 && textStr.length() > 0) {
                    this.addCell(cellSettings, this.repeatedValues, currentColumnName);
                }
            } else {
                this.repeatedValues.remove(currentColumnName);
            }
        }
    }

    protected void addBlankElement(HSSFCellStyle cellStyle, boolean repeatValue, String currentColumnName) throws JRException {
        if (this.columnNames.size() > 0) {
            if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && this.isColumnReadOnTime(this.currentRow, currentColumnName)) {
                this.addBlankCell(cellStyle, this.currentRow, currentColumnName);
            } else if (this.columnNames.contains(currentColumnName) && !this.currentRow.containsKey(currentColumnName) && !this.isColumnReadOnTime(this.currentRow, currentColumnName) || this.columnNames.contains(currentColumnName) && this.currentRow.containsKey(currentColumnName)) {
                if (this.rowIndex == 1 && ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isWriteHeader().booleanValue()) {
                    this.writeReportHeader();
                }
                this.writeCurrentRow(this.currentRow, this.repeatedValues);
                this.currentRow.clear();
                this.addBlankCell(cellStyle, this.currentRow, currentColumnName);
            }
            if (repeatValue) {
                if (repeatValue && currentColumnName != null && currentColumnName.length() > 0 && cellStyle != null) {
                    this.addBlankCell(cellStyle, this.repeatedValues, currentColumnName);
                }
            } else {
                this.repeatedValues.remove(currentColumnName);
            }
        }
    }

    protected void addCell(CellSettings cellSettings, Map<String, Object> cellValueMap, String currentColumnName) throws JRException {
        cellValueMap.put(currentColumnName, cellSettings);
    }

    protected HSSFRichTextString getRichTextString(JRStyledText styledText, short forecolor, JRFont defaultFont, Locale locale) {
        styledText = JRStyledTextUtil.getBulletedStyledText(styledText);
        String text = styledText.getText();
        HSSFRichTextString richTextStr = new HSSFRichTextString(text);
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            JRFont runFont = attributes.isEmpty() ? defaultFont : new JRBaseFont(attributes);
            short runForecolor = attributes.get(TextAttribute.FOREGROUND) != null ? this.getWorkbookColor((Color)attributes.get(TextAttribute.FOREGROUND)).getIndex() : forecolor;
            HSSFFont font = this.getLoadedFont(runFont, runForecolor, attributes, locale);
            richTextStr.applyFont(iterator.getIndex(), runLimit, (Font)font);
            iterator.setIndex(runLimit);
        }
        return richTextStr;
    }

    @Override
    public void exportImage(JRPrintImage element) throws JRException {
        String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.repeat.value", false);
            this.setColumnName(currentColumnName);
            this.adjustColumnWidth(currentColumnName, element.getWidth(), ((JRXlsExporterNature)this.nature).getColumnAutoFit(element));
            this.adjustRowHeight(element.getHeight(), Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getRowAutoFit(element)));
            int topPadding = Math.max(element.getLineBox().getTopPadding(), this.getImageBorderCorrection(element.getLineBox().getTopPen()));
            int leftPadding = Math.max(element.getLineBox().getLeftPadding(), this.getImageBorderCorrection(element.getLineBox().getLeftPen()));
            int bottomPadding = Math.max(element.getLineBox().getBottomPadding(), this.getImageBorderCorrection(element.getLineBox().getBottomPen()));
            int rightPadding = Math.max(element.getLineBox().getRightPadding(), this.getImageBorderCorrection(element.getLineBox().getRightPen()));
            int tmpAvailableImageWidth = element.getWidth() - leftPadding - rightPadding;
            int availableImageWidth = tmpAvailableImageWidth < 0 ? 0 : tmpAvailableImageWidth;
            int tmpAvailableImageHeight = element.getHeight() - topPadding - bottomPadding;
            int availableImageHeight = tmpAvailableImageHeight < 0 ? 0 : tmpAvailableImageHeight;
            InternalImageProcessor imageProcessor = new InternalImageProcessor(element, availableImageWidth, availableImageHeight);
            Renderable renderer = element.getRenderer();
            if (renderer != null && imageProcessor.availableImageWidth > 0 && imageProcessor.availableImageHeight > 0) {
                InternalImageProcessorResult imageProcessorResult;
                block13: {
                    imageProcessorResult = null;
                    try {
                        imageProcessorResult = imageProcessor.process(renderer);
                    }
                    catch (Exception e) {
                        Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, element.getOnErrorTypeValue());
                        if (onErrorRenderer == null) break block13;
                        imageProcessorResult = imageProcessor.process(onErrorRenderer);
                    }
                }
                if (imageProcessorResult != null) {
                    XlsMetadataReportConfiguration configuration = (XlsMetadataReportConfiguration)this.getCurrentItemConfiguration();
                    FillPatternType mode = this.backgroundMode;
                    short backcolor = this.whiteIndex;
                    if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBackground) && element.getBackcolor() != null) {
                        mode = FillPatternType.SOLID_FOREGROUND;
                        backcolor = this.getWorkbookColor(element.getBackcolor()).getIndex();
                    }
                    short forecolor = this.getWorkbookColor(element.getLineBox().getPen().getLineColor()).getIndex();
                    if (element.getModeValue() == ModeEnum.OPAQUE) {
                        backcolor = this.getWorkbookColor(element.getBackcolor()).getIndex();
                    }
                    HSSFCellStyle cellStyle = this.getLoadedCellStyle(mode, backcolor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, (short)0, this.getLoadedFont(this.getDefaultFont(), forecolor, null, this.getLocale()), new BoxStyle(element), this.isCellLocked(element), this.isCellHidden(element), this.isShrinkToFit(element));
                    this.addBlankElement(cellStyle, false, currentColumnName);
                    int colIndex = (Integer)this.columnNamesMap.get(currentColumnName);
                    try {
                        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)colIndex, this.rowIndex, (short)(colIndex + 1), this.rowIndex + 1);
                        ImageAnchorTypeEnum imageAnchorType = ImageAnchorTypeEnum.getByName(JRPropertiesUtil.getOwnProperty(element, "net.sf.jasperreports.export.xls.image.anchor.type"));
                        if (imageAnchorType == null && (imageAnchorType = configuration.getImageAnchorType()) == null) {
                            imageAnchorType = ImageAnchorTypeEnum.MOVE_NO_SIZE;
                        }
                        anchor.setAnchorType(JRXlsExporter.getAnchorType(imageAnchorType));
                        int imgIndex = this.workbook.addPicture(imageProcessorResult.imageData, 6);
                        this.patriarch.createPicture(anchor, imgIndex).setRotationDegree(imageProcessorResult.angle);
                        if (repeatValue) {
                            CellSettings cellSettings = new CellSettings(cellStyle);
                            cellSettings.setCellValue(new ImageSettings(imgIndex, anchor.getAnchorType()));
                            this.addCell(cellSettings, this.repeatedValues, currentColumnName);
                        } else {
                            this.repeatedValues.remove(currentColumnName);
                        }
                    }
                    catch (Exception ex) {
                        throw new JRException("export.xls.common.cannot.add.cell", null, ex);
                    }
                    catch (Error err) {
                        throw new JRException("export.xls.common.cannot.add.cell", null, err);
                    }
                }
            }
        }
    }

    protected HSSFCellStyle getLoadedCellStyle(StyleInfo style) {
        HSSFCellStyle cellStyle = this.loadedCellStyles.get(style);
        if (cellStyle == null) {
            cellStyle = this.workbook.createCellStyle();
            cellStyle.setFillForegroundColor(style.backcolor);
            cellStyle.setFillPattern(style.mode);
            cellStyle.setAlignment(style.horizontalAlignment);
            cellStyle.setVerticalAlignment(style.verticalAlignment);
            cellStyle.setRotation(style.rotation);
            if (style.font != null) {
                cellStyle.setFont(style.font);
            }
            cellStyle.setWrapText(style.lcWrapText);
            cellStyle.setLocked(style.lcCellLocked);
            cellStyle.setHidden(style.lcCellHidden);
            cellStyle.setShrinkToFit(style.lcShrinkToFit);
            if (style.hasDataFormat()) {
                cellStyle.setDataFormat(style.getDataFormat());
            }
            if (!Boolean.TRUE.equals(this.sheetInfo.ignoreCellBorder) && style.box != null) {
                BoxStyle box = style.box;
                if (box.borderStyle[0] != null) {
                    cellStyle.setBorderTop(box.borderStyle[0]);
                }
                cellStyle.setTopBorderColor(box.borderColour[0]);
                if (box.borderStyle[1] != null) {
                    cellStyle.setBorderLeft(box.borderStyle[1]);
                }
                cellStyle.setLeftBorderColor(box.borderColour[1]);
                if (box.borderStyle[2] != null) {
                    cellStyle.setBorderBottom(box.borderStyle[2]);
                }
                cellStyle.setBottomBorderColor(box.borderColour[2]);
                if (box.borderStyle[3] != null) {
                    cellStyle.setBorderRight(box.borderStyle[3]);
                }
                cellStyle.setRightBorderColor(box.borderColour[3]);
            }
            this.loadedCellStyles.put(style, cellStyle);
        }
        return cellStyle;
    }

    protected HSSFCellStyle getLoadedCellStyle(FillPatternType mode, short backcolor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean isCellLocked, boolean isCellHidden, boolean isShrinkToFit) {
        return this.getLoadedCellStyle(new StyleInfo(mode, backcolor, horizontalAlignment, verticalAlignment, rotation, font, box, true, isCellLocked, isCellHidden, isShrinkToFit));
    }

    protected static BorderStyle getBorderStyle(JRPen pen) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            switch (pen.getLineStyleValue()) {
                case DOUBLE: {
                    return BorderStyle.DOUBLE;
                }
                case DOTTED: {
                    return BorderStyle.DOTTED;
                }
                case DASHED: {
                    if (lineWidth >= 1.0f) {
                        return BorderStyle.MEDIUM_DASHED;
                    }
                    return BorderStyle.DASHED;
                }
            }
            if (lineWidth >= 2.0f) {
                return BorderStyle.THICK;
            }
            if (lineWidth >= 1.0f) {
                return BorderStyle.MEDIUM;
            }
            if (lineWidth >= 0.5f) {
                return BorderStyle.THIN;
            }
            return BorderStyle.HAIR;
        }
        return BorderStyle.NONE;
    }

    @Override
    protected void exportFrame(JRPrintFrame frame) throws JRException {
        for (JRPrintElement element : frame.getElements()) {
            if (element instanceof JRPrintLine) {
                this.exportLine((JRPrintLine)element);
                continue;
            }
            if (element instanceof JRPrintRectangle) {
                this.exportRectangle((JRPrintRectangle)element);
                continue;
            }
            if (element instanceof JRPrintEllipse) {
                this.exportRectangle((JRPrintEllipse)element);
                continue;
            }
            if (element instanceof JRPrintImage) {
                this.exportImage((JRPrintImage)element);
                continue;
            }
            if (element instanceof JRPrintText) {
                this.exportText((JRPrintText)element);
                continue;
            }
            if (element instanceof JRPrintFrame) {
                this.exportFrame((JRPrintFrame)element);
                continue;
            }
            if (!(element instanceof JRGenericPrintElement)) continue;
            this.exportGenericElement((JRGenericPrintElement)element);
        }
    }

    @Override
    protected void exportGenericElement(JRGenericPrintElement element) throws JRException {
        String currentColumnName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.xls.column.name");
        if (currentColumnName != null && currentColumnName.length() > 0) {
            boolean repeatValue = this.getPropertiesUtil().getBooleanProperty(element, "net.sf.jasperreports.export.xls.repeat.value", false);
            int colIndex = (Integer)this.columnNamesMap.get(currentColumnName);
            this.setColumnName(currentColumnName);
            this.adjustColumnWidth(currentColumnName, element.getWidth(), ((JRXlsExporterNature)this.nature).getColumnAutoFit(element));
            this.adjustRowHeight(element.getHeight(), Boolean.TRUE.equals(((JRXlsExporterNature)this.nature).getRowAutoFit(element)));
            GenericElementXlsMetadataHandler handler = (GenericElementXlsMetadataHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), XLS_EXPORTER_KEY);
            if (handler != null) {
                this.rowIndex = handler.exportElement((JRXlsExporterContext)this.exporterContext, element, this.currentRow, this.repeatedValues, this.columnNames, this.columnNamesMap, currentColumnName, colIndex, this.rowIndex, repeatValue);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No XLS Metadata generic element handler for " + element.getGenericType()));
            }
        }
    }

    @Override
    protected ExporterNature getNature() {
        return this.nature;
    }

    @Override
    public String getExporterKey() {
        return XLS_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return "net.sf.jasperreports.export.xls.";
    }

    protected void setColumnName(String currentColumnName) {
        if (!this.hasDefinedColumns && currentColumnName != null && currentColumnName.length() > 0 && !this.columnNames.contains(currentColumnName)) {
            this.columnNamesMap.put(currentColumnName, this.columnNames.size());
            this.columnNames.add(currentColumnName);
        }
    }

    @Override
    protected void writeReportHeader() throws JRException {
        this.row = this.sheet.createRow(0);
        for (int i = 0; i < this.columnNames.size(); ++i) {
            String columnName = (String)this.columnNames.get(i);
            this.cell = this.row.createCell(i);
            this.cell.setCellType(CellType.STRING);
            this.cell.setCellValue((RichTextString)new HSSFRichTextString(columnName));
        }
    }

    @Override
    protected void setSheetName(String sheetName) {
        this.workbook.setSheetName(this.workbook.getSheetIndex((Sheet)this.sheet), sheetName);
    }

    @Override
    protected void setFreezePane(int rowIndex, int colIndex) {
        if (rowIndex > 0 || colIndex > 0) {
            this.sheet.createFreezePane(Math.max(0, colIndex), Math.max(0, rowIndex));
        }
    }

    @Override
    protected void setAutoFilter(String autoFilterRange) {
    }

    @Override
    protected void setRowLevels(XlsRowLevelInfo levelInfo, String level) {
    }

    private final short getSuitablePaperSize() {
        if (this.pageFormat == null) {
            return -1;
        }
        long width = 0L;
        long height = 0L;
        int ps = -1;
        if (this.pageFormat.getPageWidth() != 0 && this.pageFormat.getPageHeight() != 0) {
            double dWidth = (double)this.pageFormat.getPageWidth().intValue() / 72.0;
            double dHeight = (double)this.pageFormat.getPageHeight().intValue() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            for (int i = 4; i < 6; ++i) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if (((long)w != width || (long)h != height) && ((long)h != width || (long)w != height)) continue;
                if (i == 4) {
                    ps = 9;
                    break;
                }
                if (i != 5) break;
                ps = 11;
                break;
            }
            if (ps == -1 && (width == 110L && height == 220L || width == 220L && height == 110L)) {
                ps = 27;
            }
            if (ps == -1) {
                if (width == 216L && height == 279L || width == 279L && height == 216L) {
                    ps = 1;
                }
                if (width == 216L && height == 356L || width == 356L && height == 216L) {
                    ps = 5;
                } else if (width == 190L && height == 254L || width == 254L && height == 190L) {
                    ps = 7;
                }
            }
        }
        return (short)ps;
    }

    private HorizontalAlignment getHorizontalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.horizontalAlignment) {
            case RIGHT: {
                return HorizontalAlignment.RIGHT;
            }
            case CENTER: {
                return HorizontalAlignment.CENTER;
            }
            case JUSTIFIED: {
                return HorizontalAlignment.JUSTIFY;
            }
        }
        return HorizontalAlignment.LEFT;
    }

    private VerticalAlignment getVerticalAlignment(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.verticalAlignment) {
            case BOTTOM: {
                return VerticalAlignment.BOTTOM;
            }
            case MIDDLE: {
                return VerticalAlignment.CENTER;
            }
            case JUSTIFIED: {
                return VerticalAlignment.JUSTIFY;
            }
        }
        return VerticalAlignment.TOP;
    }

    private short getRotation(JRXlsAbstractExporter.TextAlignHolder alignment) {
        switch (alignment.rotation) {
            case LEFT: {
                return 90;
            }
            case RIGHT: {
                return -90;
            }
        }
        return 0;
    }

    protected HSSFColor getWorkbookColor(Color awtColor) {
        HSSFColor color = null;
        if (awtColor != null) {
            byte red = (byte)awtColor.getRed();
            byte green = (byte)awtColor.getGreen();
            byte blue = (byte)awtColor.getBlue();
            XlsExporterConfiguration configuration = (XlsExporterConfiguration)this.getCurrentConfiguration();
            if (configuration.isCreateCustomPalette().booleanValue()) {
                try {
                    color = this.palette.findColor(red, green, blue) != null ? this.palette.findColor(red, green, blue) : this.palette.addColor(red, green, blue);
                }
                catch (Exception e) {
                    if (this.customColorIndex < MAX_COLOR_INDEX) {
                        this.palette.setColorAtIndex(this.customColorIndex, red, green, blue);
                        short s = this.customColorIndex;
                        this.customColorIndex = (short)(s + 1);
                        color = this.palette.getColor(s);
                    }
                    color = this.palette.findSimilarColor(red, green, blue);
                }
            }
        }
        return color == null ? JRXlsMetadataExporter.getNearestColor(awtColor) : color;
    }

    protected static HSSFColor getNearestColor(Color awtColor) {
        HSSFColor color = hssfColorsCache.get(awtColor);
        if (color == null) {
            Set keys;
            Map triplets = HSSFColor.getTripletHash();
            if (triplets != null && (keys = triplets.keySet()) != null && keys.size() > 0) {
                Object key2 = null;
                HSSFColor crtColor = null;
                short[] rgb = null;
                int diff = 0;
                int minDiff = 999;
                for (Object key2 : keys) {
                    crtColor = (HSSFColor)triplets.get(key2);
                    rgb = crtColor.getTriplet();
                    diff = Math.abs(rgb[0] - awtColor.getRed()) + Math.abs(rgb[1] - awtColor.getGreen()) + Math.abs(rgb[2] - awtColor.getBlue());
                    if (diff >= minDiff) continue;
                    minDiff = diff;
                    color = crtColor;
                }
            }
            hssfColorsCache.put(awtColor, color);
        }
        return color;
    }

    protected HSSFFont getLoadedFont(JRFont font, short forecolor, Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        HSSFFont cellFont = null;
        String fontName = this.fontUtil.getExportFontFamily(font.getFontName(), locale, this.getExporterKey());
        boolean isFontSizeFixEnabled = ((XlsMetadataReportConfiguration)this.getCurrentItemConfiguration()).isFontSizeFixEnabled();
        short superscriptType = 0;
        if (attributes != null && attributes.get(TextAttribute.SUPERSCRIPT) != null) {
            Object value = attributes.get(TextAttribute.SUPERSCRIPT);
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(value)) {
                superscriptType = 1;
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
                superscriptType = 2;
            }
        }
        for (int i = 0; i < this.loadedFonts.size(); ++i) {
            HSSFFont cf = (HSSFFont)this.loadedFonts.get(i);
            short fontSize = (short)font.getFontsize();
            if (isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            if (!cf.getFontName().equals(fontName) || cf.getColor() != forecolor || cf.getFontHeightInPoints() != fontSize || !(cf.getUnderline() == 1 ? font.isUnderline() : !font.isUnderline()) || cf.getStrikeout() != font.isStrikeThrough() || cf.getBold() != font.isBold() || cf.getItalic() != font.isItalic() || cf.getTypeOffset() != superscriptType) continue;
            cellFont = cf;
            break;
        }
        if (cellFont == null) {
            cellFont = this.workbook.createFont();
            cellFont.setFontName(fontName);
            cellFont.setColor(forecolor);
            short fontSize = (short)font.getFontsize();
            if (isFontSizeFixEnabled) {
                fontSize = (short)(fontSize - 1);
            }
            cellFont.setFontHeightInPoints(fontSize);
            if (font.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (font.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (font.isBold()) {
                cellFont.setBold(true);
            }
            if (font.isItalic()) {
                cellFont.setItalic(true);
            }
            cellFont.setTypeOffset(superscriptType);
            this.loadedFonts.add(cellFont);
        }
        return cellFont;
    }

    @Override
    protected void createSheet(CutsInfo xCuts, JRXlsAbstractExporter.SheetInfo sheetInfo) {
    }

    @Override
    protected void setRowHeight(int rowIndex, int lastRowHeight, Cut yCut, XlsRowLevelInfo levelInfo) throws JRException {
    }

    @Override
    protected void addRowBreak(int rowIndex) {
        this.sheet.setRowBreak(rowIndex);
    }

    @Override
    protected void setColumnWidth(int col, int width, boolean autoFit) {
    }

    @Override
    protected void updateSheet(JRPrintElement element) {
        String sheetFooterRight;
        String sheetFooterCenter;
        String sheetHeaderRight;
        String sheetHeaderCenter;
        JRXlsMetadataExporterNature xlsNature = (JRXlsMetadataExporterNature)this.nature;
        this.configureDefinedNames(xlsNature, element);
        this.updatePageMargin(xlsNature.getPrintPageTopMargin(element), (short)2);
        this.updatePageMargin(xlsNature.getPrintPageLeftMargin(element), (short)0);
        this.updatePageMargin(xlsNature.getPrintPageBottomMargin(element), (short)3);
        this.updatePageMargin(xlsNature.getPrintPageRightMargin(element), (short)1);
        this.updateHeaderFooterMargin(xlsNature.getPrintHeaderMargin(element), true);
        this.updateHeaderFooterMargin(xlsNature.getPrintFooterMargin(element), false);
        HSSFHeader header = this.sheet.getHeader();
        String sheetHeaderLeft = xlsNature.getSheetHeaderLeft(element);
        if (sheetHeaderLeft != null) {
            header.setLeft(sheetHeaderLeft);
        }
        if ((sheetHeaderCenter = xlsNature.getSheetHeaderCenter(element)) != null) {
            header.setCenter(sheetHeaderCenter);
        }
        if ((sheetHeaderRight = xlsNature.getSheetHeaderRight(element)) != null) {
            header.setRight(sheetHeaderRight);
        }
        HSSFFooter footer = this.sheet.getFooter();
        String sheetFooterLeft = xlsNature.getSheetFooterLeft(element);
        if (sheetFooterLeft != null) {
            footer.setLeft(sheetFooterLeft);
        }
        if ((sheetFooterCenter = xlsNature.getSheetFooterCenter(element)) != null) {
            footer.setCenter(sheetFooterCenter);
        }
        if ((sheetFooterRight = xlsNature.getSheetFooterRight(element)) != null) {
            footer.setRight(sheetFooterRight);
        }
    }

    private void updatePageMargin(Integer marginValue, short marginType) {
        double margin;
        if (marginValue != null && (margin = LengthUtil.inch(marginValue.intValue())) > this.sheet.getMargin(marginType)) {
            this.sheet.setMargin(marginType, margin);
        }
    }

    private void updateHeaderFooterMargin(Integer marginValue, boolean isHeaderMargin) {
        if (marginValue != null) {
            HSSFPrintSetup printSetup = this.sheet.getPrintSetup();
            double margin = LengthUtil.inch(marginValue.intValue());
            if (isHeaderMargin) {
                if (margin > printSetup.getHeaderMargin()) {
                    printSetup.setHeaderMargin(margin);
                }
            } else if (margin > printSetup.getFooterMargin()) {
                printSetup.setFooterMargin(margin);
            }
        }
    }

    protected class CellSettings {
        private CellType cellType;
        private HSSFCellStyle cellStyle;
        private Object cellValue;
        private String formula;
        private Hyperlink link;

        public CellSettings() {
        }

        public CellSettings(HSSFCellStyle cellStyle) {
            this(CellType.BLANK, cellStyle, null);
        }

        public CellSettings(CellType cellType, HSSFCellStyle cellStyle, Object cellValue) {
            this(cellType, cellStyle, cellValue, null);
        }

        public CellSettings(CellType cellType, HSSFCellStyle cellStyle, Object cellValue, String formula) {
            this(cellType, cellStyle, cellValue, formula, null);
        }

        public CellSettings(CellType cellType, HSSFCellStyle cellStyle, Object cellValue, String formula, Hyperlink link) {
            this.cellType = cellType;
            this.cellStyle = cellStyle;
            this.cellValue = cellValue;
            this.formula = formula;
            this.link = link;
        }

        public HSSFCellStyle getCellStyle() {
            return this.cellStyle;
        }

        public void setCellStyle(HSSFCellStyle cellStyle) {
            this.cellStyle = cellStyle;
        }

        public CellType getCellType() {
            return this.cellType;
        }

        public void setCellType(CellType cellType) {
            this.cellType = cellType;
        }

        public Object getCellValue() {
            return this.cellValue;
        }

        public void setCellValue(Object cellValue) {
            this.cellValue = cellValue;
        }

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            this.formula = formula;
        }

        public Hyperlink getLink() {
            return this.link;
        }

        public void setLink(Hyperlink link) {
            this.link = link;
        }

        public void importValues(CellType cellType, HSSFCellStyle cellStyle, Object cellValue) {
            this.importValues(cellType, cellStyle, cellValue, null);
        }

        public void importValues(CellType cellType, HSSFCellStyle cellStyle, Object cellValue, String formula) {
            this.importValues(cellType, cellStyle, cellValue, formula, null);
        }

        public void importValues(CellType cellType, HSSFCellStyle cellStyle, Object cellValue, String formula, Hyperlink link) {
            if (!CellType.FORMULA.equals((Object)cellType)) {
                this.cellType = cellType;
            }
            this.cellStyle = cellStyle;
            this.cellValue = cellValue;
            this.formula = formula;
            this.link = link;
        }
    }

    protected class StyleInfo {
        protected final FillPatternType mode;
        protected final short backcolor;
        protected final HorizontalAlignment horizontalAlignment;
        protected final VerticalAlignment verticalAlignment;
        protected final short rotation;
        protected final HSSFFont font;
        protected final BoxStyle box;
        protected final boolean lcWrapText;
        protected final boolean lcCellLocked;
        protected final boolean lcCellHidden;
        protected final boolean lcShrinkToFit;
        private short lcDataFormat = (short)-1;
        private int hashCode;

        public StyleInfo(FillPatternType mode, short backcolor, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, short rotation, HSSFFont font, BoxStyle box, boolean wrapText, boolean cellLocked, boolean cellHidden, boolean shrinkToFit) {
            this.mode = mode;
            this.backcolor = backcolor;
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.rotation = rotation;
            this.font = font;
            this.box = box;
            this.lcWrapText = shrinkToFit ? false : wrapText;
            this.lcCellLocked = cellLocked;
            this.lcCellHidden = cellHidden;
            this.lcShrinkToFit = shrinkToFit;
            this.hashCode = this.computeHash();
        }

        protected int computeHash() {
            int hash = this.mode.hashCode();
            hash = 31 * hash + this.backcolor;
            hash = 31 * hash + this.horizontalAlignment.hashCode();
            hash = 31 * hash + this.verticalAlignment.hashCode();
            hash = 31 * hash + this.rotation;
            hash = 31 * hash + (this.font == null ? 0 : this.font.getIndexAsInt());
            hash = 31 * hash + (this.box == null ? 0 : this.box.hashCode());
            hash = 31 * hash + this.lcDataFormat;
            hash = 31 * hash + (this.lcWrapText ? 0 : 1);
            hash = 31 * hash + (this.lcCellLocked ? 0 : 1);
            hash = 31 * hash + (this.lcCellHidden ? 0 : 1);
            hash = 31 * hash + (this.lcShrinkToFit ? 0 : 1);
            return hash;
        }

        public void setDataFormat(short dataFormat) {
            this.lcDataFormat = dataFormat;
            this.hashCode = this.computeHash();
        }

        public boolean hasDataFormat() {
            return this.lcDataFormat != -1;
        }

        public short getDataFormat() {
            return this.lcDataFormat;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            StyleInfo s = (StyleInfo)o;
            return s.mode == this.mode && s.backcolor == this.backcolor && s.horizontalAlignment == this.horizontalAlignment && s.verticalAlignment == this.verticalAlignment && s.rotation == this.rotation && (s.font == null ? this.font == null : this.font != null && s.font.getIndexAsInt() == this.font.getIndexAsInt()) && (s.box == null ? this.box == null : this.box != null && s.box.equals(this.box)) && s.rotation == this.rotation && s.lcWrapText == this.lcWrapText && s.lcCellLocked == this.lcCellLocked && s.lcCellHidden == this.lcCellHidden && s.lcShrinkToFit == this.lcShrinkToFit;
        }

        public String toString() {
            return "(" + this.mode + "," + this.backcolor + "," + this.horizontalAlignment + "," + this.verticalAlignment + "," + this.rotation + "," + this.font + "," + this.box + "," + this.lcDataFormat + "," + this.lcWrapText + "," + this.lcCellLocked + "," + this.lcCellHidden + "," + this.lcShrinkToFit + ")";
        }
    }

    protected class BoxStyle {
        protected static final int TOP = 0;
        protected static final int LEFT = 1;
        protected static final int BOTTOM = 2;
        protected static final int RIGHT = 3;
        protected BorderStyle[] borderStyle = new BorderStyle[]{BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE, BorderStyle.NONE};
        protected short[] borderColour = new short[4];
        private int hash;

        public BoxStyle(int side, JRPen pen) {
            this.borderStyle[side] = JRXlsMetadataExporter.getBorderStyle(pen);
            this.borderColour[side] = JRXlsMetadataExporter.this.getWorkbookColor(pen.getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public BoxStyle(JRPrintElement element) {
            if (element != null) {
                if (element instanceof JRBoxContainer) {
                    this.setBox(((JRBoxContainer)((Object)element)).getLineBox());
                }
                if (element instanceof JRCommonGraphicElement) {
                    this.setPen(((JRCommonGraphicElement)((Object)element)).getLinePen());
                }
            }
        }

        public void setBox(JRLineBox box) {
            this.borderStyle[0] = JRXlsMetadataExporter.getBorderStyle(box.getTopPen());
            this.borderColour[0] = JRXlsMetadataExporter.this.getWorkbookColor(box.getTopPen().getLineColor()).getIndex();
            this.borderStyle[2] = JRXlsMetadataExporter.getBorderStyle(box.getBottomPen());
            this.borderColour[2] = JRXlsMetadataExporter.this.getWorkbookColor(box.getBottomPen().getLineColor()).getIndex();
            this.borderStyle[1] = JRXlsMetadataExporter.getBorderStyle(box.getLeftPen());
            this.borderColour[1] = JRXlsMetadataExporter.this.getWorkbookColor(box.getLeftPen().getLineColor()).getIndex();
            this.borderStyle[3] = JRXlsMetadataExporter.getBorderStyle(box.getRightPen());
            this.borderColour[3] = JRXlsMetadataExporter.this.getWorkbookColor(box.getRightPen().getLineColor()).getIndex();
            this.hash = this.computeHash();
        }

        public void setPen(JRPen pen) {
            if (this.borderStyle[0] == BorderStyle.NONE && this.borderStyle[1] == BorderStyle.NONE && this.borderStyle[2] == BorderStyle.NONE && this.borderStyle[3] == BorderStyle.NONE) {
                BorderStyle style = JRXlsMetadataExporter.getBorderStyle(pen);
                short colour = JRXlsMetadataExporter.this.getWorkbookColor(pen.getLineColor()).getIndex();
                this.borderStyle[0] = style;
                this.borderStyle[2] = style;
                this.borderStyle[1] = style;
                this.borderStyle[3] = style;
                this.borderColour[0] = colour;
                this.borderColour[2] = colour;
                this.borderColour[1] = colour;
                this.borderColour[3] = colour;
            }
            this.hash = this.computeHash();
        }

        private int computeHash() {
            int hashCode = this.borderStyle[0] == null ? 0 : this.borderStyle[0].hashCode();
            hashCode = 31 * hashCode + this.borderColour[0];
            hashCode = 31 * hashCode + (this.borderStyle[2] == null ? 0 : this.borderStyle[2].hashCode());
            hashCode = 31 * hashCode + this.borderColour[2];
            hashCode = 31 * hashCode + (this.borderStyle[1] == null ? 0 : this.borderStyle[1].hashCode());
            hashCode = 31 * hashCode + this.borderColour[1];
            hashCode = 31 * hashCode + (this.borderStyle[3] == null ? 0 : this.borderStyle[3].hashCode());
            hashCode = 31 * hashCode + this.borderColour[3];
            return hashCode;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            BoxStyle b = (BoxStyle)o;
            return b.borderStyle[0] == this.borderStyle[0] && b.borderColour[0] == this.borderColour[0] && b.borderStyle[2] == this.borderStyle[2] && b.borderColour[2] == this.borderColour[2] && b.borderStyle[1] == this.borderStyle[1] && b.borderColour[1] == this.borderColour[1] && b.borderStyle[3] == this.borderStyle[3] && b.borderColour[3] == this.borderColour[3];
        }

        public String toString() {
            return "(" + this.borderStyle[0] + "/" + this.borderColour[0] + "," + this.borderStyle[2] + "/" + this.borderColour[2] + "," + this.borderStyle[1] + "/" + this.borderColour[1] + "," + this.borderStyle[3] + "/" + this.borderColour[3] + ")";
        }
    }

    private class InternalImageProcessorResult {
        private final byte[] imageData;
        private final short angle;

        protected InternalImageProcessorResult(byte[] imageData, int topOffset, int leftOffset, int bottomOffset, int rightOffset, short angle) {
            this.imageData = imageData;
            this.angle = angle;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintImage imageElement;
        private final RenderersCache imageRenderersCache;
        private final int availableImageWidth;
        private final int availableImageHeight;

        protected InternalImageProcessor(JRPrintImage imageElement, int availableImageWidth, int availableImageHeight) {
            this.imageElement = imageElement;
            this.imageRenderersCache = imageElement.isUsingCache() ? JRXlsMetadataExporter.this.renderersCache : new RenderersCache(JRXlsMetadataExporter.this.getJasperReportsContext());
            this.availableImageWidth = availableImageWidth;
            this.availableImageHeight = availableImageHeight;
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException {
            InternalImageProcessorResult imageProcessorResult = null;
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            switch (this.imageElement.getScaleImageValue()) {
                case CLIP: {
                    imageProcessorResult = this.processImageClip(this.imageRenderersCache.getGraphics2DRenderable(renderer));
                    break;
                }
                case FILL_FRAME: {
                    Dimension dimension = null;
                    dimension = this.imageElement.getRotation() == RotationEnum.LEFT || this.imageElement.getRotation() == RotationEnum.RIGHT ? new Dimension(this.availableImageHeight, this.availableImageWidth) : new Dimension(this.availableImageWidth, this.availableImageHeight);
                    imageProcessorResult = this.processImageFillFrame(JRXlsMetadataExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, dimension, ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null));
                    break;
                }
                default: {
                    Dimension dimension = null;
                    dimension = this.imageElement.getRotation() == RotationEnum.LEFT || this.imageElement.getRotation() == RotationEnum.RIGHT ? new Dimension(this.availableImageHeight, this.availableImageWidth) : new Dimension(this.availableImageWidth, this.availableImageHeight);
                    imageProcessorResult = this.processImageRetainShape(JRXlsMetadataExporter.this.getRendererUtil().getImageDataRenderable(this.imageRenderersCache, renderer, dimension, ModeEnum.OPAQUE == this.imageElement.getModeValue() ? this.imageElement.getBackcolor() : null));
                    break;
                }
            }
            return imageProcessorResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InternalImageProcessorResult processImageClip(Graphics2DRenderable renderer) throws JRException {
            Dimension2D dimension;
            int normalWidth = this.availableImageWidth;
            int normalHeight = this.availableImageHeight;
            DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable((Renderable)((Object)renderer));
            Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(JRXlsMetadataExporter.this.jasperReportsContext);
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            int minWidth = 0;
            int minHeight = 0;
            int topOffset = 0;
            int leftOffset = 0;
            int bottomOffset = 0;
            int rightOffset = 0;
            int translateX = 0;
            int translateY = 0;
            short angle = 0;
            switch (this.imageElement.getRotation()) {
                case LEFT: {
                    if (dimension == null) {
                        normalWidth = this.availableImageHeight;
                        normalHeight = this.availableImageWidth;
                    }
                    minWidth = Math.min(normalWidth, this.availableImageHeight);
                    minHeight = Math.min(normalHeight, this.availableImageWidth);
                    topOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - normalWidth));
                    leftOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageWidth - normalHeight));
                    bottomOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageHeight - normalWidth));
                    rightOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - normalHeight));
                    translateX = bottomOffset;
                    translateY = leftOffset;
                    angle = -90;
                    break;
                }
                case RIGHT: {
                    if (dimension == null) {
                        normalWidth = this.availableImageHeight;
                        normalHeight = this.availableImageWidth;
                    }
                    minWidth = Math.min(normalWidth, this.availableImageHeight);
                    minHeight = Math.min(normalHeight, this.availableImageWidth);
                    topOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageHeight - normalWidth));
                    leftOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - normalHeight));
                    bottomOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - normalWidth));
                    rightOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageWidth - normalHeight));
                    translateX = topOffset;
                    translateY = rightOffset;
                    angle = 90;
                    break;
                }
                case UPSIDE_DOWN: {
                    minWidth = Math.min(normalWidth, this.availableImageWidth);
                    minHeight = Math.min(normalHeight, this.availableImageHeight);
                    topOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - normalHeight));
                    leftOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - normalWidth));
                    bottomOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageHeight - normalHeight));
                    translateX = rightOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageWidth - normalWidth));
                    translateY = bottomOffset;
                    angle = 180;
                    break;
                }
                default: {
                    minWidth = Math.min(normalWidth, this.availableImageWidth);
                    minHeight = Math.min(normalHeight, this.availableImageHeight);
                    topOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageHeight - normalHeight));
                    leftOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageWidth - normalWidth));
                    bottomOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - normalHeight));
                    rightOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - normalWidth));
                    translateX = leftOffset;
                    translateY = topOffset;
                    angle = 0;
                }
            }
            int dpi = JRXlsMetadataExporter.this.getPropertiesUtil().getIntegerProperty("net.sf.jasperreports.image.dpi", 72);
            double scale = (double)dpi / 72.0;
            BufferedImage bi = new BufferedImage((int)(scale * (double)minWidth), (int)(scale * (double)minHeight), 2);
            Graphics2D grx = bi.createGraphics();
            try {
                grx.scale(scale, scale);
                grx.clip(new Rectangle(0, 0, minWidth, minHeight));
                renderer.render(JRXlsMetadataExporter.this.jasperReportsContext, grx, new Rectangle(translateX > 0 ? 0 : translateX, translateY > 0 ? 0 : translateY, normalWidth, normalHeight));
            }
            finally {
                grx.dispose();
            }
            return new InternalImageProcessorResult(JRImageLoader.getInstance(JRXlsMetadataExporter.this.jasperReportsContext).loadBytesFromAwtImage(bi, ImageTypeEnum.PNG), topOffset < 0 ? 0 : topOffset, leftOffset < 0 ? 0 : leftOffset, bottomOffset < 0 ? 0 : bottomOffset, rightOffset < 0 ? 0 : rightOffset, angle);
        }

        private InternalImageProcessorResult processImageFillFrame(DataRenderable renderer) throws JRException {
            short angle = 0;
            switch (this.imageElement.getRotation()) {
                case LEFT: {
                    angle = -90;
                    break;
                }
                case RIGHT: {
                    angle = 90;
                    break;
                }
                case UPSIDE_DOWN: {
                    angle = 180;
                    break;
                }
                default: {
                    angle = 0;
                }
            }
            return new InternalImageProcessorResult(renderer.getData(JRXlsMetadataExporter.this.jasperReportsContext), 0, 0, 0, 0, angle);
        }

        private InternalImageProcessorResult processImageRetainShape(DataRenderable renderer) throws JRException {
            Dimension2D dimension;
            float normalWidth = this.availableImageWidth;
            float normalHeight = this.availableImageHeight;
            DimensionRenderable dimensionRenderer = this.imageRenderersCache.getDimensionRenderable((Renderable)((Object)renderer));
            Dimension2D dimension2D = dimension = dimensionRenderer == null ? null : dimensionRenderer.getDimension(JRXlsMetadataExporter.this.jasperReportsContext);
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            float ratioX = 1.0f;
            float ratioY = 1.0f;
            int imageWidth = 0;
            int imageHeight = 0;
            int topOffset = 0;
            int leftOffset = 0;
            int bottomOffset = 0;
            int rightOffset = 0;
            short angle = 0;
            switch (this.imageElement.getRotation()) {
                case LEFT: {
                    ratioX = (float)this.availableImageWidth / normalHeight;
                    ratioY = (float)this.availableImageHeight / normalWidth;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalHeight * ratioX);
                    imageHeight = (int)(normalWidth * ratioY);
                    topOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    angle = -90;
                    break;
                }
                case RIGHT: {
                    ratioX = (float)this.availableImageWidth / normalHeight;
                    ratioY = (float)this.availableImageHeight / normalWidth;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalHeight * ratioX);
                    imageHeight = (int)(normalWidth * ratioY);
                    topOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    angle = 90;
                    break;
                }
                case UPSIDE_DOWN: {
                    ratioX = (float)this.availableImageWidth / normalWidth;
                    ratioY = (float)this.availableImageHeight / normalHeight;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalWidth * ratioX);
                    imageHeight = (int)(normalHeight * ratioY);
                    topOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    angle = 180;
                    break;
                }
                default: {
                    ratioX = (float)this.availableImageWidth / normalWidth;
                    ratioY = (float)this.availableImageHeight / normalHeight;
                    ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                    imageWidth = (int)(normalWidth * ratioX);
                    imageHeight = (int)(normalHeight * ratioY);
                    topOffset = (int)(ImageUtil.getYAlignFactor(this.imageElement) * (float)(this.availableImageHeight - imageHeight));
                    leftOffset = (int)(ImageUtil.getXAlignFactor(this.imageElement) * (float)(this.availableImageWidth - imageWidth));
                    bottomOffset = (int)((1.0f - ImageUtil.getYAlignFactor(this.imageElement)) * (float)(this.availableImageHeight - imageHeight));
                    rightOffset = (int)((1.0f - ImageUtil.getXAlignFactor(this.imageElement)) * (float)(this.availableImageWidth - imageWidth));
                    angle = 0;
                }
            }
            return new InternalImageProcessorResult(renderer.getData(JRXlsMetadataExporter.this.jasperReportsContext), topOffset, leftOffset, bottomOffset, rightOffset, angle);
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRXlsExporterContext {
        protected ExporterContext() {
        }
    }
}

