/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.service;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.api.SearchService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchService
implements SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSearchService.class);
    private final BundleContext bundleContext;

    public DefaultSearchService(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> query(SearchQuery query) {
        HashMap<SearchContext, SearchResult> resultMap;
        block12: {
            Objects.requireNonNull(query);
            if (query.getMaxResults() <= 0) {
                query.setMaxResults(10);
            }
            if (Strings.isNullOrEmpty((String)query.getInput()) || query.getInput().length() < 1) {
                return Collections.emptyList();
            }
            resultMap = new HashMap<SearchContext, SearchResult>();
            try {
                ServiceReference[] allServiceReferences = this.bundleContext.getServiceReferences(SearchProvider.class.getCanonicalName(), null);
                if (allServiceReferences == null) break block12;
                for (ServiceReference eachReference : allServiceReferences) {
                    SearchProvider service = (SearchProvider)this.bundleContext.getService(eachReference);
                    if (query.getContext() != null && !service.getContext().contributesTo(query.getContext())) continue;
                    try {
                        SearchResult providerResult = service.query(query);
                        if (resultMap.containsKey(providerResult.getContext())) {
                            SearchResult mergedResult = (SearchResult)resultMap.get(providerResult.getContext());
                            for (SearchResultItem eachItem : providerResult.getResults()) {
                                mergedResult.setMore(providerResult.hasMore() || mergedResult.hasMore());
                                mergedResult.addItem(eachItem);
                            }
                            continue;
                        }
                        resultMap.put(providerResult.getContext(), providerResult);
                    }
                    catch (Exception ex) {
                        LOG.error("Could not execute query for provider", (Throwable)ex);
                    }
                    finally {
                        this.bundleContext.ungetService(eachReference);
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                LOG.error("Could not fetch search providers", (Throwable)e);
            }
        }
        List<SearchResult> searchResultList = resultMap.values().stream().filter(searchResult -> !searchResult.isEmpty()).map(searchResult -> {
            List limitedAndSortedItems = searchResult.getResults().stream().sorted(Comparator.comparing(SearchResultItem::getWeight).reversed().thenComparing(SearchResultItem::getLabel)).limit(query.getMaxResults()).collect(Collectors.toList());
            return new SearchResult(searchResult.getContext()).withMore(searchResult.hasMore()).withResults(limitedAndSortedItems);
        }).sorted(Comparator.comparingInt(searchResult -> searchResult.getContext().getWeight())).collect(Collectors.toList());
        return searchResultList;
    }
}

