/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.opennms.features.elastic.client.model.BulkOperation;
import org.opennms.features.elastic.client.model.BulkRequest;
import org.opennms.features.elastic.client.model.BulkResponse;
import org.opennms.features.elastic.client.model.SearchRequest;
import org.opennms.features.elastic.client.model.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultElasticRestClient
implements ElasticRestClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultElasticRestClient.class);
    private static final long[] RETRY_SLEEP_MULTIPLIERS = new long[]{1L, 2L, 10L, 20L, 60L, 120L};
    private int bulkRetryCount;
    private int connTimeout;
    private int readTimeout;
    private int retryCooldown;
    private final AtomicInteger threadCountForBulk = new AtomicInteger(1);
    private final ThreadFactory bulkExecuteThreadFactory = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("elastic-client-async-bulk-execute-" + this.threadCountForBulk.getAndIncrement());
        return thread;
    };
    private final ExecutorService executor = Executors.newCachedThreadPool(this.bulkExecuteThreadFactory);
    private final AtomicInteger threadCountForSearch = new AtomicInteger(1);
    private final ThreadFactory bulkSearchThreadFactory = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("elastic-client-search-async-" + this.threadCountForSearch.getAndIncrement());
        return thread;
    };
    private final ExecutorService searchExecutor = Executors.newCachedThreadPool(this.bulkSearchThreadFactory);
    private final String[] hosts;
    private final String username;
    private final String password;
    private RestClient restClient;
    private final Gson gson = new Gson();

    public void setBulkRetryCount(int bulkRetryCount) {
        this.bulkRetryCount = bulkRetryCount;
    }

    public int getBulkRetryCount() {
        return this.bulkRetryCount;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setRetryCooldown(int retryCooldown) {
        this.retryCooldown = retryCooldown;
    }

    public int getRetryCooldown() {
        return this.retryCooldown;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public DefaultElasticRestClient(String[] hosts) {
        this(hosts, null, null);
        this.init();
    }

    public DefaultElasticRestClient(String hostsString, String username, String password) {
        if (hostsString == null || hostsString.trim().isEmpty()) {
            throw new IllegalArgumentException("Hosts string must be specified");
        }
        this.hosts = (String[])Arrays.stream(hostsString.split(",")).map(String::trim).filter(h -> !h.isEmpty()).toArray(String[]::new);
        this.username = username != null && !username.isEmpty() ? username : null;
        this.password = password != null && !password.isEmpty() ? password : null;
        this.init();
    }

    public DefaultElasticRestClient(String[] hosts, String username, String password) {
        if (hosts == null || hosts.length == 0) {
            throw new IllegalArgumentException("At least one host must be specified");
        }
        this.hosts = Arrays.copyOf(hosts, hosts.length);
        this.username = username;
        this.password = password;
        this.init();
    }

    public void init() {
        HttpHost[] httpHosts = (HttpHost[])Arrays.stream(this.hosts).map(host -> {
            try {
                int port;
                URI uri = host.contains("://") ? new URI((String)host) : new URI("http://" + host);
                String scheme = uri.getScheme() != null ? uri.getScheme() : "http";
                String hostname = uri.getHost();
                int n = port = uri.getPort() != -1 ? uri.getPort() : 9200;
                if (hostname == null) {
                    throw new IllegalArgumentException("Invalid host: " + host);
                }
                return new HttpHost(hostname, port, scheme);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid Elasticsearch host: " + host, e);
            }
        }).toArray(HttpHost[]::new);
        if (this.username != null && this.password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            this.restClient = RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.connTimeout).setSocketTimeout(this.readTimeout)).setHttpClientConfigCallback(arg_0 -> DefaultElasticRestClient.lambda$init$7((CredentialsProvider)credentialsProvider, arg_0)).build();
        } else {
            this.restClient = RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.connTimeout).setSocketTimeout(this.readTimeout)).build();
        }
    }

    @Override
    public String health() throws IOException {
        Request healthRequest = new Request("GET", "/_cluster/health");
        Response healthResponse = this.restClient.performRequest(healthRequest);
        int statusCode = healthResponse.getStatusLine().getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            String responseBody = EntityUtils.toString((HttpEntity)healthResponse.getEntity());
            JsonObject healthJson = JsonParser.parseReader((Reader)new StringReader(responseBody)).getAsJsonObject();
            String status = healthJson.get("status").getAsString();
            LOG.debug("Elasticsearch cluster health: {}", (Object)status);
            return status;
        }
        throw new IOException("Failed to get cluster health: HTTP " + statusCode);
    }

    @Override
    public Map<String, String> listTemplates() throws IOException {
        HashMap<String, String> templates = new HashMap<String, String>();
        try {
            String responseBody;
            JsonObject templatesJson;
            Request request = new Request("GET", "/_index_template");
            Response response = this.restClient.performRequest(request);
            if (response.getStatusLine().getStatusCode() == 200 && (templatesJson = JsonParser.parseReader((Reader)new StringReader(responseBody = EntityUtils.toString((HttpEntity)response.getEntity()))).getAsJsonObject()).has("index_templates")) {
                JsonArray templateArray = templatesJson.getAsJsonArray("index_templates");
                for (JsonElement element : templateArray) {
                    JsonObject template = element.getAsJsonObject();
                    String name = template.get("name").getAsString();
                    templates.put(name, template.toString());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to list templates: {}", (Object)e.getMessage(), (Object)e);
        }
        return templates;
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        this.searchExecutor.shutdown();
        if (this.restClient != null) {
            LOG.info("Closing Elasticsearch client");
            this.restClient.close();
        }
    }

    @Override
    public boolean applyILMPolicy(String policyName, String policyBody) throws IOException {
        LOG.info("Applying ILM policy '{}' to Elasticsearch cluster", (Object)policyName);
        try {
            boolean acknowledged;
            Request request = new Request("PUT", "/_ilm/policy/" + policyName);
            request.setJsonEntity(policyBody);
            Response response = this.restClient.performRequest(request);
            int statusCode = response.getStatusLine().getStatusCode();
            boolean bl = acknowledged = statusCode >= 200 && statusCode < 300;
            if (acknowledged) {
                LOG.info("ILM policy '{}' successfully applied", (Object)policyName);
            } else {
                LOG.warn("ILM policy '{}' application not acknowledged, status code: {}", (Object)policyName, (Object)statusCode);
            }
            return acknowledged;
        }
        catch (Exception e) {
            LOG.error("Failed to apply ILM policy '{}': {}", new Object[]{policyName, e.getMessage(), e});
            throw e;
        }
    }

    @Override
    public boolean applyComponentTemplate(String componentName, String componentBody) throws IOException {
        LOG.info("Applying component template '{}' to Elasticsearch cluster", (Object)componentName);
        LOG.debug("Component template body: {}", (Object)componentBody);
        try {
            boolean acknowledged;
            Request request = new Request("PUT", "/_component_template/" + componentName);
            request.setJsonEntity(componentBody);
            Response response = this.restClient.performRequest(request);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.info("Component template response (status: {}): {}", (Object)statusCode, (Object)responseBody);
            boolean bl = acknowledged = statusCode >= 200 && statusCode < 300;
            if (acknowledged) {
                LOG.info("Component template {}' successfully applied", (Object)componentName);
            } else {
                LOG.warn("Component template '{}' application not acknowledged, status code: {}", (Object)componentName, (Object)statusCode);
            }
            return acknowledged;
        }
        catch (Exception e) {
            LOG.error("Failed to apply component template '{}': {}", new Object[]{componentName, e.getMessage(), e});
            throw e;
        }
    }

    @Override
    public boolean applyComposableIndexTemplate(String templateName, String templateBody) throws IOException {
        LOG.info("Applying composable index template '{}' to Elasticsearch cluster", (Object)templateName);
        try {
            boolean acknowledged;
            Request request = new Request("PUT", "/_index_template/" + templateName);
            request.setJsonEntity(templateBody);
            Response response = this.restClient.performRequest(request);
            int statusCode = response.getStatusLine().getStatusCode();
            boolean bl = acknowledged = statusCode >= 200 && statusCode < 300;
            if (acknowledged) {
                LOG.info("Composable index template '{}' successfully applied", (Object)templateName);
            } else {
                LOG.warn("Composable index template '{}' application not acknowledged, status code: {}", (Object)templateName, (Object)statusCode);
            }
            return acknowledged;
        }
        catch (Exception e) {
            LOG.error("Failed to apply composable index template '{}': {}", new Object[]{templateName, e.getMessage(), e});
            throw e;
        }
    }

    @Override
    public int applyAllTemplatesFromDirectory(String templateDirectory) throws IOException {
        List<File> jsonFiles;
        int appliedCount = 0;
        File directory = new File(templateDirectory);
        if (!directory.exists() || !directory.isDirectory()) {
            LOG.error("Template directory does not exist or is not a directory: {}", (Object)templateDirectory);
            return 0;
        }
        try (Stream<Path> paths = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            jsonFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).map(Path::toFile).toList();
        }
        catch (IOException e) {
            LOG.error("Error walking through template directory: {}", (Object)e.getMessage());
            return 0;
        }
        if (jsonFiles.isEmpty()) {
            LOG.info("No template files found in {}", (Object)directory.getAbsolutePath());
            return 0;
        }
        LOG.info("Found {} template files", (Object)jsonFiles.size());
        ArrayList<File> ilmPolicyFiles = new ArrayList<File>();
        ArrayList<File> componentTemplateFiles = new ArrayList<File>();
        ArrayList<File> indexTemplateFiles = new ArrayList<File>();
        for (File file : jsonFiles) {
            String fileName = file.getName().toLowerCase();
            if (fileName.contains("ilm") || fileName.contains("policy") || fileName.contains("lifecycle")) {
                ilmPolicyFiles.add(file);
                continue;
            }
            if (fileName.contains("component") || fileName.contains("setting") || fileName.contains("mapping") || fileName.contains("alias")) {
                componentTemplateFiles.add(file);
                continue;
            }
            if (fileName.contains("composable") || fileName.contains("index")) {
                indexTemplateFiles.add(file);
                continue;
            }
            LOG.warn("Unknown template type for file: {}", (Object)fileName);
        }
        LOG.info("Processing {} ILM policy files", (Object)ilmPolicyFiles.size());
        for (File policyFile : ilmPolicyFiles) {
            try {
                String policyName = policyFile.getName().replaceAll("\\.json$", "");
                String policyContent = Files.readString(policyFile.toPath(), StandardCharsets.UTF_8);
                if (this.applyILMPolicy(policyName, policyContent)) {
                    LOG.info("Successfully applied ILM policy: {}", (Object)policyName);
                    ++appliedCount;
                    continue;
                }
                LOG.warn("Failed to apply ILM policy: {}", (Object)policyName);
            }
            catch (Exception e) {
                LOG.error("Error applying ILM policy from file {}: {}", new Object[]{policyFile.getName(), e.getMessage(), e});
            }
        }
        LOG.info("Processing {} component template files", (Object)componentTemplateFiles.size());
        for (File componentFile : componentTemplateFiles) {
            try {
                String componentName = componentFile.getName().replaceAll("\\.json$", "");
                String componentContent = Files.readString(componentFile.toPath(), StandardCharsets.UTF_8);
                if (this.applyComponentTemplate(componentName, componentContent)) {
                    LOG.info("Successfully applied component template: {}", (Object)componentName);
                    ++appliedCount;
                    continue;
                }
                LOG.warn("Failed to apply component template: {}", (Object)componentName);
            }
            catch (Exception e) {
                LOG.error("Error applying component template from file {}: {}", new Object[]{componentFile.getName(), e.getMessage(), e});
            }
        }
        LOG.info("Processing {} index template files", (Object)indexTemplateFiles.size());
        for (File templateFile : indexTemplateFiles) {
            try {
                String templateName = templateFile.getName().replaceAll("\\.json$", "");
                String templateContent = Files.readString(templateFile.toPath(), StandardCharsets.UTF_8);
                if (this.applyComposableIndexTemplate(templateName, templateContent)) {
                    LOG.info("Successfully applied index template: {}", (Object)templateName);
                    ++appliedCount;
                    continue;
                }
                LOG.warn("Failed to apply index template: {}", (Object)templateName);
            }
            catch (Exception e) {
                LOG.error("Error applying index template from file {}: {}", new Object[]{templateFile.getName(), e.getMessage(), e});
            }
        }
        LOG.info("Successfully applied {} templates/policies from {}", (Object)appliedCount, (Object)templateDirectory);
        return appliedCount;
    }

    @Override
    public BulkResponse executeBulk(BulkRequest bulkRequest) throws IOException {
        if (bulkRequest.isEmpty()) {
            return new BulkResponse(false, new ArrayList<BulkResponse.BulkItemResponse>(), 0L);
        }
        LOG.debug("Executing bulk request with {} operations", (Object)bulkRequest.size());
        String bulkBody = this.buildBulkRequestBody(bulkRequest);
        BulkResponse response = null;
        IOException lastException = null;
        for (int retry = 0; retry <= this.bulkRetryCount; ++retry) {
            try {
                response = this.executeBulkRequest(bulkBody, bulkRequest.getRefresh());
                if (!response.hasErrors() || this.bulkRetryCount == 0) {
                    return response;
                }
                if (!this.hasRetriableErrors(response) || retry >= this.bulkRetryCount) {
                    return response;
                }
                LOG.warn("Bulk request had errors, retrying... (attempt {} of {})", (Object)(retry + 1), (Object)(this.bulkRetryCount + 1));
                this.waitBeforeRetrying(retry);
                continue;
            }
            catch (IOException e) {
                lastException = e;
                if (retry < this.bulkRetryCount) {
                    LOG.warn("Bulk request failed, retrying... (attempt {} of {})", new Object[]{retry + 1, this.bulkRetryCount + 1, e});
                    this.waitBeforeRetrying(retry);
                    continue;
                }
                throw e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return response;
    }

    private String buildBulkRequestBody(BulkRequest bulkRequest) {
        StringBuilder bulkBody = new StringBuilder();
        for (BulkOperation operation : bulkRequest.getOperations()) {
            JsonObject actionObject = new JsonObject();
            JsonObject actionParams = new JsonObject();
            actionParams.addProperty("_index", operation.getIndex());
            if (operation.getId() != null) {
                actionParams.addProperty("_id", operation.getId());
            }
            String actionName = operation.getType().name().toLowerCase();
            actionObject.add(actionName, (JsonElement)actionParams);
            bulkBody.append(this.gson.toJson((JsonElement)actionObject)).append("\n");
            if (operation.getType() == BulkOperation.Type.DELETE || operation.getSource() == null) continue;
            if (operation.getType() == BulkOperation.Type.UPDATE) {
                JsonObject updateDoc = new JsonObject();
                if (operation.getSource() instanceof String) {
                    updateDoc.add("doc", JsonParser.parseString((String)((String)operation.getSource())));
                } else {
                    updateDoc.add("doc", this.gson.toJsonTree(operation.getSource()));
                }
                updateDoc.addProperty("doc_as_upsert", Boolean.valueOf(true));
                bulkBody.append(this.gson.toJson((JsonElement)updateDoc)).append("\n");
                continue;
            }
            if (operation.getSource() instanceof String) {
                bulkBody.append(operation.getSource()).append("\n");
                continue;
            }
            bulkBody.append(this.gson.toJson(operation.getSource())).append("\n");
        }
        return bulkBody.toString();
    }

    private BulkResponse executeBulkRequest(String bulkBody, String refresh) throws IOException {
        Request request = new Request("POST", "/_bulk");
        if (refresh != null) {
            request.addParameter("refresh", refresh);
        }
        request.setJsonEntity(bulkBody);
        long startTime = System.currentTimeMillis();
        Response response = this.restClient.performRequest(request);
        long tookInMillis = System.currentTimeMillis() - startTime;
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Bulk request failed with status: " + response.getStatusLine().getStatusCode());
        }
        return this.parseBulkResponse(response, tookInMillis);
    }

    private boolean hasRetriableErrors(BulkResponse response) {
        if (!response.hasErrors()) {
            return false;
        }
        for (BulkResponse.BulkItemResponse item : response.getItems()) {
            int status;
            if (item.getError() == null || (status = item.getStatus()) == 429 || status == 503 || status == 504) continue;
            return false;
        }
        return true;
    }

    private void waitBeforeRetrying(int retryCount) {
        try {
            long sleepTime = this.getSleepTime(retryCount);
            if (sleepTime > 0L) {
                LOG.debug("Waiting {} ms before retrying", (Object)sleepTime);
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted while waiting for retry");
        }
    }

    private long getSleepTime(int retry) {
        int index = Math.min(retry, RETRY_SLEEP_MULTIPLIERS.length - 1);
        return (long)this.retryCooldown * RETRY_SLEEP_MULTIPLIERS[index];
    }

    @Override
    public CompletableFuture<BulkResponse> executeBulkAsync(BulkRequest bulkRequest) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.executeBulk(bulkRequest);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute bulk request", e);
            }
        }, this.executor);
    }

    private BulkResponse parseBulkResponse(Response response, long tookInMillis) throws IOException {
        if (response.getEntity() == null) {
            throw new IOException("Empty response from Elasticsearch");
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonObject responseJson = JsonParser.parseReader((Reader)new StringReader(responseBody)).getAsJsonObject();
        boolean hasErrors = responseJson.has("errors") && responseJson.get("errors").getAsBoolean();
        ArrayList<BulkResponse.BulkItemResponse> items = new ArrayList<BulkResponse.BulkItemResponse>();
        if (responseJson.has("items")) {
            JsonArray itemsArray = responseJson.getAsJsonArray("items");
            for (JsonElement itemElement : itemsArray) {
                JsonObject item = itemElement.getAsJsonObject();
                Map.Entry entry = (Map.Entry)item.entrySet().iterator().next();
                JsonObject opResult = ((JsonElement)entry.getValue()).getAsJsonObject();
                String index = opResult.has("_index") ? opResult.get("_index").getAsString() : null;
                String id = opResult.has("_id") ? opResult.get("_id").getAsString() : null;
                int status = opResult.has("status") ? opResult.get("status").getAsInt() : 200;
                String error = null;
                if (opResult.has("error")) {
                    JsonElement errorElement = opResult.get("error");
                    error = errorElement.isJsonObject() ? errorElement.getAsJsonObject().toString() : errorElement.getAsString();
                }
                items.add(new BulkResponse.BulkItemResponse(index, id, status, error));
            }
        }
        return new BulkResponse(hasErrors, items, tookInMillis);
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        String indexPath = String.join((CharSequence)",", searchRequest.getIndices());
        Request request = new Request("POST", "/" + indexPath + "/_search");
        for (Map.Entry<String, String> param : searchRequest.getParameters().entrySet()) {
            request.addParameter(param.getKey(), param.getValue());
        }
        request.setJsonEntity(searchRequest.getQuery());
        long startTime = System.currentTimeMillis();
        Response response = this.restClient.performRequest(request);
        long tookInMillis = System.currentTimeMillis() - startTime;
        return this.parseSearchResponse(response, tookInMillis);
    }

    @Override
    public CompletableFuture<SearchResponse> searchAsync(SearchRequest searchRequest) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.search(searchRequest);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to execute search request", e);
            }
        }, this.searchExecutor);
    }

    private SearchResponse parseSearchResponse(Response response, long tookInMillis) throws IOException {
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonObject responseJson = JsonParser.parseReader((Reader)new StringReader(responseBody)).getAsJsonObject();
        boolean timedOut = responseJson.has("timed_out") && responseJson.get("timed_out").getAsBoolean();
        JsonObject shards = responseJson.has("_shards") ? responseJson.getAsJsonObject("_shards") : new JsonObject();
        JsonObject aggregations = responseJson.has("aggregations") ? responseJson.getAsJsonObject("aggregations") : null;
        String scrollId = responseJson.has("_scroll_id") ? responseJson.get("_scroll_id").getAsString() : null;
        SearchResponse.SearchHits hits = null;
        if (responseJson.has("hits")) {
            hits = this.parseSearchHits(responseJson.getAsJsonObject("hits"));
        }
        return new SearchResponse(tookInMillis, timedOut, shards, hits, aggregations, scrollId);
    }

    private SearchResponse.SearchHits parseSearchHits(JsonObject hitsObject) {
        long totalHits = 0L;
        String totalHitsRelation = "eq";
        if (hitsObject.has("total")) {
            JsonElement totalElement = hitsObject.get("total");
            if (totalElement.isJsonObject()) {
                JsonObject totalObject = totalElement.getAsJsonObject();
                totalHits = totalObject.has("value") ? totalObject.get("value").getAsLong() : 0L;
                totalHitsRelation = totalObject.has("relation") ? totalObject.get("relation").getAsString() : "eq";
            } else {
                totalHits = totalElement.getAsLong();
            }
        }
        double maxScore = hitsObject.has("max_score") && !hitsObject.get("max_score").isJsonNull() ? hitsObject.get("max_score").getAsDouble() : 0.0;
        ArrayList<SearchResponse.SearchHit> hits = new ArrayList<SearchResponse.SearchHit>();
        if (hitsObject.has("hits")) {
            JsonArray hitsArray = hitsObject.getAsJsonArray("hits");
            for (JsonElement hitElement : hitsArray) {
                JsonObject hit = hitElement.getAsJsonObject();
                String index = hit.has("_index") ? hit.get("_index").getAsString() : null;
                String id = hit.has("_id") ? hit.get("_id").getAsString() : null;
                double score = hit.has("_score") && !hit.get("_score").isJsonNull() ? hit.get("_score").getAsDouble() : 0.0;
                JsonObject source = hit.has("_source") ? hit.getAsJsonObject("_source") : new JsonObject();
                hits.add(new SearchResponse.SearchHit(index, id, score, source));
            }
        }
        return new SearchResponse.SearchHits(totalHits, totalHitsRelation, maxScore, hits);
    }

    @Override
    public boolean applyLegacyIndexTemplate(String templateName, String templateBody) throws IOException {
        Request request = new Request("PUT", "/_template/" + templateName);
        request.setJsonEntity(templateBody);
        Response response = this.restClient.performRequest(request);
        if (response.getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201) {
            LOG.info("Successfully applied legacy template: {}", (Object)templateName);
            return true;
        }
        LOG.error("Failed to apply legacy template: {}, status: {}", (Object)templateName, (Object)response.getStatusLine().getStatusCode());
        return false;
    }

    @Override
    public String getServerVersion() throws IOException {
        Request request = new Request("GET", "/");
        Response response = this.restClient.performRequest(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonObject json = JsonParser.parseString((String)responseBody).getAsJsonObject();
        JsonObject version = json.getAsJsonObject("version");
        if (version != null && version.has("number")) {
            return version.get("number").getAsString();
        }
        throw new IOException("Could not retrieve server version from response: " + responseBody);
    }

    @Override
    public boolean deleteIndex(String indices) throws IOException {
        try {
            boolean success;
            Request request = new Request("DELETE", "/" + indices);
            Response response = this.restClient.performRequest(request);
            int statusCode = response.getStatusLine().getStatusCode();
            boolean bl = success = statusCode >= 200 && statusCode < 300;
            if (success) {
                LOG.info("Successfully deleted indices: {}", (Object)indices);
            } else {
                LOG.warn("Failed to delete indices: {}, status code: {}", (Object)indices, (Object)statusCode);
            }
            return success;
        }
        catch (Exception e) {
            LOG.error("Failed to delete indices '{}'", (Object)indices, (Object)e);
            throw e;
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$init$7(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

