/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.graphml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLReader;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.generic.GenericGraphContainer;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.service.GraphContainerProvider;
import org.opennms.netmgt.graph.provider.graphml.GraphmlToGraphConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphmlGraphContainerProvider
implements GraphContainerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GraphmlGraphContainerProvider.class);
    private GenericGraphContainer graphContainer;

    public GraphmlGraphContainerProvider(String location) throws IOException, InvalidGraphException {
        if (!new File(location).exists()) {
            throw new FileNotFoundException(location);
        }
        try (FileInputStream input = new FileInputStream(location);){
            GraphML graphML = GraphMLReader.read((InputStream)input);
            this.graphContainer = new GraphmlToGraphConverter().convert(graphML);
        }
        String filename = Paths.get(location, new String[0]).getFileName().toString();
        String graphName = filename.substring(0, filename.lastIndexOf("."));
        if (!this.graphContainer.getId().equals(graphName)) {
            LOG.warn("The GraphML file name and the container id do not match but should. GraphML file name: '{}', container id: '{}'.", (Object)graphName, (Object)this.graphContainer.getId());
        }
    }

    public ImmutableGraphContainer loadGraphContainer() {
        return this.graphContainer;
    }

    public GraphContainerInfo getContainerInfo() {
        return this.graphContainer;
    }
}

