/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.shell;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.shell.AliasCompleter;

@Command(scope="opennms", name="scv-get", description="Retrieves the username and attributes for the given alias.")
@Service
public class ScvGetCommand
implements Action {
    @Reference
    public SecureCredentialsVault secureCredentialsVault;
    @Argument(index=0, name="alias", description="Alias used to retrieve the credentials.", required=true, multiValued=false)
    @Completion(value=AliasCompleter.class)
    public String alias = null;

    public Object execute() throws Exception {
        Credentials credentials = this.secureCredentialsVault.getCredentials(this.alias);
        if (credentials == null) {
            System.out.println("No credentials found for alias '" + this.alias + "'.");
        } else {
            System.out.printf("Credentials for %s:\n", this.alias);
            System.out.printf("\tUsername: %s\n", credentials.getUsername());
            System.out.printf("\tPassword: *********\n", new Object[0]);
            for (String attributeKey : credentials.getAttributeKeys()) {
                System.out.printf("\t%s: %s\n", attributeKey, credentials.getAttribute(attributeKey));
            }
        }
        return null;
    }
}

