/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.uri;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.glassfish.jersey.uri.PatternWithGroups;
import org.glassfish.jersey.uri.UriComponent;
import org.glassfish.jersey.uri.internal.UriTemplateParser;

public class UriTemplate {
    private static String[] EMPTY_VALUES = new String[0];
    public static final Comparator<UriTemplate> COMPARATOR = new Comparator<UriTemplate>(){

        @Override
        public int compare(UriTemplate o1, UriTemplate o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == EMPTY && o2 == EMPTY) {
                return 0;
            }
            if (o1 == EMPTY) {
                return 1;
            }
            if (o2 == EMPTY) {
                return -1;
            }
            int i = o2.getNumberOfExplicitCharacters() - o1.getNumberOfExplicitCharacters();
            if (i != 0) {
                return i;
            }
            i = o2.getNumberOfTemplateVariables() - o1.getNumberOfTemplateVariables();
            if (i != 0) {
                return i;
            }
            i = o2.getNumberOfExplicitRegexes() - o1.getNumberOfExplicitRegexes();
            if (i != 0) {
                return i;
            }
            return o2.pattern.getRegex().compareTo(o1.pattern.getRegex());
        }
    };
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{(\\w[-\\w\\.]*)\\}");
    public static final UriTemplate EMPTY = new UriTemplate();
    private final String template;
    private final String normalizedTemplate;
    private final PatternWithGroups pattern;
    private final boolean endsWithSlash;
    private final List<String> templateVariables;
    private final int numOfExplicitRegexes;
    private final int numOfCharacters;

    private UriTemplate() {
        this.normalizedTemplate = "";
        this.template = "";
        this.pattern = PatternWithGroups.EMPTY;
        this.endsWithSlash = false;
        this.templateVariables = Collections.emptyList();
        this.numOfCharacters = 0;
        this.numOfExplicitRegexes = 0;
    }

    public UriTemplate(String template) throws PatternSyntaxException, IllegalArgumentException {
        this(new UriTemplateParser(template));
    }

    protected UriTemplate(UriTemplateParser templateParser) throws PatternSyntaxException, IllegalArgumentException {
        this.template = templateParser.getTemplate();
        this.normalizedTemplate = templateParser.getNormalizedTemplate();
        this.pattern = UriTemplate.initUriPattern(templateParser);
        this.numOfExplicitRegexes = templateParser.getNumberOfExplicitRegexes();
        this.numOfCharacters = templateParser.getNumberOfLiteralCharacters();
        this.endsWithSlash = this.template.charAt(this.template.length() - 1) == '/';
        this.templateVariables = Collections.unmodifiableList(templateParser.getNames());
    }

    private static PatternWithGroups initUriPattern(UriTemplateParser templateParser) {
        return new PatternWithGroups(templateParser.getPattern(), templateParser.getGroupIndexes());
    }

    public static URI resolve(URI baseUri, String refUri) {
        return UriTemplate.resolve(baseUri, URI.create(refUri));
    }

    public static URI resolve(URI baseUri, URI refUri) {
        Preconditions.checkNotNull(baseUri, "Input base URI parameter must not be null.");
        Preconditions.checkNotNull(refUri, "Input reference URI parameter must not be null.");
        String refString = refUri.toString();
        if (refString.isEmpty()) {
            refUri = URI.create("#");
        } else if (refString.startsWith("?")) {
            String baseString = baseUri.toString();
            int qIndex = baseString.indexOf(63);
            baseString = qIndex > -1 ? baseString.substring(0, qIndex) : baseString;
            return URI.create(baseString + refString);
        }
        URI result = baseUri.resolve(refUri);
        if (refString.isEmpty()) {
            String resolvedString = result.toString();
            result = URI.create(resolvedString.substring(0, resolvedString.indexOf(35)));
        }
        return UriTemplate.normalize(result);
    }

    public static URI normalize(String uri) {
        return UriTemplate.normalize(URI.create(uri));
    }

    public static URI normalize(URI uri) {
        Preconditions.checkNotNull(uri, "Input reference URI parameter must not be null.");
        String path = uri.getPath();
        if (path == null || path.isEmpty() || !path.contains("/.")) {
            return uri;
        }
        String[] segments = path.split("/");
        ArrayDeque<String> resolvedSegments = new ArrayDeque<String>(segments.length);
        for (String segment : segments) {
            if (segment.length() == 0 || ".".equals(segment)) continue;
            if ("..".equals(segment)) {
                resolvedSegments.pollLast();
                continue;
            }
            resolvedSegments.offer(segment);
        }
        StringBuilder pathBuilder = new StringBuilder();
        for (String segment : resolvedSegments) {
            pathBuilder.append('/').append(segment);
        }
        String resultString = UriTemplate.createURIWithStringValues(uri.getScheme(), uri.getAuthority(), null, null, null, pathBuilder.toString(), uri.getQuery(), uri.getFragment(), EMPTY_VALUES, false, false);
        return URI.create(resultString);
    }

    public static URI relativize(URI baseUri, URI refUri) {
        Preconditions.checkNotNull(baseUri, "Input base URI parameter must not be null.");
        Preconditions.checkNotNull(refUri, "Input reference URI parameter must not be null.");
        return UriTemplate.normalize(baseUri.relativize(refUri));
    }

    public final String getTemplate() {
        return this.template;
    }

    public final PatternWithGroups getPattern() {
        return this.pattern;
    }

    public final boolean endsWithSlash() {
        return this.endsWithSlash;
    }

    public final List<String> getTemplateVariables() {
        return this.templateVariables;
    }

    public final boolean isTemplateVariablePresent(String name) {
        for (String s2 : this.templateVariables) {
            if (!s2.equals(name)) continue;
            return true;
        }
        return false;
    }

    public final int getNumberOfExplicitRegexes() {
        return this.numOfExplicitRegexes;
    }

    public final int getNumberOfExplicitCharacters() {
        return this.numOfCharacters;
    }

    public final int getNumberOfTemplateVariables() {
        return this.templateVariables.size();
    }

    public final boolean match(CharSequence uri, Map<String, String> templateVariableToValue) throws IllegalArgumentException {
        if (templateVariableToValue == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, this.templateVariables, templateVariableToValue);
    }

    public final boolean match(CharSequence uri, List<String> groupValues) throws IllegalArgumentException {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, groupValues);
    }

    public final String createURI(Map<String, String> values) {
        StringBuilder b = new StringBuilder();
        Matcher m3 = TEMPLATE_NAMES_PATTERN.matcher(this.normalizedTemplate);
        int i = 0;
        while (m3.find()) {
            b.append(this.normalizedTemplate, i, m3.start());
            String tValue = values.get(m3.group(1));
            if (tValue != null) {
                b.append(tValue);
            }
            i = m3.end();
        }
        b.append(this.normalizedTemplate, i, this.normalizedTemplate.length());
        return b.toString();
    }

    public final String createURI(String ... values) {
        return this.createURI(values, 0, values.length);
    }

    public final String createURI(String[] values, int offset, int length) {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        StringBuilder b = new StringBuilder();
        Matcher m3 = TEMPLATE_NAMES_PATTERN.matcher(this.normalizedTemplate);
        int v = offset;
        length += offset;
        int i = 0;
        while (m3.find()) {
            b.append(this.normalizedTemplate, i, m3.start());
            String tVariable = m3.group(1);
            String tValue = (String)mapValues.get(tVariable);
            if (tValue != null) {
                b.append(tValue);
            } else if (v < length && (tValue = values[v++]) != null) {
                mapValues.put(tVariable, tValue);
                b.append(tValue);
            }
            i = m3.end();
        }
        b.append(this.normalizedTemplate, i, this.normalizedTemplate.length());
        return b.toString();
    }

    public final String toString() {
        return this.pattern.toString();
    }

    public final int hashCode() {
        return this.pattern.hashCode();
    }

    public final boolean equals(Object o) {
        if (o instanceof UriTemplate) {
            UriTemplate that = (UriTemplate)o;
            return this.pattern.equals(that.pattern);
        }
        return false;
    }

    public static String createURI(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ?> values, boolean encode, boolean encodeSlashInPath) {
        HashMap<String, String> stringValues = new HashMap<String, String>();
        for (Map.Entry<String, ?> e : values.entrySet()) {
            if (e.getValue() == null) continue;
            stringValues.put(e.getKey(), e.getValue().toString());
        }
        return UriTemplate.createURIWithStringValues(scheme, authority, userInfo, host, port, path, query, fragment, stringValues, encode, encodeSlashInPath);
    }

    public static String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Map<String, ?> values, boolean encode, boolean encodeSlashInPath) {
        return UriTemplate.createURIWithStringValues(scheme, authority, userInfo, host, port, path, query, fragment, EMPTY_VALUES, encode, encodeSlashInPath, values);
    }

    public static String createURI(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, Object[] values, boolean encode, boolean encodeSlashInPath) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            stringValues[i] = values[i].toString();
        }
        return UriTemplate.createURIWithStringValues(scheme, authority, userInfo, host, port, path, query, fragment, stringValues, encode, encodeSlashInPath);
    }

    public static String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, String[] values, boolean encode, boolean encodeSlashInPath) {
        HashMap mapValues = new HashMap();
        return UriTemplate.createURIWithStringValues(scheme, authority, userInfo, host, port, path, query, fragment, values, encode, encodeSlashInPath, mapValues);
    }

    private static String createURIWithStringValues(String scheme, String authority, String userInfo, String host, String port, String path, String query, String fragment, String[] values, boolean encode, boolean encodeSlashInPath, Map<String, ?> mapValues) {
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        if (scheme != null) {
            offset = UriTemplate.createURIComponent(UriComponent.Type.SCHEME, scheme, values, offset, false, mapValues, sb);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != null) {
            sb.append("//");
            if (userInfo != null && userInfo.length() > 0) {
                offset = UriTemplate.createURIComponent(UriComponent.Type.USER_INFO, userInfo, values, offset, encode, mapValues, sb);
                sb.append('@');
            }
            if (host != null) {
                offset = UriTemplate.createURIComponent(UriComponent.Type.HOST, host, values, offset, encode, mapValues, sb);
            }
            if (port != null && port.length() > 0) {
                sb.append(':');
                offset = UriTemplate.createURIComponent(UriComponent.Type.PORT, port, values, offset, false, mapValues, sb);
            }
        } else if (authority != null) {
            sb.append("//");
            offset = UriTemplate.createURIComponent(UriComponent.Type.AUTHORITY, authority, values, offset, encode, mapValues, sb);
        }
        if (path != null && path.length() > 0) {
            if (sb.length() > 0 && path.charAt(0) != '/') {
                sb.append("/");
            }
            UriComponent.Type t = encodeSlashInPath ? UriComponent.Type.PATH_SEGMENT : UriComponent.Type.PATH;
            offset = UriTemplate.createURIComponent(t, path, values, offset, encode, mapValues, sb);
        }
        if (query != null && query.length() > 0) {
            sb.append('?');
            offset = UriTemplate.createURIComponent(UriComponent.Type.QUERY_PARAM, query, values, offset, encode, mapValues, sb);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            UriTemplate.createURIComponent(UriComponent.Type.FRAGMENT, fragment, values, offset, encode, mapValues, sb);
        }
        return sb.toString();
    }

    private static int createURIComponent(UriComponent.Type t, String template, String[] values, int offset, boolean encode, Map<String, ?> _mapValues, StringBuilder b) {
        Map<String, ?> mapValues = _mapValues;
        if (template.indexOf(123) == -1) {
            b.append(template);
            return offset;
        }
        template = new UriTemplateParser(template).getNormalizedTemplate();
        Matcher m3 = TEMPLATE_NAMES_PATTERN.matcher(template);
        int v = offset;
        int i = 0;
        while (m3.find()) {
            b.append(template, i, m3.start());
            String tVariable = m3.group(1);
            Object tValue = mapValues.get(tVariable);
            if (tValue == null && v < values.length) {
                tValue = values[v++];
            }
            if (tValue == null) {
                throw UriTemplate.templateVariableHasNoValue(tVariable);
            }
            mapValues.put(tVariable, tValue);
            tValue = encode ? UriComponent.encode(tValue.toString(), t) : UriComponent.contextualEncode(tValue.toString(), t);
            b.append(tValue);
            i = m3.end();
        }
        b.append(template, i, template.length());
        return v;
    }

    public static String resolveTemplateValues(UriComponent.Type type, String template, boolean encode, Map<String, ?> _mapValues) {
        if (template == null || template.isEmpty() || template.indexOf(123) == -1) {
            return template;
        }
        Map<String, ?> mapValues = _mapValues;
        StringBuilder sb = new StringBuilder();
        template = new UriTemplateParser(template).getNormalizedTemplate();
        Matcher m3 = TEMPLATE_NAMES_PATTERN.matcher(template);
        int i = 0;
        while (m3.find()) {
            sb.append(template, i, m3.start());
            String tVariable = m3.group(1);
            Object tValue = mapValues.get(tVariable);
            if (tValue != null) {
                tValue = encode ? UriComponent.encode(tValue.toString(), type) : UriComponent.contextualEncode(tValue.toString(), type);
                sb.append(tValue);
            } else {
                if (mapValues.containsKey(tVariable)) {
                    throw new IllegalArgumentException("The value associated of the template value map for key + " + tVariable + " is null.");
                }
                sb.append(m3.group());
            }
            i = m3.end();
        }
        sb.append(template, i, template.length());
        return sb.toString();
    }

    private static IllegalArgumentException templateVariableHasNoValue(String tVariable) {
        return new IllegalArgumentException("The template variable, " + tVariable + ", has no value");
    }
}

